/*
 * Decompiled with CFR 0.152.
 */
package gospl.algo.ipf.margin;

import core.metamodel.attribute.Attribute;
import core.metamodel.value.IValue;
import gospl.algo.ipf.margin.IMargin;
import gospl.algo.ipf.margin.MarginDescriptor;
import gospl.distribution.matrix.control.AControl;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class Margin<T extends Number>
implements IMargin<Attribute<? extends IValue>, IValue, T> {
    private final Attribute<? extends IValue> controlAttribute;
    private final Attribute<? extends IValue> seedAttribute;
    protected Map<MarginDescriptor, AControl<T>> marginalControl;

    protected Margin(Attribute<? extends IValue> attribute, Attribute<? extends IValue> attribute2) {
        this.controlAttribute = attribute;
        this.seedAttribute = attribute2;
        this.marginalControl = new HashMap<MarginDescriptor, AControl<T>>();
    }

    @Override
    public Collection<AControl<T>> getControls() {
        return Collections.unmodifiableCollection(this.marginalControl.values());
    }

    @Override
    public AControl<T> getControl(MarginDescriptor marginDescriptor) {
        return this.marginalControl.get(marginDescriptor);
    }

    @Override
    public Collection<MarginDescriptor> getMarginDescriptors() {
        return this.marginalControl.keySet();
    }

    @Override
    public Attribute<? extends IValue> getControlDimension() {
        return this.controlAttribute;
    }

    @Override
    public Attribute<? extends IValue> getSeedDimension() {
        return this.seedAttribute;
    }

    @Override
    public int size() {
        return this.marginalControl.size();
    }

    public String toString() {
        return String.valueOf(this.getClass().getSimpleName()) + " " + this.controlAttribute.getAttributeName() + (this.controlAttribute.equals(this.seedAttribute) ? "" : " (" + this.seedAttribute.getAttributeName() + ")");
    }

    protected void addMargin(MarginDescriptor marginDescriptor, AControl<T> aControl) {
        this.marginalControl.put(marginDescriptor, aControl);
    }
}

