/*
 * Decompiled with CFR 0.152.
 */
package gospl.algo.sr.ds;

import core.metamodel.attribute.Attribute;
import core.metamodel.io.GSSurveyType;
import core.metamodel.value.IValue;
import core.util.GSPerformanceUtil;
import gospl.algo.sr.ISyntheticReconstructionAlgo;
import gospl.distribution.GosplNDimensionalMatrixFactory;
import gospl.distribution.exception.IllegalDistributionCreation;
import gospl.distribution.matrix.INDimensionalMatrix;
import gospl.distribution.matrix.coordinate.ACoordinate;
import gospl.sampler.IDistributionSampler;
import gospl.sampler.ISampler;

public class DirectSamplingAlgo
implements ISyntheticReconstructionAlgo<IDistributionSampler> {
    @Override
    public ISampler<ACoordinate<Attribute<? extends IValue>, IValue>> inferSRSampler(INDimensionalMatrix<Attribute<? extends IValue>, IValue, Double> iNDimensionalMatrix, IDistributionSampler iDistributionSampler) throws IllegalDistributionCreation {
        if (iNDimensionalMatrix == null || iNDimensionalMatrix.getMatrix().isEmpty()) {
            throw new IllegalArgumentException("matrix passed in parameter cannot be null or empty");
        }
        if (!iNDimensionalMatrix.isSegmented() && GSSurveyType.LocalFrequencyTable.equals((Object)iNDimensionalMatrix.getMetaDataType())) {
            throw new IllegalDistributionCreation("can't create a sampler using only one matrix of GosplMetaDataType#LocalFrequencyTable");
        }
        int n3 = iNDimensionalMatrix.getDimensions().stream().mapToInt(attribute -> attribute.getValueSpace().getValues().size()).reduce(1, (n, n2) -> n * n2);
        GSPerformanceUtil gSPerformanceUtil = new GSPerformanceUtil("Compute independant-hypothesis-joint-distribution from conditional distribution\nTheoretical size = " + n3, GSPerformanceUtil.Level.DEBUG);
        gSPerformanceUtil.setObjectif(n3);
        gSPerformanceUtil.sysoStempPerformance(0, (Object)this);
        iDistributionSampler.setDistribution(GosplNDimensionalMatrixFactory.getFactory().createDistribution(iNDimensionalMatrix, gSPerformanceUtil));
        return iDistributionSampler;
    }
}

