/*
 * Decompiled with CFR 0.152.
 */
package gospl.distribution;

import core.metamodel.attribute.Attribute;
import core.metamodel.value.IValue;
import core.util.data.GSDataParser;
import core.util.exception.GenstarException;
import core.util.random.GenstarRandom;
import gospl.distribution.exception.IllegalDistributionCreation;
import gospl.distribution.matrix.AFullNDimensionalMatrix;
import gospl.distribution.matrix.ASegmentedNDimensionalMatrix;
import gospl.distribution.matrix.control.AControl;
import gospl.distribution.matrix.control.ControlFrequency;
import gospl.distribution.matrix.coordinate.ACoordinate;
import gospl.distribution.matrix.coordinate.GosplCoordinate;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class GosplConditionalDistribution
extends ASegmentedNDimensionalMatrix<Double> {
    protected GosplConditionalDistribution(Set<AFullNDimensionalMatrix<Double>> set) throws IllegalDistributionCreation {
        super(set);
    }

    @Override
    public AControl<Double> getVal(Collection<IValue> collection) {
        AControl<Double> aControl2 = this.getIdentityProductVal();
        Map map = collection.stream().filter(iValue -> !this.getDimension((IValue)iValue).getReferentAttribute().equals(iValue.getValueSpace().getAttribute()) && this.jointDistributionSet.stream().anyMatch(aFullNDimensionalMatrix -> aFullNDimensionalMatrix.getDimensions().contains(this.getDimension((IValue)iValue).getReferentAttribute()))).collect(Collectors.groupingBy(this::getDimension, Collectors.mapping(Function.identity(), Collectors.toSet())));
        map.forEach((attribute, set) -> {
            Set set2 = set.stream().flatMap(iValue -> attribute.findMappedAttributeValues((IValue)iValue).stream()).collect(Collectors.toSet());
            Set set3 = set2.stream().flatMap(iValue -> attribute.findMappedAttributeValues((IValue)iValue).stream()).collect(Collectors.toSet());
            if (!set.equals(set3)) {
                throw new IllegalArgumentException("Elicit a value for which this n dimensional matrix (" + this.getLabel() + ") has divergent information about");
            }
            collection.removeAll((Collection<?>)set);
            collection.addAll(set2);
        });
        Set set2 = collection.stream().map(this::getDimension).collect(Collectors.toSet());
        List<AFullNDimensionalMatrix> list = this.jointDistributionSet.stream().filter(aFullNDimensionalMatrix -> aFullNDimensionalMatrix.getDimensions().stream().anyMatch(set2::contains)).sorted((aFullNDimensionalMatrix, aFullNDimensionalMatrix2) -> {
            int n = (int)(aFullNDimensionalMatrix.getDimensions().stream().filter(set2::contains).count() - aFullNDimensionalMatrix2.getDimensions().stream().filter(set2::contains).count());
            if (n > 0 || n == 0 && aFullNDimensionalMatrix.getDimensions().stream().filter(attribute -> set2.contains(attribute.getReferentAttribute()) && !attribute.getReferentAttribute().equals(attribute)).count() <= aFullNDimensionalMatrix2.getDimensions().stream().filter(attribute -> set2.contains(attribute.getReferentAttribute()) && !attribute.getReferentAttribute().equals(attribute)).count()) {
                return -1;
            }
            return 1;
        }).toList();
        HashSet<Attribute<? extends IValue>> hashSet = new HashSet<Attribute<? extends IValue>>();
        for (AFullNDimensionalMatrix aFullNDimensionalMatrix3 : list) {
            AControl<Double> aControl3;
            if (aFullNDimensionalMatrix3.getDimensions().stream().noneMatch(set2::contains)) continue;
            Set<IValue> set3 = collection.stream().filter(iValue -> aFullNDimensionalMatrix3.getDimensions().contains(iValue.getValueSpace().getAttribute())).collect(Collectors.toSet());
            Set<IValue> set4 = set3.stream().filter(iValue -> hashSet.stream().anyMatch(attribute -> attribute.getValueSpace().contains((IValue)iValue))).collect(Collectors.toSet());
            Map<Set<IValue>, AControl<Double>> map2 = this.estimateBottomUpReferences(aFullNDimensionalMatrix3, collection, hashSet);
            Map<Set<IValue>, AControl<Double>> map3 = this.estimateTopDownReferences(aFullNDimensionalMatrix3, collection, hashSet);
            if (Stream.concat(map2.values().stream(), map3.values().stream()).anyMatch(aControl -> (Double)aControl.getValue() > 1.0)) {
                throw new GenstarException("Some conditional probabilities exceed 1:\nBottomup: " + map2.entrySet().stream().map(Object::toString).collect(Collectors.joining("\n")) + "\nTopdown: " + map3.entrySet().stream().map(Object::toString).collect(Collectors.joining("\n")));
            }
            if (Stream.concat(map2.keySet().stream().flatMap(Collection::stream), map3.keySet().stream().flatMap(Collection::stream)).anyMatch(iValue -> this.getDimension((IValue)iValue).getEmptyValue().equals(iValue))) {
                return this.getNulVal();
            }
            Set set5 = Stream.concat(map2.keySet().stream().flatMap(Collection::stream), map3.keySet().stream().flatMap(Collection::stream)).collect(Collectors.toSet());
            set3.addAll(set5);
            AControl<Double> aControl4 = aFullNDimensionalMatrix3.getVal((Collection<IValue>)set3, true);
            set4.addAll(set5);
            AControl<Double> aControl5 = aControl3 = set4.isEmpty() ? this.getIdentityProductVal() : aFullNDimensionalMatrix3.getVal((Collection<IValue>)set4);
            if (aControl3.getValue().equals(this.getNulVal().getValue())) {
                return this.getNulVal();
            }
            aControl4.multiply(1.0 / aControl3.getValue());
            aControl2.multiply((Double)((Object)aControl4));
            Set set6 = set3.stream().filter(collection::contains).map(this::getDimension).collect(Collectors.toSet());
            hashSet.addAll(set6);
            set2.removeAll(set6);
        }
        return aControl2;
    }

    @Override
    public boolean addValue(ACoordinate<Attribute<? extends IValue>, IValue> aCoordinate, AControl<? extends Number> aControl) {
        Set set = this.jointDistributionSet.stream().filter(aFullNDimensionalMatrix -> aFullNDimensionalMatrix.getDimensions().equals(aCoordinate.getDimensions())).collect(Collectors.toSet());
        return ((AFullNDimensionalMatrix)set.iterator().next()).addValue(aCoordinate, aControl);
    }

    @Override
    public final boolean addValue(ACoordinate<Attribute<? extends IValue>, IValue> aCoordinate, Double d) {
        return this.addValue(aCoordinate, (AControl<? extends Number>)new ControlFrequency(d));
    }

    @Override
    public final boolean addValue(Double d, String ... stringArray) {
        return this.addValue(this.getCoordinate(stringArray), d);
    }

    @Override
    public boolean setValue(ACoordinate<Attribute<? extends IValue>, IValue> aCoordinate, AControl<? extends Number> aControl) {
        Set set = this.jointDistributionSet.stream().filter(aFullNDimensionalMatrix -> aFullNDimensionalMatrix.getDimensions().equals(aCoordinate.getDimensions())).collect(Collectors.toSet());
        if (set.size() != 1) {
            return false;
        }
        return ((AFullNDimensionalMatrix)set.iterator().next()).setValue(aCoordinate, aControl);
    }

    @Override
    public final boolean setValue(ACoordinate<Attribute<? extends IValue>, IValue> aCoordinate, Double d) {
        return this.setValue(aCoordinate, (AControl<? extends Number>)new ControlFrequency(d));
    }

    @Override
    public final boolean setValue(Double d, String ... stringArray) {
        return this.setValue((ACoordinate<Attribute<? extends IValue>, IValue>)GosplCoordinate.createCoordinate(this.getDimensions(), stringArray), d);
    }

    @Override
    public AControl<Double> getNulVal() {
        return new ControlFrequency(0.0);
    }

    @Override
    public AControl<Double> getIdentityProductVal() {
        return new ControlFrequency(1.0);
    }

    @Override
    public AControl<Double> getAtomicVal() {
        return ((AFullNDimensionalMatrix)this.jointDistributionSet.iterator().next()).getAtomicVal();
    }

    @Override
    public boolean isCoordinateCompliant(ACoordinate<Attribute<? extends IValue>, IValue> aCoordinate) {
        return this.jointDistributionSet.stream().anyMatch(aFullNDimensionalMatrix -> aFullNDimensionalMatrix.isCoordinateCompliant(aCoordinate));
    }

    @Override
    public Set<IValue> getEmptyReferentCorrelate(ACoordinate<Attribute<? extends IValue>, IValue> aCoordinate) {
        Object object2;
        HashSet hashSet = new HashSet();
        for (Object object2 : this.jointDistributionSet) {
            if (!((AFullNDimensionalMatrix)object2).getEmptyReferentCorrelate(aCoordinate).isEmpty()) continue;
            hashSet.addAll(aCoordinate.values().stream().filter(arg_0 -> this.lambda$31((AFullNDimensionalMatrix)object2, arg_0)).collect(Collectors.toSet()));
        }
        object2 = this.jointDistributionSet.stream().flatMap(aFullNDimensionalMatrix -> aFullNDimensionalMatrix.getEmptyReferentCorrelate(aCoordinate).stream()).collect(Collectors.toSet());
        object2.removeAll(hashSet.stream().map(iValue -> this.getDimension((IValue)iValue).getReferentAttribute().getEmptyValue()).collect(Collectors.toSet()));
        return object2;
    }

    @Override
    public AControl<Double> parseVal(GSDataParser gSDataParser, String string) {
        if (!gSDataParser.getValueType(string).isNumericValue()) {
            return this.getNulVal();
        }
        return new ControlFrequency(Double.valueOf(string));
    }

    @Override
    public void normalize() throws IllegalArgumentException {
        throw new IllegalArgumentException("should not normalize a " + (Object)((Object)this.getMetaDataType()));
    }

    @Override
    public boolean checkAllCoordinatesHaveValues() {
        return false;
    }

    @Override
    public boolean checkGlobalSum() {
        return this.jointDistributionSet.stream().allMatch(AFullNDimensionalMatrix::checkGlobalSum);
    }

    private Map<Set<IValue>, AControl<Double>> estimateBottomUpReferences(AFullNDimensionalMatrix<Double> aFullNDimensionalMatrix, Collection<IValue> collection, Set<Attribute<? extends IValue>> set2) {
        Map map = aFullNDimensionalMatrix.getDimensions().stream().filter(attribute -> !attribute.getReferentAttribute().equals(attribute) && set2.contains(attribute.getReferentAttribute())).collect(Collectors.groupingBy(Attribute::getReferentAttribute, Collectors.mapping(Function.identity(), Collectors.toSet())));
        HashMap<Attribute<? extends IValue>, Attribute<? extends IValue>> hashMap = new HashMap<Attribute<? extends IValue>, Attribute<? extends IValue>>();
        map.forEach((attribute3, set) -> {
            Attribute attribute4 = hashMap.put((Attribute<? extends IValue>)attribute3, set.stream().sorted((attribute, attribute2) -> attribute.getValueSpace().getValues().size() < attribute2.getValueSpace().getValues().size() ? -1 : (attribute.getValueSpace().getValues().size() > attribute2.getValueSpace().getValues().size() ? 1 : (GenstarRandom.getInstance().nextDouble() > 0.5 ? -1 : 1))).findFirst().orElse(null));
        });
        if (hashMap.isEmpty()) {
            return Collections.emptyMap();
        }
        Map<Set<IValue>, AControl<Double>> map2 = this.computeControlReferences(hashMap, collection, set2);
        Set set3 = map2.keySet().stream().flatMap(Collection::stream).filter(iValue -> !aFullNDimensionalMatrix.getDimensions().contains(iValue.getValueSpace().getAttribute())).map(this::getDimension).collect(Collectors.toSet());
        if (set3.stream().anyMatch(attribute -> aFullNDimensionalMatrix.getDimensions().stream().noneMatch(attribute2 -> attribute2.getReferentAttribute().equals(attribute)))) {
            throw new GenstarException("Estimated bottom up reference targeted dimension out of the concerned matrix:\nConcerned matrix dimensions = " + Arrays.toString(aFullNDimensionalMatrix.getDimensions().toArray()) + "\nTargeted dimensions = " + map2.keySet().stream().flatMap(set -> set.stream().map(iValue -> iValue.getValueSpace().getAttribute())).toList());
        }
        return map2;
    }

    private Map<Set<IValue>, AControl<Double>> estimateTopDownReferences(AFullNDimensionalMatrix<Double> aFullNDimensionalMatrix, Collection<IValue> collection, Set<Attribute<? extends IValue>> set) {
        Map<Attribute<? extends IValue>, Attribute<? extends IValue>> map = set.stream().filter(attribute -> !attribute.getReferentAttribute().equals(attribute) && aFullNDimensionalMatrix.getDimensions().contains(attribute.getReferentAttribute())).collect(Collectors.toMap(Function.identity(), Attribute::getReferentAttribute));
        if (map.isEmpty()) {
            return Collections.emptyMap();
        }
        Map<Set<IValue>, AControl<Double>> map2 = this.computeControlReferences(map, collection, set);
        if (map2.keySet().stream().flatMap(Collection::stream).anyMatch(iValue -> !aFullNDimensionalMatrix.getDimensions().contains(iValue.getValueSpace().getAttribute()))) {
            throw new GenstarException("Estimated bottom up reference targeted dimension out of the concerned matrix:\nConcerned matrix dimensions = " + Arrays.toString(aFullNDimensionalMatrix.getDimensions().toArray()) + "\nTargeted dimensions = " + map2.keySet().stream().flatMap(Collection::stream).toList());
        }
        return map2;
    }

    private Map<Set<IValue>, AControl<Double>> computeControlReferences(Map<Attribute<? extends IValue>, Attribute<? extends IValue>> map, Collection<IValue> collection, Set<Attribute<? extends IValue>> set) {
        Map map2 = collection.stream().filter(iValue -> set.contains(iValue.getValueSpace().getAttribute()) && map.containsKey(iValue.getValueSpace().getAttribute())).collect(Collectors.groupingBy(iValue -> (Attribute)map.get(iValue.getValueSpace().getAttribute()), Collectors.mapping(Function.identity(), Collectors.toSet())));
        HashMap<Set<IValue>, AControl<Double>> hashMap = new HashMap<Set<IValue>, AControl<Double>>();
        map.forEach((attribute, attribute2) -> {
            Attribute attribute3 = attribute.getReferentAttribute().equals(attribute2) ? attribute : attribute2;
            Set set = ((Set)map2.get(attribute2)).stream().flatMap(iValue -> attribute3.findMappedAttributeValues((IValue)iValue).stream()).collect(Collectors.toSet());
            Set<IValue> set2 = set.stream().flatMap(iValue -> attribute3.findMappedAttributeValues((IValue)iValue).stream()).collect(Collectors.toSet());
            AFullNDimensionalMatrix aFullNDimensionalMatrix2 = this.jointDistributionSet.stream().filter(aFullNDimensionalMatrix -> aFullNDimensionalMatrix.getDimensions().contains(attribute)).findAny().orElse(null);
            Set set3 = (Set)map2.get(attribute2);
            if (aFullNDimensionalMatrix2 != null) {
                if (set2.stream().anyMatch(iValue -> this.getDimension((IValue)iValue).getEmptyValue().equals(iValue))) {
                    hashMap.put(set, aFullNDimensionalMatrix2.getNulVal());
                } else {
                    hashMap.put(set, aFullNDimensionalMatrix2.getVal(set3).multiply(aFullNDimensionalMatrix2.getVal(set3).multiply(1.0 / (Double)aFullNDimensionalMatrix2.getVal((Collection<IValue>)set2).getValue())));
                }
            }
        });
        return hashMap;
    }

    private /* synthetic */ boolean lambda$31(AFullNDimensionalMatrix aFullNDimensionalMatrix, IValue iValue) {
        return aFullNDimensionalMatrix.getDimensions().stream().anyMatch(attribute -> this.getDimension(iValue).getReferentAttribute().equals(attribute));
    }
}

