/*
 * Decompiled with CFR 0.152.
 */
package gospl.distribution;

import core.configuration.GenstarConfigurationFile;
import core.metamodel.IPopulation;
import core.metamodel.attribute.Attribute;
import core.metamodel.entity.ADemoEntity;
import core.metamodel.io.GSSurveyType;
import core.metamodel.io.GSSurveyWrapper;
import core.metamodel.value.IValue;
import core.util.GSPerformanceUtil;
import gospl.GosplPopulation;
import gospl.distribution.GosplConditionalDistribution;
import gospl.distribution.GosplInputDataManager;
import gospl.distribution.exception.IllegalControlTotalException;
import gospl.distribution.exception.IllegalDistributionCreation;
import gospl.distribution.matrix.AFullNDimensionalMatrix;
import gospl.distribution.matrix.INDimensionalMatrix;
import gospl.io.GosplSurveyFactory;
import gospl.io.exception.InvalidSurveyFormatException;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.poi.openxml4j.exceptions.InvalidFormatException;

public class GosplInputMultiLayerDataManager
extends GosplInputDataManager {
    private GenstarConfigurationFile configuration;
    Map<Integer, Set<AFullNDimensionalMatrix<? extends Number>>> dataTables;
    Map<Integer, GosplPopulation> samples;

    public GosplInputMultiLayerDataManager(GenstarConfigurationFile genstarConfigurationFile) {
        super(genstarConfigurationFile);
        if (genstarConfigurationFile.getLevel() <= 1) {
            throw new IllegalArgumentException("Given configuration file should at least contains two level [actual =" + super.getConfiguration().getLevel() + "] of input data");
        }
    }

    public GosplInputMultiLayerDataManager(Path path) throws IllegalArgumentException, IOException {
        super(path);
        if (super.getConfiguration().getLevel() <= 1) {
            throw new IllegalArgumentException("Given configuration file should at least contains two level [actual = " + super.getConfiguration().getLevel() + "] of input data");
        }
    }

    @Override
    public void buildDataTables() throws InvalidFormatException, IOException, InvalidSurveyFormatException {
        GosplSurveyFactory gosplSurveyFactory = new GosplSurveyFactory();
        this.dataTables = new HashMap<Integer, Set<AFullNDimensionalMatrix<? extends Number>>>();
        for (int n : this.configuration.getLayers()) {
            for (GSSurveyWrapper gSSurveyWrapper : this.configuration.getSurveyWrappers(n)) {
                if (GSSurveyType.Sample.equals((Object)gSSurveyWrapper.getSurveyType())) continue;
                this.dataTables.put(n, GosplInputMultiLayerDataManager.getDataTables(gosplSurveyFactory.getSurvey(gSSurveyWrapper, this.configuration.getBaseDirectory()), this.configuration.getDictionary()));
            }
        }
    }

    @Override
    public void buildSamples() throws InvalidFormatException, IOException, InvalidSurveyFormatException {
        GosplSurveyFactory gosplSurveyFactory = new GosplSurveyFactory();
        this.samples = new HashMap<Integer, GosplPopulation>();
        for (int n : this.configuration.getLayers()) {
            for (GSSurveyWrapper gSSurveyWrapper : this.configuration.getSurveyWrappers(n)) {
                if (!GSSurveyType.Sample.equals((Object)gSSurveyWrapper.getSurveyType())) continue;
                this.samples.put(n, GosplInputMultiLayerDataManager.getSample(gosplSurveyFactory.getSurvey(gSSurveyWrapper, this.configuration.getBaseDirectory()), this.configuration.getDictionary(), null, Collections.emptyMap()));
            }
        }
    }

    @Override
    public INDimensionalMatrix<Attribute<? extends IValue>, IValue, Double> collapseDataTablesIntoDistribution() throws IllegalControlTotalException, IllegalDistributionCreation {
        return this.collapseDataTablesIntoDistribution(0);
    }

    public INDimensionalMatrix<Attribute<? extends IValue>, IValue, Double> collapseDataTablesIntoDistribution(int n) throws IllegalControlTotalException, IllegalDistributionCreation {
        if (this.dataTables == null || this.dataTables.isEmpty()) {
            throw new IllegalArgumentException("To collapse matrices you must build at least one first: see the buildDataTables method");
        }
        if (this.dataTables.get(n).size() == 1) {
            return GosplInputMultiLayerDataManager.getFrequency(this.dataTables.get(n).iterator().next(), Collections.emptySet());
        }
        Set<AFullNDimensionalMatrix<? extends Number>> set = this.dataTables.get(n);
        HashSet<AFullNDimensionalMatrix<Double>> hashSet = new HashSet<AFullNDimensionalMatrix<Double>>();
        GSPerformanceUtil gSPerformanceUtil = new GSPerformanceUtil("Proceed to distribution collapse");
        gSPerformanceUtil.sysoStempPerformance(0, (Object)this);
        for (AFullNDimensionalMatrix aFullNDimensionalMatrix2 : set.stream().filter(aFullNDimensionalMatrix -> aFullNDimensionalMatrix.getDimensions().stream().anyMatch(attribute -> this.configuration.getDictionary().getRecords().contains(attribute))).collect(Collectors.toSet())) {
            hashSet.add(GosplInputMultiLayerDataManager.getTransposedRecord(this.getConfiguration().getDictionary(), aFullNDimensionalMatrix2));
        }
        gSPerformanceUtil.sysoStempPerformance(1, (Object)this);
        gSPerformanceUtil.sysoStempMessage("Collapse record attribute: done");
        for (AFullNDimensionalMatrix aFullNDimensionalMatrix2 : set.stream().filter(aFullNDimensionalMatrix -> aFullNDimensionalMatrix.getDimensions().stream().allMatch(attribute -> !GosplInputMultiLayerDataManager.isRecordAttribute(this.getConfiguration().getDictionary(), attribute))).collect(Collectors.toSet())) {
            hashSet.add(GosplInputMultiLayerDataManager.getFrequency(aFullNDimensionalMatrix2, set));
        }
        gSPerformanceUtil.sysoStempPerformance(2, (Object)this);
        gSPerformanceUtil.sysoStempMessage("Transpose to frequency: done");
        return new GosplConditionalDistribution((Set<AFullNDimensionalMatrix<Double>>)hashSet);
    }

    @Override
    public Set<INDimensionalMatrix<Attribute<? extends IValue>, IValue, ? extends Number>> getRawDataTables() {
        return this.getRawDataTables(0);
    }

    public Set<INDimensionalMatrix<Attribute<? extends IValue>, IValue, ? extends Number>> getRawDataTables(int n) {
        return Collections.unmodifiableSet(this.dataTables.get(n));
    }

    @Override
    public Set<AFullNDimensionalMatrix<Integer>> getContingencyTables() {
        return this.getContingencyTables(0);
    }

    private Set<AFullNDimensionalMatrix<Integer>> getContingencyTables(int n) {
        return this.dataTables.get(n).stream().filter(aFullNDimensionalMatrix -> GSSurveyType.ContingencyTable.equals((Object)aFullNDimensionalMatrix.getMetaDataType())).map(aFullNDimensionalMatrix -> aFullNDimensionalMatrix).collect(Collectors.toSet());
    }

    @Override
    public Set<IPopulation<ADemoEntity, Attribute<? extends IValue>>> getRawSamples() {
        return new HashSet<IPopulation<ADemoEntity, Attribute<? extends IValue>>>(this.samples.values());
    }

    public IPopulation<ADemoEntity, Attribute<? extends IValue>> getRawSample(int n) {
        return this.samples.get(n);
    }
}

