/*
 * Decompiled with CFR 0.152.
 */
package gospl.generator.util;

import core.configuration.GenstarJsonUtil;
import core.configuration.dictionary.AttributeDictionary;
import core.metamodel.attribute.Attribute;
import core.metamodel.value.IValue;
import core.util.random.GenstarRandom;
import gospl.GosplPopulation;
import gospl.distribution.GosplNDimensionalMatrixFactory;
import gospl.distribution.exception.IllegalDistributionCreation;
import gospl.distribution.matrix.AFullNDimensionalMatrix;
import gospl.distribution.matrix.ASegmentedNDimensionalMatrix;
import gospl.generator.ISyntheticGosplPopGenerator;
import gospl.generator.util.GSUtilGenerator;
import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import ummisco.gama.dev.utils.DEBUG;

public class GSUtilPopulation {
    private static final String NO_POPULATION_HAVE_BEEN_GENERATED_SEE_BUILD_POPULATION = "No population have been generated - see #buildPopulation";
    private ISyntheticGosplPopGenerator generator;
    private GosplPopulation population = null;
    private AFullNDimensionalMatrix<Double> distribution = null;
    private AFullNDimensionalMatrix<Integer> contingency = null;
    private AttributeDictionary dico;
    private final Path pathToDictionary = FileSystems.getDefault().getPath("src", "test", "resources", "attributedictionary");
    public static final String defaultDictionary = "defaultDictionary.gns";

    public GSUtilPopulation() {
        this(defaultDictionary);
    }

    public GSUtilPopulation(AttributeDictionary attributeDictionary, ISyntheticGosplPopGenerator iSyntheticGosplPopGenerator) {
        this.dico = attributeDictionary;
        this.generator = iSyntheticGosplPopGenerator;
    }

    public GSUtilPopulation(AttributeDictionary attributeDictionary) {
        this.dico = attributeDictionary;
        this.generator = new GSUtilGenerator(this.dico);
    }

    public GSUtilPopulation(String string, ISyntheticGosplPopGenerator iSyntheticGosplPopGenerator) {
        try {
            this.dico = new GenstarJsonUtil().unmarshalFromGenstarJson(this.pathToDictionary.resolve(string), AttributeDictionary.class);
        }
        catch (IOException | IllegalArgumentException exception) {
            exception.printStackTrace();
        }
        this.generator = iSyntheticGosplPopGenerator;
    }

    public GSUtilPopulation(Path path) {
        try {
            this.dico = new GenstarJsonUtil().unmarshalFromGenstarJson(path, AttributeDictionary.class);
        }
        catch (IOException | IllegalArgumentException exception) {
            exception.printStackTrace();
        }
        this.generator = new GSUtilGenerator(this.dico);
    }

    public GSUtilPopulation(String string) {
        try {
            this.dico = new GenstarJsonUtil().unmarshalFromGenstarJson(this.pathToDictionary.resolve(string), AttributeDictionary.class);
        }
        catch (IOException | IllegalArgumentException exception) {
            exception.printStackTrace();
        }
        this.generator = new GSUtilGenerator(this.dico);
    }

    public GSUtilPopulation(Collection<Attribute<? extends IValue>> collection) {
        this.dico = new AttributeDictionary();
        collection.stream().forEach(attribute -> {
            AttributeDictionary attributeDictionary = this.dico.addAttributes((Attribute<? extends IValue>)attribute);
        });
        this.generator = new GSUtilGenerator(this.dico);
    }

    public GSUtilPopulation(GosplPopulation gosplPopulation) {
        this.population = gosplPopulation;
    }

    public Path getPathToDictionary() {
        return this.pathToDictionary;
    }

    public AttributeDictionary getDictionary() {
        return this.dico;
    }

    public GosplPopulation buildPopulation(int n) {
        this.population = this.generator.generate(n);
        return this.population;
    }

    public AFullNDimensionalMatrix<Integer> getContingency() {
        if (this.population == null) {
            throw new NullPointerException(NO_POPULATION_HAVE_BEEN_GENERATED_SEE_BUILD_POPULATION);
        }
        if (this.contingency == null) {
            this.contingency = new GosplNDimensionalMatrixFactory().createContingency(this.population);
        }
        return this.contingency;
    }

    public AFullNDimensionalMatrix<Double> getFrequency() {
        if (this.population == null) {
            throw new NullPointerException(NO_POPULATION_HAVE_BEEN_GENERATED_SEE_BUILD_POPULATION);
        }
        if (this.distribution == null) {
            this.distribution = new GosplNDimensionalMatrixFactory().createDistribution(this.population);
        }
        return this.distribution;
    }

    public ASegmentedNDimensionalMatrix<Double> getSegmentedFrequency(int n) throws IllegalDistributionCreation {
        Object object;
        if (this.population == null) {
            throw new NullPointerException(NO_POPULATION_HAVE_BEEN_GENERATED_SEE_BUILD_POPULATION);
        }
        DEBUG.OUT((Object)("Try to build segmented matrix with {} dimensions" + this.dico.getAttributes().size()));
        Map map = this.dico.getAttributes().stream().collect(Collectors.toMap(Function.identity(), attribute -> 0.5));
        HashSet<Object> hashSet = new HashSet<Object>();
        while (!hashSet.stream().flatMap(Collection::stream).collect(Collectors.toSet()).containsAll(this.dico.getAttributes())) {
            object = new HashSet();
            for (Attribute attribute3 : map.keySet()) {
                if (object.stream().anyMatch(attribute2 -> attribute2.getReferentAttribute().equals(attribute3) || attribute2.equals(attribute3.getReferentAttribute()))) continue;
                if (GenstarRandom.getInstance().nextDouble() < map.get(attribute3)) {
                    object.add(attribute3);
                    map.put(attribute3, map.get(attribute3) * 0.5);
                    continue;
                }
                map.put(attribute3, Math.tanh(map.get(attribute3) + 0.5));
            }
            if (object.size() < 2) continue;
            DEBUG.OUT((Object)("Build a new full inner matrix with {} attributes" + object.stream().map(Attribute::getAttributeName).collect(Collectors.joining(", "))));
            hashSet.add(object);
        }
        DEBUG.OUT((Object)("Build the segmented matrix with {} inner full matrix" + hashSet.size()));
        object = new GosplNDimensionalMatrixFactory();
        return ((GosplNDimensionalMatrixFactory)object).createDistributionFromDistributions(hashSet.stream().map(arg_0 -> this.lambda$5((GosplNDimensionalMatrixFactory)object, arg_0)).collect(Collectors.toSet()));
    }

    private /* synthetic */ AFullNDimensionalMatrix lambda$5(GosplNDimensionalMatrixFactory gosplNDimensionalMatrixFactory, Set set) {
        return gosplNDimensionalMatrixFactory.createDistribution((Set<Attribute<? extends IValue>>)set, this.population);
    }
}

