/*
 * Decompiled with CFR 0.152.
 */
package gospl.io;

import au.com.bytecode.opencsv.CSVReader;
import core.metamodel.io.GSSurveyType;
import gospl.io.AbstractInputHandler;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.IntStream;
import org.apache.commons.lang3.StringUtils;
import ummisco.gama.dev.utils.DEBUG;

public class CsvInputHandler
extends AbstractInputHandler {
    private static final char[] CSV_SEPARATORS_FROM_DETECTION = new char[]{',', ';', ':', '|', ' ', '\t'};
    private static final int CHUNK_SIZE = 100000;
    private static final boolean CHUNK = false;
    private Map<Integer, List<String[]>> dataTables;
    private List<String[]> dataTable;
    private final int firstRowDataIndex;
    private final int firstColumnDataIndex;
    private final String charset;
    private final char csvSeparator;
    private final boolean storeInMemory;
    private int lastRowIndex = -1;
    private int lastColumnIndex = -1;

    protected CsvInputHandler(String string, char c, int n, int n2, GSSurveyType gSSurveyType) throws IOException {
        this(string, true, c, n, n2, gSSurveyType);
    }

    protected CsvInputHandler(String string, boolean bl, char c, int n, int n2, GSSurveyType gSSurveyType) throws IOException {
        this(string, bl, Charset.defaultCharset().name(), c, n, n2, gSSurveyType);
    }

    protected CsvInputHandler(String string, boolean bl, String string2, char c, int n, int n2, GSSurveyType gSSurveyType) throws IOException {
        super(gSSurveyType, string);
        this.storeInMemory = bl;
        this.csvSeparator = c;
        this.charset = string2;
        Throwable throwable = null;
        Object var9_10 = null;
        try (CSVReader cSVReader = new CSVReader((Reader)new InputStreamReader((InputStream)new FileInputStream(this.surveyCompleteFile), this.charset), c);){
            if (this.storeInMemory) {
                this.dataTable = cSVReader.readAll();
            } else {
                this.dataTable = new ArrayList<String[]>();
                int n3 = 0;
                int n4 = 0;
                while (n4 < n) {
                    this.dataTable.add(cSVReader.readNext());
                    ++n3;
                    ++n4;
                }
                String[] stringArray = null;
                do {
                    stringArray = cSVReader.readNext();
                    if (this.lastColumnIndex < 0) {
                        this.lastColumnIndex = stringArray.length - 1;
                    }
                    ++n3;
                } while (stringArray != null);
                this.lastRowIndex = n3 - 1;
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        this.firstRowDataIndex = n;
        this.firstColumnDataIndex = n2;
    }

    protected CsvInputHandler(File file, char c, int n, int n2, GSSurveyType gSSurveyType) throws IOException {
        this(file, true, c, n, n2, gSSurveyType);
    }

    protected CsvInputHandler(File file, boolean bl, char c, int n, int n2, GSSurveyType gSSurveyType) throws IOException {
        this(file, bl, Charset.defaultCharset().name(), c, n, n2, gSSurveyType);
    }

    protected CsvInputHandler(File file, boolean bl, String string, char c, int n, int n2, GSSurveyType gSSurveyType) throws IOException {
        super(gSSurveyType, file);
        this.storeInMemory = bl;
        this.charset = string;
        this.csvSeparator = c;
        String[] stringArray3 = null;
        Iterator<String[]> iterator = null;
        try (CSVReader cSVReader = new CSVReader((Reader)new InputStreamReader((InputStream)new FileInputStream(this.surveyCompleteFile), this.charset), c);){
            if (this.storeInMemory) {
                this.dataTable = cSVReader.readAll();
            } else {
                this.dataTable = new ArrayList<String[]>();
                int n3 = 0;
                int n4 = 0;
                while (n4 < n) {
                    this.dataTable.add(cSVReader.readNext());
                    ++n3;
                    ++n4;
                }
                String[] stringArray2 = null;
                do {
                    stringArray2 = cSVReader.readNext();
                    if (this.lastColumnIndex < 0) {
                        this.lastColumnIndex = stringArray2.length - 1;
                    }
                    ++n3;
                } while (stringArray2 != null);
                this.lastRowIndex = n3 - 1;
            }
        }
        catch (Throwable object) {
            if (stringArray3 == null) {
                stringArray3 = object;
            } else if (stringArray3 != object) {
                stringArray3.addSuppressed((Throwable)object);
            }
            throw stringArray3;
        }
        if (this.dataTable != null) {
            for (String[] stringArray3 : this.dataTable) {
                int n5 = 0;
                while (n5 < stringArray3.length) {
                    if (stringArray3[n5].isBlank()) {
                        stringArray3[n5] = "";
                    }
                    ++n5;
                }
            }
        }
        this.firstRowDataIndex = n;
        this.firstColumnDataIndex = n2;
    }

    protected CsvInputHandler(String string, InputStream inputStream, char c, int n, int n2, GSSurveyType gSSurveyType) throws IOException {
        this(string, Charset.defaultCharset().name(), inputStream, true, c, n, n2, gSSurveyType);
    }

    protected CsvInputHandler(String string, String string2, InputStream inputStream, boolean bl, char c, int n, int n2, GSSurveyType gSSurveyType) throws IOException {
        super(gSSurveyType, string);
        this.storeInMemory = bl;
        this.charset = string2;
        this.csvSeparator = c;
        Throwable throwable = null;
        Object var10_11 = null;
        try (CSVReader cSVReader = new CSVReader((Reader)new InputStreamReader(inputStream, this.charset), c);){
            if (this.storeInMemory) {
                this.dataTable = cSVReader.readAll();
            } else {
                this.dataTable = new ArrayList<String[]>();
                int n3 = 0;
                int n4 = 0;
                while (n4 < n) {
                    this.dataTable.add(cSVReader.readNext());
                    ++n3;
                    ++n4;
                }
                String[] stringArray = null;
                do {
                    stringArray = cSVReader.readNext();
                    if (this.lastColumnIndex < 0) {
                        this.lastColumnIndex = stringArray.length - 1;
                    }
                    ++n3;
                } while (stringArray != null);
                this.lastRowIndex = n3 - 1;
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        this.firstRowDataIndex = n;
        this.firstColumnDataIndex = n2;
    }

    @Override
    public String read(int n, int n2) {
        return this.dataTable.get(n)[n2].trim();
    }

    @Override
    public List<String> readLine(int n) {
        if (!this.storeInMemory) {
            throw new NullPointerException("Data have not been stored in memory - use #getBufferReader() to access data");
        }
        return Arrays.asList(this.dataTable.get(n));
    }

    @Override
    public List<List<String>> readLines(int n, int n2) {
        ArrayList<List<String>> arrayList = new ArrayList<List<String>>();
        int n3 = n;
        while (n3 < n2) {
            arrayList.add(this.readLine(n3));
            ++n3;
        }
        return arrayList;
    }

    @Override
    public List<String> readLines(int n, int n2, int n3) {
        ArrayList<String> arrayList = new ArrayList<String>();
        int n4 = n;
        while (n4 < n2) {
            arrayList.add(this.read(n4, n3));
            ++n4;
        }
        return arrayList;
    }

    @Override
    public List<List<String>> readLines(int n, int n2, int n3, int n4) {
        ArrayList<List<String>> arrayList = new ArrayList<List<String>>();
        int n5 = n;
        while (n5 < n2) {
            arrayList.add(new ArrayList<String>(this.readLine(n5).subList(n3, n4)));
            ++n5;
        }
        return arrayList;
    }

    @Override
    public List<String> readColumn(int n) {
        if (!this.storeInMemory) {
            throw new NullPointerException("Data have not been stored in memory - use #getBufferReader() to access data");
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String[] stringArray : this.dataTable) {
            arrayList.add(stringArray[n]);
        }
        return arrayList;
    }

    @Override
    public List<List<String>> readColumns(int n, int n2) {
        ArrayList<List<String>> arrayList = new ArrayList<List<String>>();
        int n3 = n;
        while (n3 < n2) {
            arrayList.add(this.readColumn(n3));
            ++n3;
        }
        return arrayList;
    }

    @Override
    public List<String> readColumns(int n, int n2, int n3) {
        ArrayList<String> arrayList = new ArrayList<String>();
        int n4 = n;
        while (n4 < n2) {
            arrayList.add(this.read(n3, n4));
            ++n4;
        }
        return arrayList;
    }

    @Override
    public List<List<String>> readColumns(int n, int n2, int n3, int n4) {
        ArrayList<List<String>> arrayList = new ArrayList<List<String>>();
        int n5 = n3;
        while (n5 < n4) {
            arrayList.add(new ArrayList<String>(this.readColumn(n5).subList(n, n2)));
            ++n5;
        }
        return arrayList;
    }

    @Override
    public String getName() {
        return this.surveyFileName;
    }

    @Override
    public int getFirstRowIndex() {
        return this.firstRowDataIndex;
    }

    @Override
    public int getFirstColumnIndex() {
        return this.firstColumnDataIndex;
    }

    @Override
    public int getLastRowIndex() {
        if (!this.storeInMemory) {
            return this.lastRowIndex;
        }
        return this.dataTable == null || this.dataTable.isEmpty() ? (this.dataTables.size() - 1) * 100000 + this.dataTables.get(Collections.max(this.dataTables.keySet())).size() : this.dataTable.size() - 1;
    }

    @Override
    public int getLastColumnIndex() {
        if (!this.storeInMemory) {
            return this.lastColumnIndex;
        }
        if (this.dataTable == null || this.dataTable.isEmpty()) {
            return this.dataTables.values().stream().findFirst().get().iterator().next().length;
        }
        String[] stringArray = this.dataTable.get(0);
        return stringArray.length - 1;
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Survey name: ").append(this.getName()).append("\n");
        stringBuilder.append("\tline number: ").append(!this.storeInMemory ? this.lastRowIndex + 1 : this.dataTable.size());
        stringBuilder.append("\tcolumn number: ").append(!this.storeInMemory ? this.lastColumnIndex + 1 : this.dataTable.get(0).length);
        return stringBuilder.toString();
    }

    public static char detectSeparator(File file) throws IOException {
        return CsvInputHandler.detectSeparator(file, Charset.defaultCharset().name(), CSV_SEPARATORS_FROM_DETECTION);
    }

    public static char detectSeparator(File file, String string) throws IOException {
        return CsvInputHandler.detectSeparator(file, string, CSV_SEPARATORS_FROM_DETECTION);
    }

    public static char detectSeparator(File file, String string, char[] cArray) throws IOException {
        int n3;
        int n4 = 20;
        ArrayList<String> arrayList = new ArrayList<String>(n4);
        Object object = null;
        Object var6_7 = null;
        try (BufferedReader bufferedReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), string));){
            while (bufferedReader.ready()) {
                arrayList.add(bufferedReader.readLine());
            }
        }
        catch (Throwable throwable) {
            if (object == null) {
                object = throwable;
            } else if (object != throwable) {
                ((Throwable)object).addSuppressed(throwable);
            }
            throw object;
        }
        n4 = arrayList.size();
        if (n4 < 3) {
            throw new IllegalArgumentException("cannot detect automatically the CSV separators from so few lines, sorry");
        }
        object = new int[n4][cArray.length];
        int n5 = 0;
        while (n5 < n4) {
            int n6 = 0;
            while (n6 < cArray.length) {
                object[n5][n6] = StringUtils.countMatches((CharSequence)((CharSequence)arrayList.get(n5)), (CharSequence)("" + cArray[n6]));
                ++n6;
            }
            ++n5;
        }
        double[] dArray = new double[cArray.length];
        double[] dArray2 = new double[cArray.length];
        int n7 = 0;
        while (n7 < cArray.length) {
            n3 = 0;
            while (n3 < n4) {
                int n8 = n7;
                dArray[n8] = dArray[n8] + (double)object[n3][n7];
                ++n3;
            }
            dArray[n7] = dArray[n7] / (double)n4;
            n3 = 0;
            while (n3 < n4) {
                int n9 = n7;
                dArray2[n9] = dArray2[n9] + Math.pow((double)object[n3][n7] - dArray[n7], 2.0);
                ++n3;
            }
            dArray2[n7] = dArray2[n7] / (double)n4;
            ++n7;
        }
        StringBuilder stringBuilder = new StringBuilder();
        n3 = 0;
        while (n3 < cArray.length) {
            stringBuilder.append(cArray[n3]).append(": ").append(dArray[n3]).append(" ~ ").append(dArray2[n3]).append(" \n");
            ++n3;
        }
        LinkedList<Integer> linkedList = new LinkedList<Integer>();
        int n10 = 0;
        while (n10 < cArray.length) {
            if (dArray[n10] >= 1.0) {
                linkedList.add(n10);
            }
            ++n10;
        }
        Collections.sort(linkedList, (n, n2) -> Double.compare(dArray2[n], dArray2[n2]));
        if (linkedList.isEmpty()) {
            return ';';
        }
        return cArray[(Integer)linkedList.get(0)];
    }

    static Map<Integer, List<String[]>> chunkData(CSVReader cSVReader, int n) throws IOException {
        HashMap<Integer, List<String[]>> hashMap = new HashMap<Integer, List<String[]>>();
        hashMap.put(n, new ArrayList());
        int n2 = n;
        int n3 = 0;
        String[] stringArray;
        while ((stringArray = cSVReader.readNext()) != null) {
            ((List)hashMap.get(n2)).add(stringArray);
            if (++n3 % n != 0) continue;
            hashMap.put(n2 += n, new ArrayList());
            DEBUG.OUT((Object)("[SYSO::" + CsvInputHandler.class.getSimpleName() + "] " + n2 + " record have been done"));
        }
        return hashMap;
    }

    @Override
    public CSVReader getBufferReader(boolean bl) throws UnsupportedEncodingException, FileNotFoundException {
        CSVReader cSVReader = new CSVReader((Reader)new InputStreamReader((InputStream)new FileInputStream(this.surveyCompleteFile), this.charset), this.csvSeparator);
        if (bl) {
            IntStream.range(0, this.firstRowDataIndex).forEach(n -> {
                try {
                    cSVReader.readNext();
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            });
        }
        return cSVReader;
    }
}

