/*
 * Decompiled with CFR 0.152.
 */
package gospl.io;

import core.metamodel.IPopulation;
import core.metamodel.attribute.Attribute;
import core.metamodel.attribute.IAttribute;
import core.metamodel.entity.ADemoEntity;
import core.metamodel.entity.IEntity;
import core.metamodel.io.GSSurveyType;
import core.metamodel.io.GSSurveyWrapper;
import core.metamodel.io.IGSSurvey;
import core.metamodel.value.IValue;
import core.util.GSPerformanceUtil;
import gospl.distribution.GosplNDimensionalMatrixFactory;
import gospl.distribution.matrix.AFullNDimensionalMatrix;
import gospl.distribution.matrix.INDimensionalMatrix;
import gospl.io.CsvInputHandler;
import gospl.io.XlsInputHandler;
import gospl.io.exception.InvalidSurveyFormatException;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.apache.poi.openxml4j.exceptions.InvalidFormatException;

public class GosplSurveyFactory {
    private final double precision = Math.pow(10.0, -2.0);
    private final DecimalFormatSymbols dfs;
    private final DecimalFormat decimalFormat;
    private char separator = (char)59;
    private boolean storedInMemory;
    private int sheetNb;
    private int firstRowDataIdx;
    private int firstColumnDataIdx;
    public static final String UNKNOWN_VARIABLE = "?";
    public static final String CSV_EXT = ".csv";
    public static final String XLS_EXT = ".xls";
    public static final String XLSX_EXT = ".xlsx";
    public static final String DBF_EXT = ".dbf";
    public static final List<String> supportedFileFormat = Collections.unmodifiableList(Arrays.asList(".csv", ".xls", ".xlsx", ".dbf"));

    public GosplSurveyFactory() {
        this.dfs = new DecimalFormatSymbols(Locale.FRANCE);
        this.decimalFormat = new DecimalFormat("#.##", new DecimalFormatSymbols(Locale.FRANCE));
        this.dfs.setDecimalSeparator('.');
    }

    public GosplSurveyFactory(int n, char c, int n2, int n3) {
        this(n, c, false, n2, n3, new DecimalFormatSymbols(Locale.FRANCE), new DecimalFormat("#.##", new DecimalFormatSymbols(Locale.FRANCE)));
    }

    public GosplSurveyFactory(int n, char c, boolean bl, int n2, int n3, Locale locale) {
        this(n, c, bl, n2, n3, new DecimalFormatSymbols(locale), new DecimalFormat("#.##", new DecimalFormatSymbols(locale)));
    }

    public GosplSurveyFactory(int n, char c, boolean bl, int n2, int n3, DecimalFormatSymbols decimalFormatSymbols, DecimalFormat decimalFormat) {
        this.dfs = decimalFormatSymbols;
        this.decimalFormat = decimalFormat;
        this.storedInMemory = bl;
        this.sheetNb = n;
        this.separator = c;
        this.firstRowDataIdx = n2;
        this.firstColumnDataIdx = n3;
    }

    public List<String> getSupportedFileFormat() {
        return supportedFileFormat;
    }

    public IGSSurvey getSurvey(GSSurveyWrapper gSSurveyWrapper, Path path) throws IOException, InvalidSurveyFormatException {
        Path path2 = gSSurveyWrapper.getRelativePath();
        File file = path2.toFile();
        if (!file.exists()) {
            file = (path2 = path.resolve(path2)).toFile();
            if (!file.exists()) {
                throw new IllegalArgumentException("cannot load file " + file + " .");
            }
            if (!file.canRead()) {
                throw new IllegalArgumentException("cannot read file " + file + " .");
            }
        }
        return this.getSurvey(file, gSSurveyWrapper.getStoredInMemory(), gSSurveyWrapper.getSheetNumber(), gSSurveyWrapper.getCsvSeparator(), gSSurveyWrapper.getFirstRowIndex(), gSSurveyWrapper.getFirstColumnIndex(), gSSurveyWrapper.getSurveyType());
    }

    public IGSSurvey getSurvey(String string, int n, char c, int n2, int n3, GSSurveyType gSSurveyType) throws IOException, InvalidSurveyFormatException {
        if (string.endsWith(XLS_EXT)) {
            return new XlsInputHandler(string, n, n2, n3, gSSurveyType);
        }
        if (string.endsWith(CSV_EXT)) {
            return new CsvInputHandler(string, c, n2, n3, gSSurveyType);
        }
        String[] stringArray = string.split(File.separator);
        throw new InvalidSurveyFormatException(stringArray[stringArray.length - 1], supportedFileFormat);
    }

    public IGSSurvey getSurvey(String string, int n, char c, int n2, int n3, GSSurveyType gSSurveyType, String string2) throws IOException, InvalidSurveyFormatException {
        if (XLS_EXT.equals(string2)) {
            return new XlsInputHandler(string, n, n2, n3, gSSurveyType);
        }
        if (CSV_EXT.equals(string2)) {
            return new CsvInputHandler(string, c, n2, n3, gSSurveyType);
        }
        String[] stringArray = string.split(File.separator);
        throw new InvalidSurveyFormatException(stringArray[stringArray.length - 1], supportedFileFormat);
    }

    public IGSSurvey getSurvey(String string, GSSurveyType gSSurveyType) throws IOException, InvalidSurveyFormatException {
        return this.getSurvey(string, this.sheetNb, this.separator, this.firstRowDataIdx, this.firstColumnDataIdx, gSSurveyType);
    }

    public IGSSurvey getSurvey(File file, boolean bl, int n, char c, int n2, int n3, GSSurveyType gSSurveyType) throws IOException, InvalidSurveyFormatException {
        if (file.getName().endsWith(XLS_EXT)) {
            return new XlsInputHandler(file, n, n2, n3, gSSurveyType);
        }
        if (file.getName().endsWith(CSV_EXT)) {
            return new CsvInputHandler(file, bl, c, n2, n3, gSSurveyType);
        }
        String[] stringArray = file.getPath().split(File.separator);
        throw new InvalidSurveyFormatException(stringArray[stringArray.length - 1], supportedFileFormat);
    }

    public IGSSurvey getSurvey(File file, GSSurveyType gSSurveyType) throws IOException, InvalidSurveyFormatException {
        return this.getSurvey(file, this.storedInMemory, this.sheetNb, this.separator, this.firstRowDataIdx, this.firstColumnDataIdx, gSSurveyType);
    }

    public IGSSurvey getSurvey(String string, InputStream inputStream, int n, char c, int n2, int n3, GSSurveyType gSSurveyType) throws IOException, InvalidSurveyFormatException {
        if (string.endsWith(XLS_EXT)) {
            return new XlsInputHandler(inputStream, n, string, n2, n3, gSSurveyType);
        }
        if (string.endsWith(CSV_EXT)) {
            return new CsvInputHandler(string, inputStream, c, n2, n3, gSSurveyType);
        }
        if (string.endsWith(DBF_EXT)) {
            throw new IllegalArgumentException("Cannot read format .dbf from a, input stream, sorry");
        }
        throw new InvalidSurveyFormatException(string, supportedFileFormat);
    }

    public IGSSurvey getSurvey(String string, InputStream inputStream, GSSurveyType gSSurveyType) throws IOException, InvalidSurveyFormatException {
        return this.getSurvey(string, inputStream, this.sheetNb, this.separator, this.firstRowDataIdx, this.firstColumnDataIdx, gSSurveyType);
    }

    public IGSSurvey createSummary(File file, GSSurveyType gSSurveyType, IPopulation<ADemoEntity, Attribute<? extends IValue>> iPopulation) throws InvalidFormatException, IOException, InvalidSurveyFormatException {
        return switch (gSSurveyType) {
            case GSSurveyType.Sample -> this.createSample(file, true, iPopulation);
            case GSSurveyType.ContingencyTable -> this.createTableSummary(file, gSSurveyType, iPopulation);
            case GSSurveyType.GlobalFrequencyTable -> this.createTableSummary(file, gSSurveyType, iPopulation);
            default -> this.createTableSummary(file, GSSurveyType.GlobalFrequencyTable, iPopulation);
        };
    }

    public IGSSurvey createContingencyTable(File file, Set<Attribute<? extends IValue>> set, IPopulation<ADemoEntity, Attribute<? extends IValue>> iPopulation) throws IOException, InvalidSurveyFormatException {
        GSPerformanceUtil gSPerformanceUtil = new GSPerformanceUtil("TEST OUTPUT TABLES", GSPerformanceUtil.Level.TRACE);
        AFullNDimensionalMatrix<Integer> aFullNDimensionalMatrix = GosplNDimensionalMatrixFactory.getFactory().createContingency(iPopulation);
        if (set.stream().anyMatch(attribute -> !aFullNDimensionalMatrix.getDimensions().contains(attribute))) {
            throw new IllegalArgumentException("Format is not entirely aligned with population: \nFormat: " + Arrays.toString(set.toArray()) + "\n" + "Population: " + Arrays.toString(aFullNDimensionalMatrix.getDimensions().toArray()));
        }
        List<Attribute<? extends IValue>> list = set.stream().skip(set.size() / 2).toList();
        List<Attribute<? extends IValue>> list2 = set.stream().filter(attribute -> !list.contains(attribute)).toList();
        gSPerformanceUtil.sysoStempMessage("Columns: " + list.stream().map(Attribute::getAttributeName).collect(Collectors.joining(" + ")));
        gSPerformanceUtil.sysoStempMessage("Rows: " + list2.stream().map(Attribute::getAttributeName).collect(Collectors.joining(" + ")));
        String string = "";
        if (list2.isEmpty()) {
            List list3 = list.stream().flatMap(attribute -> attribute.getValueSpace().getValues().stream()).toList();
            string = String.valueOf(string) + list3.stream().map(IValue::getStringValue).collect(Collectors.joining(String.valueOf(this.separator))) + String.valueOf(this.separator) + "TOTAL\n";
            string = String.valueOf(string) + list3.stream().map(iValue -> ((Integer)aFullNDimensionalMatrix.getVal((IValue)iValue, true).getValue()).toString()).collect(Collectors.joining(String.valueOf(this.separator))) + String.valueOf(this.separator) + list3.stream().mapToInt(iValue -> (Integer)aFullNDimensionalMatrix.getVal((IValue)iValue, true).getValue()).sum();
        } else {
            Map<Integer, List<IValue>> map = this.getTableHeader(list);
            Map<Integer, List<IValue>> map2 = this.getTableHeader(list2);
            String string2 = list2.stream().map(attribute -> " " + this.separator).collect(Collectors.joining());
            string = String.valueOf(string) + IntStream.range(0, list.size()).mapToObj(n -> String.valueOf(string2) + map.values().stream().map(list -> ((IValue)list.get(n)).getStringValue()).collect(Collectors.joining(String.valueOf(this.separator)))).collect(Collectors.joining("\n")) + String.valueOf(this.separator) + "TOTAL";
            gSPerformanceUtil.sysoStempMessage("HEAD: " + string);
            gSPerformanceUtil.sysoStempMessage("ROW VALUE" + map2.keySet().stream().sorted().map(n -> ((List)map2.get(n)).stream().map(IValue::getStringValue).collect(Collectors.joining(" + "))).collect(Collectors.joining(" // ")));
            int n3 = 0;
            while (n3 < map2.size()) {
                ArrayList<Integer> arrayList = new ArrayList<Integer>();
                for (Integer n4 : map.keySet()) {
                    arrayList.add(n4, aFullNDimensionalMatrix.getVal(Stream.concat(map.get(n4).stream(), map2.get(n3).stream()).collect(Collectors.toSet())).getValue());
                }
                string = String.valueOf(string) + "\n" + map2.get(n3).stream().map(IValue::getStringValue).collect(Collectors.joining(String.valueOf(this.separator))) + this.separator + arrayList.stream().map(n -> n.toString()).collect(Collectors.joining(String.valueOf(this.separator)));
                string = String.valueOf(string) + (this.separator + arrayList.stream().reduce(0, (n, n2) -> n + n2));
                gSPerformanceUtil.sysoStempMessage("New line (" + Arrays.toString(map2.get(n3).toArray()) + ") = " + Arrays.toString(arrayList.toArray()));
                ++n3;
            }
            List<Integer> list4 = IntStream.range(0, map.size()).mapToObj(n -> (Integer)aFullNDimensionalMatrix.getVal((Collection)map.get(n)).getValue()).toList();
            string = String.valueOf(string) + "\n" + list4.stream().map(n -> n.toString()).collect(Collectors.joining(String.valueOf(this.separator))) + this.separator + list4.stream().reduce(1, (n, n2) -> n + n2);
        }
        Files.write(file.toPath(), string.getBytes(), new OpenOption[0]);
        return this.getSurvey(file, GSSurveyType.ContingencyTable);
    }

    public <T extends Number> IGSSurvey createSummary(Path path, INDimensionalMatrix<Attribute<? extends IValue>, IValue, T> iNDimensionalMatrix) throws IOException, InvalidFormatException, InvalidSurveyFormatException {
        Set<Attribute<IValue>> set = iNDimensionalMatrix.getDimensions();
        StringBuilder stringBuilder = new StringBuilder().append(set.stream().map(attribute -> String.valueOf(attribute.getAttributeName()) + this.separator + "frequence").collect(Collectors.joining(String.valueOf(this.separator)))).append("\n");
        List<String> list = IntStream.range(0, set.stream().mapToInt(attribute -> attribute.getValueSpace().getValues().size() + 1).max().getAsInt()).mapToObj(n -> "").toList();
        for (Attribute attribute2 : set) {
            int n2 = 0;
            Set set2 = Stream.concat(attribute2.getValueSpace().getValues().stream(), Stream.of(attribute2.getEmptyValue())).collect(Collectors.toSet());
            for (IValue iValue : set2) {
                String string = "";
                if (!iValue.getValueSpace().getEmptyValue().equals(iValue)) {
                    string = iNDimensionalMatrix.getVal(iValue).toString();
                }
                list.set(n2, String.valueOf(list.get(n2).concat(list.get(n2++).isEmpty() ? "" : String.valueOf(this.separator))) + iValue.getStringValue() + this.separator + string);
            }
            int n3 = n2;
            while (n3 < list.size()) {
                list.set(n3, String.valueOf(list.get(n3).concat(list.get(n3).isEmpty() ? "" : String.valueOf(this.separator))) + this.separator);
                ++n3;
            }
        }
        stringBuilder.append(String.join((CharSequence)"\n", list));
        Files.write(path, stringBuilder.toString().getBytes(), new OpenOption[0]);
        return this.getSurvey(path.toFile(), iNDimensionalMatrix.getMetaDataType());
    }

    private IGSSurvey createTableSummary(File file, GSSurveyType gSSurveyType, IPopulation<ADemoEntity, Attribute<? extends IValue>> iPopulation) throws IOException, InvalidFormatException, InvalidSurveyFormatException {
        Set<Attribute<? extends IValue>> set = iPopulation.getPopulationAttributes();
        StringBuilder stringBuilder = new StringBuilder().append(set.stream().map(attribute -> String.valueOf(attribute.getAttributeName()) + this.separator + "frequence").collect(Collectors.joining(String.valueOf(this.separator)))).append("\n");
        List<String> list = IntStream.range(0, set.stream().mapToInt(attribute -> attribute.getValueSpace().getValues().size() + 1).max().getAsInt()).mapToObj(n -> "").toList();
        Map map = set.stream().flatMap(attribute -> Stream.concat(attribute.getValueSpace().getValues().stream(), Stream.of(attribute.getEmptyValue())).collect(Collectors.toSet()).stream()).collect(Collectors.toMap(Function.identity(), iValue -> 0));
        iPopulation.stream().forEach(aDemoEntity -> aDemoEntity.getValues().forEach(iValue -> {
            Integer n = map.put(iValue, (Integer)map.get(iValue) + 1);
        }));
        for (Attribute attribute2 : set) {
            int n2 = 0;
            Set set2 = Stream.concat(attribute2.getValueSpace().getValues().stream(), Stream.of(attribute2.getEmptyValue())).collect(Collectors.toSet());
            for (IValue iValue2 : set2) {
                String string = "";
                string = GSSurveyType.ContingencyTable.equals((Object)gSSurveyType) ? String.valueOf(map.get(iValue2)) : this.decimalFormat.format(map.get(iValue2).doubleValue() / (double)iPopulation.size());
                list.set(n2, String.valueOf(list.get(n2).concat(list.get(n2++).isEmpty() ? "" : String.valueOf(this.separator))) + iValue2.getStringValue() + this.separator + string);
            }
            int n3 = n2;
            while (n3 < list.size()) {
                list.set(n3, String.valueOf(list.get(n3).concat(list.get(n3).isEmpty() ? "" : String.valueOf(this.separator))) + this.separator);
                ++n3;
            }
        }
        stringBuilder.append(String.join((CharSequence)"\n", list));
        Files.write(file.toPath(), stringBuilder.toString().getBytes(), new OpenOption[0]);
        return this.getSurvey(file, GSSurveyType.GlobalFrequencyTable);
    }

    private IGSSurvey createSample(File file, boolean bl, IPopulation<ADemoEntity, Attribute<? extends IValue>> iPopulation) throws IOException, InvalidSurveyFormatException, InvalidFormatException {
        Throwable throwable = null;
        Object var5_6 = null;
        try (BufferedWriter bufferedWriter = Files.newBufferedWriter(file.toPath(), new OpenOption[0]);){
            Set<Attribute<? extends IValue>> set = iPopulation.getPopulationAttributes();
            Collection collection = iPopulation.stream().map(ADemoEntity::getParent).filter(Objects::nonNull).collect(Collectors.toSet());
            Set set2 = null;
            if (collection.isEmpty()) {
                bl = false;
            } else {
                set2 = collection.stream().flatMap(iEntity -> iEntity.getAttributes().stream()).map(iAttribute -> iAttribute).collect(Collectors.toSet());
            }
            bufferedWriter.write("ID");
            bufferedWriter.write(this.separator);
            bufferedWriter.write("__type");
            bufferedWriter.write(this.separator);
            bufferedWriter.write(set.stream().map(Attribute::getAttributeName).collect(Collectors.joining(String.valueOf(this.separator))));
            bufferedWriter.write(this.separator);
            bufferedWriter.write("parentId");
            bufferedWriter.write(this.separator);
            if (bl) {
                bufferedWriter.write("parent__type");
                bufferedWriter.write(this.separator);
                bufferedWriter.write(set2.stream().map(IAttribute::getAttributeName).collect(Collectors.joining(String.valueOf(this.separator))));
                bufferedWriter.write(this.separator);
                bufferedWriter.write("count_parent_children");
                bufferedWriter.write(this.separator);
            }
            bufferedWriter.write("count_children");
            bufferedWriter.write("\n");
            bufferedWriter.write("Individual");
            bufferedWriter.write(this.separator);
            bufferedWriter.write("Type of the entity");
            bufferedWriter.write(this.separator);
            bufferedWriter.write(set.stream().map(Attribute::getDescription).collect(Collectors.joining(String.valueOf(this.separator))));
            bufferedWriter.write(this.separator);
            bufferedWriter.write("ID of the parent entity");
            bufferedWriter.write(this.separator);
            if (bl) {
                bufferedWriter.write("parent__type");
                bufferedWriter.write(this.separator);
                bufferedWriter.write(set2.stream().map(IAttribute::getDescription).collect(Collectors.joining(String.valueOf(this.separator))));
                bufferedWriter.write(this.separator);
            }
            bufferedWriter.write("count of children of this entity");
            bufferedWriter.write("\n");
            for (ADemoEntity aDemoEntity : iPopulation) {
                if (aDemoEntity._hasEntityId()) {
                    bufferedWriter.write(aDemoEntity.getEntityId());
                } else {
                    bufferedWriter.write(" ");
                }
                bufferedWriter.write(this.separator);
                if (aDemoEntity.getEntityType() != null) {
                    bufferedWriter.write(aDemoEntity.getEntityType());
                } else {
                    bufferedWriter.write(" ");
                }
                for (Attribute attribute : set) {
                    bufferedWriter.write(this.separator);
                    try {
                        Object object = aDemoEntity.getValueForAttribute(attribute);
                        String string = object.getStringValue();
                        if (!attribute.getValueSpace().getType().isNumericValue()) {
                            bufferedWriter.write("\"");
                            bufferedWriter.write(string);
                            bufferedWriter.write("\"");
                            continue;
                        }
                        bufferedWriter.write(string);
                    }
                    catch (NullPointerException nullPointerException) {
                        bufferedWriter.write("?\"");
                    }
                }
                bufferedWriter.write(this.separator);
                IEntity<? extends IAttribute<? extends IValue>> object2 = aDemoEntity.getParent();
                if (object2 != null) {
                    bufferedWriter.write(aDemoEntity.getParent().getEntityId());
                } else {
                    bufferedWriter.write(" ");
                }
                if (bl) {
                    ADemoEntity aDemoEntity2 = (ADemoEntity)object2;
                    bufferedWriter.write(this.separator);
                    if (aDemoEntity2.getEntityType() != null) {
                        bufferedWriter.write(aDemoEntity2.getEntityType());
                    } else {
                        bufferedWriter.write(" ");
                    }
                    for (Object object : set2) {
                        bufferedWriter.write(this.separator);
                        try {
                            IValue iValue = aDemoEntity2.getValueForAttribute((Attribute)object);
                            String string = iValue.getStringValue();
                            if (!object.getValueSpace().getType().isNumericValue()) {
                                bufferedWriter.write("\"");
                                bufferedWriter.write(string);
                                bufferedWriter.write("\"");
                                continue;
                            }
                            bufferedWriter.write(string);
                        }
                        catch (NullPointerException nullPointerException) {
                            bufferedWriter.write("?\"");
                        }
                    }
                    bufferedWriter.write(this.separator);
                    bufferedWriter.write(Integer.toString((Integer)aDemoEntity2.getCountChildren().getActualValue()));
                }
                bufferedWriter.write(this.separator);
                bufferedWriter.write(Integer.toString((Integer)aDemoEntity.getCountChildren().getActualValue()));
                bufferedWriter.write("\n");
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        return this.getSurvey(file, GSSurveyType.Sample);
    }

    private Map<Integer, List<IValue>> getTableHeader(Collection<Attribute<? extends IValue>> collection) {
        Attribute<? extends IValue> attribute = collection.iterator().next();
        ArrayList<ArrayList<IValue>> arrayList = new ArrayList<ArrayList<IValue>>();
        for (IValue object2 : attribute.getValueSpace().getValues()) {
            arrayList.add(new ArrayList<IValue>(Arrays.asList(object2)));
        }
        collection.remove(attribute);
        for (Attribute attribute2 : collection) {
            ArrayList<List> arrayList2 = new ArrayList<List>();
            for (List list : arrayList) {
                arrayList2.addAll(attribute2.getValueSpace().getValues().stream().map(iValue -> Stream.concat(list.stream(), Stream.of(iValue)).toList()).toList());
            }
            arrayList = arrayList2;
        }
        ArrayList<ArrayList<IValue>> arrayList3 = arrayList;
        return arrayList.stream().collect(Collectors.toMap(arrayList3::indexOf, Function.identity()));
    }
}

