/*
 * Decompiled with CFR 0.152.
 */
package gospl.io;

import core.metamodel.IMultitypePopulation;
import core.metamodel.IPopulation;
import core.metamodel.attribute.Attribute;
import core.metamodel.entity.ADemoEntity;
import core.metamodel.value.IValue;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.PrintStream;

public class GraphMLWriter {
    public static void writePopulationAsGraphML(File file, IPopulation<ADemoEntity, Attribute<? extends IValue>> iPopulation) throws FileNotFoundException {
        Throwable throwable = null;
        Object var3_4 = null;
        try (PrintStream printStream = new PrintStream(file);){
            GraphMLWriter.writeHeader(printStream);
            GraphMLWriter.writeDeclarationNodeAttributes(printStream, iPopulation);
            printStream.println("  <graph id=\"G\" edgedefault=\"directed\">");
            for (ADemoEntity aDemoEntity : iPopulation) {
                GraphMLWriter.writeNodeAndAttributes(printStream, aDemoEntity);
            }
            for (ADemoEntity aDemoEntity : iPopulation) {
                if (!aDemoEntity.hasParent()) continue;
                GraphMLWriter.writeEdgeToParent(printStream, aDemoEntity);
            }
            GraphMLWriter.writeFooter(printStream);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public static void writePopulationAsGraphML(File file, IMultitypePopulation<ADemoEntity, Attribute<? extends IValue>> iMultitypePopulation) throws FileNotFoundException {
        Throwable throwable = null;
        Object var3_4 = null;
        try (PrintStream printStream = new PrintStream(file);){
            GraphMLWriter.writeHeader(printStream);
            GraphMLWriter.writeDeclarationNodeAttributes(printStream, iMultitypePopulation);
            printStream.println("  <graph id=\"G\" edgedefault=\"directed\">");
            for (ADemoEntity aDemoEntity : iMultitypePopulation) {
                GraphMLWriter.writeNodeAndAttributes(printStream, aDemoEntity);
            }
            for (ADemoEntity aDemoEntity : iMultitypePopulation) {
                if (!aDemoEntity.hasParent()) continue;
                GraphMLWriter.writeEdgeToParent(printStream, aDemoEntity);
            }
            GraphMLWriter.writeFooter(printStream);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    protected static void writeHeader(PrintStream printStream) {
        printStream.println("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        printStream.println("<graphml xmlns=\"http://graphml.graphdrawing.org/xmlns\"\n  xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\n  xsi:schemaLocation=\"http://graphml.graphdrawing.org/xmlns\"\n  http://graphml.graphdrawing.org/xmlns/1.0/graphml.xsd\">");
    }

    protected static void writeDeclarationNodeAttributes(PrintStream printStream, IPopulation<ADemoEntity, Attribute<? extends IValue>> iPopulation) {
        printStream.println("<key id=\"__type\" attr.name=\"Type of entity\" attr.type=\"String\">");
        printStream.println("  <default>untyped</default>");
        printStream.println("</key>");
        for (Attribute<? extends IValue> attribute : iPopulation.getPopulationAttributes()) {
            printStream.print("<key id=\"");
            printStream.print(attribute.getAttributeName());
            printStream.print("\" for=\"node\" attr.name=\"");
            printStream.print(attribute.getDescription());
            printStream.print("\" attr.type=\"");
            switch (attribute.getValueSpace().getType()) {
                case Boolean: {
                    printStream.print("boolean");
                    break;
                }
                case Continue: {
                    printStream.print("double");
                    break;
                }
                case Integer: {
                    printStream.print("integer");
                    break;
                }
                case Range: 
                case Order: 
                case Nominal: {
                    printStream.print("string");
                }
            }
            printStream.println("\">");
            printStream.print("  <default>");
            try {
                printStream.print(attribute.getEmptyValue().toString());
            }
            catch (NullPointerException nullPointerException) {
                printStream.print("?");
            }
            printStream.println("  </default>");
            printStream.println("</key>");
        }
    }

    protected static void writeFooter(PrintStream printStream) {
        printStream.println("  </graph>");
        printStream.println("</graphml>");
    }

    protected static void writeNodeAndAttributes(PrintStream printStream, ADemoEntity aDemoEntity) {
        printStream.print("    <node id=\"");
        printStream.print(aDemoEntity.getEntityId());
        printStream.println("\">");
        printStream.print("        <data key=\"__type\">");
        printStream.print(aDemoEntity.getEntityType());
        printStream.println("</data>");
        for (Attribute<? extends IValue> attribute : aDemoEntity.getAttributes()) {
            printStream.print("        <data key=\"");
            printStream.print(attribute.getAttributeName());
            printStream.print("\">");
            printStream.print(aDemoEntity.getValueForAttribute(attribute).getStringValue());
            printStream.println("</data>");
        }
        printStream.println("    </node>");
    }

    protected static void writeEdgeToParent(PrintStream printStream, ADemoEntity aDemoEntity) {
        printStream.print("    <edge source=\"");
        printStream.print(aDemoEntity.getEntityId());
        printStream.print("\" target=\"");
        printStream.print(aDemoEntity.getParent().getEntityId());
        printStream.println("\"/>");
    }
}

