/*
 * Decompiled with CFR 0.152.
 */
package gospl.sampler.multilayer.co;

import core.metamodel.IPopulation;
import core.metamodel.attribute.Attribute;
import core.metamodel.entity.ADemoEntity;
import core.metamodel.value.IValue;
import core.util.GSPerformanceUtil;
import gospl.GosplMultitypePopulation;
import gospl.algo.co.metamodel.AMultiLayerOptimizationAlgorithm;
import gospl.algo.co.metamodel.solution.MultiLayerSPSolution;
import gospl.distribution.matrix.INDimensionalMatrix;
import gospl.sampler.co.MicroDataSampler;
import gospl.sampler.multilayer.co.ICOMultiLayerSampler;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;

public class GosplBiLayerOptimizationSampler<A extends AMultiLayerOptimizationAlgorithm>
implements ICOMultiLayerSampler {
    private Set<INDimensionalMatrix<Attribute<? extends IValue>, IValue, Integer>> parentObjectives;
    private Set<INDimensionalMatrix<Attribute<? extends IValue>, IValue, Integer>> childObjectives;
    private int parentSizeConstraint;
    private int childSizeConstraint;
    private final A algorithm;
    private final MicroDataSampler childSampler;
    private final MicroDataSampler parentSampler;

    public GosplBiLayerOptimizationSampler(A a) {
        this.algorithm = a;
        this.childSampler = new MicroDataSampler(true);
        this.parentSampler = new MicroDataSampler(true);
    }

    @Override
    public void setSample(GosplMultitypePopulation<ADemoEntity> gosplMultitypePopulation, boolean bl) {
        this.childSampler.setSample(gosplMultitypePopulation.getSubPopulation(0), bl);
        ((AMultiLayerOptimizationAlgorithm)this.algorithm).setSample(gosplMultitypePopulation);
    }

    @Override
    public void setSample(GosplMultitypePopulation<ADemoEntity> gosplMultitypePopulation, boolean bl, int n) {
        this.checkLayer(n);
        if (!gosplMultitypePopulation.getEntityLevel().contains(0) || !gosplMultitypePopulation.getEntityLevel().contains(1)) {
            throw new IllegalArgumentException("Cannot setup a by-layered optimization process without two layered sample");
        }
        IPopulation<ADemoEntity, Attribute<? extends IValue>> iPopulation = gosplMultitypePopulation.getSubPopulation(0);
        IPopulation<ADemoEntity, Attribute<? extends IValue>> iPopulation2 = gosplMultitypePopulation.getSubPopulation(1);
        this.childSampler.setSample(iPopulation, bl);
        this.parentSampler.setSample(iPopulation2, bl);
        ((AMultiLayerOptimizationAlgorithm)this.algorithm).setSample(gosplMultitypePopulation);
        ((AMultiLayerOptimizationAlgorithm)this.algorithm).setSampledLayer(n == 1 ? n : 0);
    }

    @Override
    public void addObjectives(INDimensionalMatrix<Attribute<? extends IValue>, IValue, Integer> iNDimensionalMatrix2) {
        if (this.childObjectives == null && this.parentObjectives == null || this.childObjectives != null && this.childObjectives.stream().flatMap(iNDimensionalMatrix -> iNDimensionalMatrix.getDimensions().stream()).anyMatch(attribute -> iNDimensionalMatrix2.getDimensions().contains(attribute))) {
            this.addObjectives(iNDimensionalMatrix2, 0);
        } else if (this.parentObjectives != null && this.parentObjectives.stream().flatMap(iNDimensionalMatrix -> iNDimensionalMatrix.getDimensions().stream()).anyMatch(attribute -> iNDimensionalMatrix2.getDimensions().contains(attribute))) {
            this.addObjectives(iNDimensionalMatrix2, 1);
        }
        throw new IllegalArgumentException("Try to setup an objectif for " + GosplBiLayerOptimizationSampler.class.getCanonicalName() + " sampler but cannot fit it to child or parent layer");
    }

    @Override
    public void addObjectives(INDimensionalMatrix<Attribute<? extends IValue>, IValue, Integer> iNDimensionalMatrix, int n) {
        this.checkLayer(n);
        ((AMultiLayerOptimizationAlgorithm)this.algorithm).addObjectives(n, iNDimensionalMatrix);
        if (n == 0) {
            if (this.childObjectives == null) {
                this.childObjectives = new HashSet<INDimensionalMatrix<Attribute<? extends IValue>, IValue, Integer>>();
            }
            this.childObjectives.add(iNDimensionalMatrix);
            this.childSizeConstraint = iNDimensionalMatrix.getVal().getValue();
        }
        if (n == 1) {
            if (this.parentObjectives == null) {
                this.parentObjectives = new HashSet<INDimensionalMatrix<Attribute<? extends IValue>, IValue, Integer>>();
            }
            this.parentObjectives.add(iNDimensionalMatrix);
            this.parentSizeConstraint = iNDimensionalMatrix.getVal().getValue();
        }
    }

    @Override
    public ADemoEntity draw() {
        return ((AMultiLayerOptimizationAlgorithm)this.algorithm).getSampledLayer() == 0 ? this.childSampler.draw() : this.parentSampler.draw();
    }

    @Override
    public ADemoEntity drawFromLayer(int n) {
        this.checkLayer(n);
        return n == 0 ? this.childSampler.draw() : this.parentSampler.draw();
    }

    @Override
    public Collection<ADemoEntity> draw(int n) {
        Collection<ADemoEntity> collection;
        GSPerformanceUtil gSPerformanceUtil = new GSPerformanceUtil("Generating initial random solution from sample", GSPerformanceUtil.Level.DEBUG);
        if (((AMultiLayerOptimizationAlgorithm)this.algorithm).getSampledLayer() == 0) {
            n = this.childSizeConstraint == 0 ? n : (n < this.childSizeConstraint ? n : this.childSizeConstraint);
            collection = this.childSampler.draw(n);
        } else {
            collection = this.parentSizeConstraint == 0 && this.childSizeConstraint > 0 ? this.parentSampler.drawWithChildrenNumber(n) : (this.parentSizeConstraint > 0 ? this.parentSampler.draw(n > this.parentSizeConstraint ? this.parentSizeConstraint : n) : this.parentSampler.draw(n));
        }
        gSPerformanceUtil.sysoStempMessage("Init solution ok !");
        MultiLayerSPSolution multiLayerSPSolution = new MultiLayerSPSolution(collection, ((AMultiLayerOptimizationAlgorithm)this.algorithm).getSampledLayer(), true);
        if (this.childObjectives != null) {
            this.childObjectives.stream().forEach(iNDimensionalMatrix -> ((AMultiLayerOptimizationAlgorithm)this.algorithm).addObjectives(0, (INDimensionalMatrix<Attribute<? extends IValue>, IValue, Integer>)iNDimensionalMatrix));
        }
        if (this.parentObjectives != null) {
            this.parentObjectives.stream().forEach(iNDimensionalMatrix -> ((AMultiLayerOptimizationAlgorithm)this.algorithm).addObjectives(1, (INDimensionalMatrix<Attribute<? extends IValue>, IValue, Integer>)iNDimensionalMatrix));
        }
        gSPerformanceUtil.sysoStempMessage("Start running the algorithm");
        return this.algorithm.run((MultiLayerSPSolution)multiLayerSPSolution).getSolution();
    }

    @Override
    public Collection<ADemoEntity> drawFromLayer(int n, int n2) {
        this.checkLayer(n);
        Collection<ADemoEntity> collection = n == 0 ? this.childSampler.draw(n2) : this.parentSampler.draw(n2);
        return this.algorithm.run((MultiLayerSPSolution)new MultiLayerSPSolution(collection, ((AMultiLayerOptimizationAlgorithm)this.algorithm).getSampledLayer(), true)).getSolution();
    }

    @Override
    public String toCsv(String string) {
        return null;
    }

    @Override
    public boolean checkLayer(int n) {
        if (n == 0 || n == 1) {
            return true;
        }
        throw new IllegalArgumentException("GosplBiLayerSampler accepts 0 (child) or 1 (parent) layer but not " + n);
    }
}

