/*
 * Decompiled with CFR 0.152.
 */
package gospl.sampler.rejection;

import core.metamodel.IPopulation;
import core.metamodel.attribute.Attribute;
import core.metamodel.entity.ADemoEntity;
import core.metamodel.value.IValue;
import core.util.GSPerformanceUtil;
import core.util.random.GenstarRandomUtils;
import gospl.algo.IGosplConcept;
import gospl.distribution.GosplNDimensionalMatrixFactory;
import gospl.distribution.exception.IllegalDistributionCreation;
import gospl.distribution.matrix.AFullNDimensionalMatrix;
import gospl.distribution.matrix.INDimensionalMatrix;
import gospl.sampler.IEntitySampler;
import java.util.Collection;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;

public class IRejectionSampler
implements IEntitySampler<IPopulation<ADemoEntity, Attribute<? extends IValue>>> {
    INDimensionalMatrix<Attribute<? extends IValue>, IValue, Double> rejectionDistribution;
    IPopulation<ADemoEntity, Attribute<? extends IValue>> basePopulation;

    @Override
    public ADemoEntity draw() {
        ADemoEntity aDemoEntity = null;
        while (aDemoEntity == null) {
            ADemoEntity aDemoEntity2 = (ADemoEntity)GenstarRandomUtils.oneOf(this.basePopulation);
            if (!GenstarRandomUtils.flip(this.rejectionDistribution.getVal(aDemoEntity2.getValues()).getValue())) continue;
            aDemoEntity = aDemoEntity2;
        }
        return aDemoEntity;
    }

    @Override
    public Collection<ADemoEntity> draw(int n2) {
        return IntStream.range(0, n2).parallel().mapToObj(n -> this.draw()).toList();
    }

    @Override
    public String toCsv(String string) {
        return null;
    }

    @Override
    public void setSample(IPopulation<ADemoEntity, Attribute<? extends IValue>> iPopulation, boolean bl) {
        this.basePopulation = iPopulation;
    }

    @Override
    public void addObjectives(INDimensionalMatrix<Attribute<? extends IValue>, IValue, Integer> iNDimensionalMatrix) {
        GosplNDimensionalMatrixFactory gosplNDimensionalMatrixFactory = GosplNDimensionalMatrixFactory.getFactory();
        if (this.rejectionDistribution == null) {
            this.rejectionDistribution = gosplNDimensionalMatrixFactory.createDistribution(iNDimensionalMatrix);
        } else {
            AFullNDimensionalMatrix<Double> aFullNDimensionalMatrix = gosplNDimensionalMatrixFactory.createDistribution((AFullNDimensionalMatrix)iNDimensionalMatrix);
            AFullNDimensionalMatrix<Double> aFullNDimensionalMatrix2 = gosplNDimensionalMatrixFactory.createDistribution(this.rejectionDistribution, new GSPerformanceUtil(""));
            try {
                this.rejectionDistribution = gosplNDimensionalMatrixFactory.createDistributionFromDistributions(Stream.of(aFullNDimensionalMatrix, aFullNDimensionalMatrix2).collect(Collectors.toSet()));
            }
            catch (IllegalDistributionCreation illegalDistributionCreation) {
                illegalDistributionCreation.printStackTrace();
            }
        }
    }

    @Override
    public IGosplConcept.EGosplGenerationConcept getConcept() {
        return IGosplConcept.EGosplGenerationConcept.MIXTURE;
    }
}

