/*
 * Decompiled with CFR 0.152.
 */
package gospl.sampler.sr;

import core.metamodel.attribute.Attribute;
import core.metamodel.value.IValue;
import core.util.GSPerformanceUtil;
import core.util.exception.GenstarException;
import core.util.random.GenstarRandom;
import gospl.distribution.matrix.AFullNDimensionalMatrix;
import gospl.distribution.matrix.coordinate.ACoordinate;
import gospl.sampler.IDistributionSampler;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

public class GosplBinarySampler
implements IDistributionSampler {
    private List<ACoordinate<Attribute<? extends IValue>, IValue>> keys;
    private List<Double> sop;
    private final double EPSILON = Math.pow(10.0, -6.0);
    private static final GSPerformanceUtil.Level LEVEL = GSPerformanceUtil.Level.INFO;

    @Override
    public void setDistribution(AFullNDimensionalMatrix<Double> aFullNDimensionalMatrix) {
        if (aFullNDimensionalMatrix == null) {
            throw new NullPointerException();
        }
        if (aFullNDimensionalMatrix.getMatrix().isEmpty()) {
            throw new IllegalArgumentException("Cannot setup a sampler with an empty distribution matrix " + aFullNDimensionalMatrix);
        }
        int n = aFullNDimensionalMatrix.size();
        GSPerformanceUtil gSPerformanceUtil = new GSPerformanceUtil("Setup binary sample of size: " + n, LEVEL);
        gSPerformanceUtil.sysoStempPerformance(0, (Object)this);
        this.keys = new ArrayList<ACoordinate<Attribute<IValue>, IValue>>(aFullNDimensionalMatrix.getMatrix().keySet());
        this.sop = new ArrayList<Double>(n);
        double d = 0.0;
        int n2 = 1;
        for (ACoordinate<Attribute<? extends IValue>, IValue> aCoordinate : this.keys) {
            this.sop.add(d += aFullNDimensionalMatrix.getVal((ACoordinate<Attribute<IValue>, IValue>)aCoordinate).getValue().doubleValue());
            if (n <= 10 || n2++ % (n / 10) != 0) continue;
            gSPerformanceUtil.sysoStempPerformance((double)n2 * 1.0 / (double)n, (Object)this);
        }
        if (Math.abs(d - 1.0) > this.EPSILON) {
            throw new IllegalArgumentException("Sum of probabilities for this sampler exceed 1 (SOP = " + d + ")");
        }
    }

    @Override
    public ACoordinate<Attribute<? extends IValue>, IValue> draw() {
        int n = 0;
        double d = GenstarRandom.getInstance().nextDouble();
        int n2 = 0;
        int n3 = this.keys.size() - 1;
        while (n2 <= n3) {
            int n4 = (n2 + n3) / 2;
            double d2 = n4 == 0 ? 0.0 : this.sop.get(n4 - 1);
            double d3 = this.sop.get(n4);
            if (d >= d2 && d < d3) {
                return this.keys.get(n4);
            }
            if (d < d3) {
                n3 = n4 - 1;
            }
            if (d >= d3) {
                n2 = n4 + 1;
            }
            if (n++ <= this.keys.size()) continue;
            throw new GenstarException("Infinity loop: floor = " + n2 + " | top = " + n3 + " | mid = " + n4 + "\nRand = " + d + " | mid range = [" + d2 + ";" + d3 + "] " + "\n next key = " + this.sop.get(n4 + 1) + " | previous key = " + this.sop.get(n4 - 2 < 0 ? 0 : n4 - 2));
        }
        throw new GenstarException("Sample engine has not been able to draw one coordinate !!!\nrandom (" + d + "), floor (" + n2 + " = " + this.sop.get(n2) + ") and top (" + n3 + " = " + this.sop.get(n3) + ") could not draw index\n" + "befor floor is: " + this.sop.get(n2 - 1));
    }

    @Override
    public final Collection<ACoordinate<Attribute<? extends IValue>, IValue>> draw(int n2) {
        return IntStream.range(0, n2).mapToObj(n -> this.draw()).toList();
    }

    @Override
    public String toCsv(String string) {
        ArrayList arrayList = new ArrayList(this.keys.parallelStream().flatMap(aCoordinate -> aCoordinate.getDimensions().stream()).collect(Collectors.toSet()));
        StringBuilder stringBuilder = new StringBuilder().append(String.join((CharSequence)string, arrayList.stream().map(Attribute::getAttributeName).toList()));
        stringBuilder.append("; Probability\n");
        double d = 0.0;
        for (ACoordinate<Attribute<? extends IValue>, IValue> aCoordinate2 : this.keys) {
            StringBuilder stringBuilder2 = new StringBuilder();
            for (Attribute attribute : arrayList) {
                if (aCoordinate2.getDimensions().contains(attribute)) {
                    if (stringBuilder2.isEmpty()) {
                        stringBuilder2.append(aCoordinate2.getMap().get(attribute).getStringValue());
                        continue;
                    }
                    stringBuilder2.append(string).append(aCoordinate2.getMap().get(attribute).getStringValue());
                    continue;
                }
                if (stringBuilder2.isEmpty()) {
                    stringBuilder2.append(" ");
                    continue;
                }
                stringBuilder2.append(string).append(" ");
            }
            double d2 = this.sop.get(this.keys.indexOf(aCoordinate2)) - d;
            d = this.sop.get(this.keys.indexOf(aCoordinate2));
            stringBuilder.append((CharSequence)stringBuilder2).append(string).append(d2).append("\n");
        }
        return stringBuilder.toString();
    }
}

