/*
 * Decompiled with CFR 0.152.
 */
package gospl.sampler.sr;

import core.metamodel.attribute.Attribute;
import core.metamodel.value.IValue;
import core.util.random.GenstarRandomUtils;
import core.util.random.roulette.RouletteWheelSelectionFactory;
import gospl.distribution.matrix.ASegmentedNDimensionalMatrix;
import gospl.distribution.matrix.CachedSegmentedNDimensionalMatrix;
import gospl.distribution.matrix.INDimensionalMatrix;
import gospl.distribution.matrix.ISegmentedNDimensionalMatrix;
import gospl.distribution.matrix.coordinate.ACoordinate;
import gospl.distribution.matrix.coordinate.GosplCoordinate;
import gospl.sampler.IHierarchicalSampler;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import ummisco.gama.dev.utils.DEBUG;

public class GosplHierarchicalSampler
implements IHierarchicalSampler {
    private Collection<List<Attribute<? extends IValue>>> explorationOrder = null;
    private ISegmentedNDimensionalMatrix<Double> segmentedMatrix;

    @Override
    public void setDistribution(Collection<List<Attribute<? extends IValue>>> collection, ASegmentedNDimensionalMatrix<Double> aSegmentedNDimensionalMatrix) {
        this.explorationOrder = collection;
        this.segmentedMatrix = new CachedSegmentedNDimensionalMatrix<Double>((ISegmentedNDimensionalMatrix<Double>)aSegmentedNDimensionalMatrix);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ACoordinate<Attribute<? extends IValue>, IValue> draw() {
        HashMap<Attribute<? extends IValue>, IValue> hashMap = new HashMap<Attribute<? extends IValue>, IValue>();
        DEBUG.OUT((Object)"starting hierarchical sampling...");
        for (List<Attribute<? extends IValue>> list : this.explorationOrder) {
            DEBUG.OUT((Object)("starting hierarchical sampling for the first subgraph :" + list));
            for (Attribute<? extends IValue> attribute3 : list) {
                void iValue2;
                Object object;
                Object object2;
                Collection<IValue> collection;
                Object object3;
                if (hashMap.containsKey(attribute3)) continue;
                DEBUG.OUT((Object)("\tsampling att {}" + attribute3));
                if (hashMap.containsKey(attribute3.getReferentAttribute())) {
                    DEBUG.OUT((Object)("\t\t{} was already defined to {}; let's reuse the mapping..." + attribute3.getReferentAttribute().getAttributeName() + "," + hashMap.get(attribute3.getReferentAttribute())));
                    object3 = (IValue)hashMap.get(attribute3.getReferentAttribute());
                    collection = attribute3.findMappedAttributeValues((IValue)object3);
                    DEBUG.LOG((Object)("\t\t{} maps to {}" + object3 + "," + collection));
                    if (collection.size() > 1) {
                        DEBUG.OUT((Object)("\t\thypothesis of uniformity for {} => {}" + object3 + "," + collection));
                    }
                    object2 = GenstarRandomUtils.oneOf(collection);
                    hashMap.put(attribute3, (IValue)object2);
                    DEBUG.OUT((Object)("\t\tpicked {} = {} (through referent attribute)" + attribute3 + "," + object2));
                    continue;
                }
                DEBUG.OUT((Object)("\tshould pick one of the values {}" + attribute3.getValueSpace()));
                object3 = new ArrayList<IValue>(attribute3.getValueSpace().getValues());
                object3.addAll(hashMap.values());
                collection = new ArrayList<IValue>(attribute3.getValueSpace().getValues().size() + 1);
                object2 = new ArrayList();
                for (INDimensionalMatrix<Attribute<IValue>, IValue, Double> iNDimensionalMatrix : this.segmentedMatrix.getMatricesInvolving(this.segmentedMatrix.getDimensions().stream().filter(attribute2 -> attribute2.equals(attribute3.getReferentAttribute())).findAny().orElse(null))) {
                    object2.addAll(iNDimensionalMatrix.getDimensions().stream().filter(attribute -> hashMap.containsKey(attribute)).map(attribute -> (IValue)hashMap.get(attribute)).collect(Collectors.toSet()));
                }
                double d = 0.0;
                for (IValue iValue : attribute3.getValueSpace().getValues()) {
                    object = new HashSet<IValue>((Collection<IValue>)object2);
                    object.add(iValue);
                    try {
                        DEBUG.LOG((Object)("\t\tfor aspects: {}, getVal returns {}" + object + "," + this.segmentedMatrix.getVal(object)));
                        Double d2 = (Double)this.segmentedMatrix.getVal(object).getValue();
                        d += d2.doubleValue();
                        collection.add((IValue)((Object)d2));
                    }
                    catch (NullPointerException nullPointerException) {
                        DEBUG.OUT((Object)("\t\tpotential value {} will be excluded from the distribution as it has no probability" + iValue));
                    }
                }
                Object var11_15 = null;
                if (collection.isEmpty() || d == 0.0) {
                    IValue iValue = attribute3.getEmptyValue();
                    DEBUG.OUT((Object)"\t\tempty distribution; let's assume default value");
                } else {
                    IValue iValue = (IValue)RouletteWheelSelectionFactory.getRouletteWheel(collection, object3).drawObject();
                }
                DEBUG.OUT((Object)("\t\tpicked {} = {}" + attribute3 + "," + iValue2));
                hashMap.put(attribute3, (IValue)iValue2);
                if (attribute3.getReferentAttribute() == attribute3) continue;
                Collection<IValue> collection2 = attribute3.findMappedAttributeValues((IValue)iValue2);
                DEBUG.OUT((Object)("\twe have a reference attribute {}, which maps to {}" + attribute3.getReferentAttribute() + "," + collection2));
                if (collection2.size() > 1) {
                    DEBUG.OUT((Object)("\t\thypothesis of uniformity for {} => {}" + iValue2 + "," + collection2));
                }
                object = (IValue)GenstarRandomUtils.oneOf(collection2);
                hashMap.put(this.segmentedMatrix.getDimensions().stream().filter(attribute2 -> attribute2.equals(attribute3.getReferentAttribute())).findAny().get(), (IValue)object);
                DEBUG.OUT((Object)("\t\tpicked {} = {} (through referent attribute)" + attribute3.getReferentAttribute() + "," + object));
            }
        }
        return new GosplCoordinate((Map<Attribute<? extends IValue>, IValue>)hashMap);
    }

    @Override
    public final Collection<ACoordinate<Attribute<? extends IValue>, IValue>> draw(int n2) {
        return IntStream.range(0, n2).parallel().mapToObj(n -> this.draw()).toList();
    }

    @Override
    public String toCsv(String string) {
        return null;
    }
}

