/*
 * Decompiled with CFR 0.152.
 */
package spll.localizer;

import core.util.GSPerformanceUtil;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import msi.gama.metamodel.agent.IAgent;
import msi.gama.metamodel.shape.GamaPoint;
import msi.gama.metamodel.shape.IShape;
import msi.gama.runtime.IScope;
import msi.gama.util.GamaListFactory;
import msi.gama.util.GamaMapFactory;
import msi.gama.util.IContainer;
import msi.gama.util.IList;
import msi.gama.util.matrix.GamaField;
import msi.gaml.operators.Cast;
import msi.gaml.operators.Containers;
import msi.gaml.operators.Random;
import msi.gaml.operators.Spatial;
import msi.gaml.types.IType;
import msi.gaml.types.Types;
import org.apache.commons.math3.stat.regression.GLSMultipleLinearRegression;
import org.apache.commons.math3.stat.regression.OLSMultipleLinearRegression;
import spll.localizer.ISPLocalizer;
import spll.localizer.constraint.ISpatialConstraint;
import spll.localizer.constraint.SpatialConstraintLocalization;
import spll.localizer.distribution.ISpatialDistribution;
import spll.localizer.distribution.SpatialDistributionFactory;
import spll.localizer.linker.ISPLinker;
import spll.localizer.linker.SPLinker;
import spll.localizer.pointInalgo.PointInLocalizer;
import spll.localizer.pointInalgo.RandomPointInLocalizer;
import spll.normalizer.SPLUniformNormalizer;

public class SPLocalizer
implements ISPLocalizer {
    protected GSPerformanceUtil gspu;
    protected IList<IShape> match;
    protected IList<IShape> map;
    protected GamaField mapField;
    protected ISPLinker<IShape> linker;
    protected SpatialConstraintLocalization localizationConstraint;
    protected PointInLocalizer pointInLocalizer = new RandomPointInLocalizer();
    protected String keyAttMap;
    protected String keyAttPop;
    protected String keyAttMatch;
    protected String nestAttribute;
    protected Double minDist = null;
    protected Double maxDist = null;

    private SPLocalizer(IScope iScope) {
        this.linker = new SPLinker(SpatialDistributionFactory.getInstance().getUniformDistribution());
    }

    public SPLocalizer(IScope iScope, IContainer<?, ? extends IShape> iContainer, String string, Double d, Double d2) {
        this(iScope);
        this.localizationConstraint = new SpatialConstraintLocalization(null);
        this.localizationConstraint.setGeoms(iContainer);
        if (d != null) {
            this.localizationConstraint.setMaxIncrease(d);
        }
        if (d2 != null) {
            this.localizationConstraint.setIncreaseStep(d2);
        }
        this.linker.addConstraints(this.localizationConstraint);
        this.nestAttribute = string;
    }

    @Override
    public void localisePopulation(IScope iScope, IContainer<?, IAgent> iContainer) {
        try {
            if (this.match == null) {
                if ((this.keyAttMap == null || this.map == null) && this.mapField == null) {
                    this.localizationInNest(iScope, iContainer, null);
                } else {
                    this.localizationInNestWithNumbers(iScope, iContainer, null);
                }
            } else {
                for (IShape iShape : this.match) {
                    String string = Cast.asString((IScope)iScope, (Object)iShape.getAttribute(this.keyAttMatch));
                    IList iList = GamaListFactory.createWithoutCasting((IType)Types.AGENT, iContainer.listValue(iScope, Types.AGENT, false).stream().filter(iAgent -> iAgent.getAttribute(this.keyAttPop).equals(string)).toList());
                    if ((this.keyAttMap == null || this.map == null) && this.mapField == null) {
                        this.localizationInNest(iScope, (IContainer<?, IAgent>)iList, iShape);
                        continue;
                    }
                    this.localizationInNestWithNumbers(iScope, (IContainer<?, IAgent>)iList, iShape);
                }
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    @Override
    public void setMatcher(IList<IShape> iList, String string, String string2) {
        this.match = iList;
        this.keyAttPop = string;
        this.keyAttMatch = string2;
    }

    @Override
    public void setMatcher(IList<IShape> iList, String string, String string2, double d, double d2, int n) {
        this.setMatcher(iList, string, string2);
        this.localizationConstraint.setMaxIncrease(d);
        this.localizationConstraint.setIncreaseStep(d2);
        this.localizationConstraint.setPriority(n);
    }

    public IList<IShape> getMapperOutput() {
        return this.map;
    }

    public void buildMapField(IScope iScope, IList<IShape> iList, String string, IList<GamaField> iList2, String string2, String string3, double d, int n) {
        double[] dArray;
        List list = this.buildMapFieldData(iScope, iList, string, iList2);
        if (list == null) {
            return;
        }
        GamaField gamaField = ((GamaField)iList2.get(0)).copy(iScope, ((GamaField)iList2.get(0)).getDimensions(), true);
        gamaField.setNoData(iScope, -1.0);
        gamaField.setAllValues(iScope, (Object)-1.0);
        List list2 = (List)list.get(2);
        double[] dArray2 = (double[])list.get(0);
        double[][] dArray3 = (double[][])list.get(1);
        Map map = (Map)list.get(3);
        int n2 = dArray3[0].length;
        OLSMultipleLinearRegression oLSMultipleLinearRegression = null;
        switch (string2) {
            case "GLS": {
                oLSMultipleLinearRegression = new GLSMultipleLinearRegression();
                dArray = new double[dArray3.length * n2 + dArray2.length];
                int n3 = 0;
                int n4 = 0;
                while (n4 < dArray3.length) {
                    dArray[n3++] = dArray2[n4];
                    int n5 = 0;
                    while (n5 < n2) {
                        dArray[n3++] = dArray3[n4][n5];
                        ++n5;
                    }
                    ++n4;
                }
                ((GLSMultipleLinearRegression)oLSMultipleLinearRegression).newSampleData(dArray, dArray2.length, n2);
                break;
            }
            default: {
                oLSMultipleLinearRegression = new OLSMultipleLinearRegression();
                oLSMultipleLinearRegression.newSampleData(dArray2, dArray3);
            }
        }
        dArray = oLSMultipleLinearRegression.estimateRegressionParameters();
        double d2 = dArray[0];
        double[] dArray4 = oLSMultipleLinearRegression.estimateResiduals();
        int n6 = 0;
        while (n6 < dArray.length) {
            int n7 = n6++;
            dArray[n7] = dArray[n7] + d2;
        }
        double[][] dArray5 = new double[gamaField.numRows][gamaField.numCols];
        int n8 = 0;
        while (n8 < gamaField.numRows) {
            int n9 = 0;
            while (n9 < gamaField.numCols) {
                double d3 = 0.0;
                IShape iShape = gamaField.getCellShapeAt(iScope, n9, n8);
                Integer n10 = (Integer)map.get(new GamaPoint(iShape.getLocation().x, iShape.getLocation().y));
                if (n10 != null) {
                    double d4 = dArray4[n10];
                    int n11 = 0;
                    int n12 = 0;
                    while (n12 < list2.size()) {
                        GamaField gamaField2 = (GamaField)iList2.get(n12);
                        IList iList3 = (IList)list2.get(n12);
                        IList iList4 = gamaField2.getValuesIntersecting(iScope, iShape);
                        if (n12 == 0) {
                            iList4 = GamaListFactory.create();
                            iList4.add((Object)gamaField2.get(iScope, n9, n8));
                        } else {
                            iList4 = gamaField2.getValuesIntersecting(iScope, iShape);
                        }
                        GamaPoint gamaPoint = gamaField2.getCellSize(iScope);
                        double d5 = gamaPoint.x * gamaPoint.y;
                        int n13 = 0;
                        while (n13 < iList3.length(iScope)) {
                            Double d6 = (Double)iList3.get(n13);
                            d3 += (double)Collections.frequency(iList4, d6) * dArray[n13 + n11] * d5;
                            ++n13;
                        }
                        n11 += iList3.size();
                        ++n12;
                    }
                    if (d3 > 0.0) {
                        dArray5[n8][n9] = d3 + d4;
                    }
                }
                ++n9;
            }
            ++n8;
        }
        String string4 = string3;
        string4.hashCode();
        SPLUniformNormalizer sPLUniformNormalizer = new SPLUniformNormalizer(d, gamaField.getNoData(iScope));
        double[][] dArray6 = sPLUniformNormalizer.process(dArray5, n, true);
        int n14 = 0;
        while (n14 < gamaField.numRows) {
            int n15 = 0;
            while (n15 < gamaField.numCols) {
                gamaField.set(iScope, n15, n14, (Object)dArray6[n14][n15]);
                ++n15;
            }
            ++n14;
        }
        this.mapField = gamaField;
    }

    private void saveDouble(double[][] dArray, String string) {
        Writer writer = null;
        try {
            writer = new FileWriter("/Users/patricktaillandier/Documents/" + string + ".asc");
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        String string2 = "ncols        295\nnrows        172\nxllcorner    557070.341329975170\nyllcorner    6925932.962285792455\ncellsize     30.0\nNODATA_value 0\n";
        try {
            writer.write(string2);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        int n = 0;
        while (n < dArray.length) {
            String string3 = "";
            int n2 = 0;
            while (n2 < dArray[n].length) {
                string3 = String.valueOf(string3) + " " + dArray[n][n2];
                ++n2;
            }
            try {
                writer.write(string3);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            ++n;
        }
        try {
            ((OutputStreamWriter)writer).close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    private List buildMapFieldData(IScope iScope, IList<IShape> iList, String string, IList<GamaField> iList2) {
        Object object2;
        if (iList2.isEmpty() || iList.isEmpty() || !((IShape)iList.get(0)).hasAttribute(string)) {
            return null;
        }
        GamaMapFactory.create();
        double[] dArray = new double[iList.size()];
        ArrayList<IList> arrayList = new ArrayList<IList>();
        int n = 0;
        for (Object object2 : iList2) {
            IList iList3 = Containers.remove_duplicates((IScope)iScope, (IContainer)object2.listValue(iScope, (IType)Types.FLOAT, false));
            arrayList.add(iList3);
            n += iList3.size();
        }
        object2 = new double[iList.size()][n];
        Iterator iterator = GamaMapFactory.create();
        int n2 = iList2.size();
        int n3 = 0;
        while (n3 < dArray.length) {
            IShape iShape = (IShape)iList.get(n3);
            dArray[n3] = Cast.asFloat((IScope)iScope, (Object)iShape.getAttribute(string));
            int n4 = 0;
            int n5 = 0;
            while (n5 < n2) {
                IList iList42;
                IList iList5;
                GamaField gamaField = (GamaField)iList2.get(n5);
                GamaPoint gamaPoint = gamaField.getCellSize(iScope);
                double d = gamaPoint.x * gamaPoint.y;
                if (n5 == 0) {
                    iList5 = gamaField.getCellsIntersecting(iScope, iShape);
                    for (IList iList42 : iList5) {
                        iterator.put(new GamaPoint(iList42.getLocation().x, iList42.getLocation().y), n3);
                    }
                }
                iList5 = gamaField.getValuesIntersecting(iScope, iShape);
                iList42 = (IList)arrayList.get(n5);
                for (Object object3 : iList42) {
                    object2[n3][n4] = (GamaField)((double)Collections.frequency(iList5, object3) * d);
                    ++n4;
                }
                ++n5;
            }
            ++n3;
        }
        ArrayList<Object> arrayList2 = new ArrayList<Object>();
        arrayList2.add(dArray);
        arrayList2.add(object2);
        arrayList2.add(arrayList);
        arrayList2.add(iterator);
        return arrayList2;
    }

    @Override
    public void setConstraints(List<ISpatialConstraint> list) {
        this.linker.setConstraints(list);
    }

    @Override
    public void addConstraint(ISpatialConstraint iSpatialConstraint) {
        this.linker.addConstraints(iSpatialConstraint);
    }

    @Override
    public List<ISpatialConstraint> getConstraints() {
        return this.linker.getConstraints();
    }

    public SpatialConstraintLocalization getLocalizationConstraint() {
        return this.localizationConstraint;
    }

    @Override
    public ISpatialDistribution<IShape> getDistribution() {
        return this.linker.getDistribution();
    }

    @Override
    public void setDistribution(ISpatialDistribution<IShape> iSpatialDistribution) {
        this.linker.setDistribution(iSpatialDistribution);
    }

    public void setPointInLocalizer(PointInLocalizer pointInLocalizer) {
        this.pointInLocalizer = pointInLocalizer;
    }

    public PointInLocalizer getPointInLocalizer() {
        return this.pointInLocalizer;
    }

    private void localizationInNest(IScope iScope, IContainer<?, IAgent> iContainer, IShape iShape) throws IOException {
        this.localizationConstraint.setBounds(iShape);
        IList<IShape> iList = this.localizationConstraint.getCandidates(iScope, null);
        System.out.println("Possibles nest computed");
        if (this.linker.getConstraints().isEmpty()) {
            this.localizationInNestOp(iScope, iContainer, iList, null);
        } else {
            List<ISpatialConstraint> list = Stream.concat(this.linker.getConstraints().stream(), Stream.of(this.localizationConstraint)).sorted(Comparator.comparing(ISpatialConstraint::getPriority)).toList();
            IContainer<?, IAgent> iContainer2 = iContainer.listValue(iScope, Types.AGENT, true);
            for (ISpatialConstraint iSpatialConstraint : list) {
                while (!iSpatialConstraint.isConstraintLimitReach()) {
                    IList<IShape> iList2 = this.localizationConstraint.getGeoms().listValue(iScope, (IType)Types.GEOMETRY, true);
                    for (ISpatialConstraint iSpatialConstraint2 : list) {
                        iList2 = iSpatialConstraint2.getCandidates(iScope, (IContainer<?, ? extends IShape>)iList2);
                    }
                    if ((iContainer2 = this.localizationInNestOp(iScope, iContainer2, iList2, null)) == null || iContainer2.length(iScope) == 0) {
                        return;
                    }
                    iSpatialConstraint.relaxConstraint(iList);
                }
            }
        }
    }

    private IContainer<?, IAgent> localizationInNestOp(IScope iScope, IContainer<?, IAgent> iList, IList<IShape> iList2, Long l) {
        IList iList3 = null;
        IList iList4 = GamaListFactory.create();
        if (l != null) {
            l = Math.min(l, (long)iList.length(iScope));
            iList3 = Containers.among((IScope)iScope, (Integer)l.intValue(), iList);
        } else {
            iList3 = iList;
        }
        if (iList2.isEmpty()) {
            return iList4;
        }
        this.linker.getDistribution().setCandidate(iList2);
        int n = 0;
        for (IAgent iAgent : iList3.iterable(iScope)) {
            if (++n % 100 == 0) {
                System.out.println("done: " + n + "/" + iList3.length(iScope));
            }
            if (iList2.isEmpty()) break;
            Optional<IShape> optional = this.linker.getCandidate(iScope, iAgent, iList2);
            boolean bl = false;
            if (!optional.isPresent()) continue;
            IShape iShape = optional.get();
            for (ISpatialConstraint iSpatialConstraint : this.linker.getConstraints()) {
                boolean bl2 = bl = bl || iSpatialConstraint.updateConstraint(iShape);
            }
            if (bl) {
                ISpatialConstraint iSpatialConstraint;
                iSpatialConstraint = (IShape)iList2.remove(0);
                this.linker.getDistribution().removeNest((IShape)iSpatialConstraint);
            }
            if (this.nestAttribute != null) {
                iAgent.setAttribute(this.nestAttribute, (Object)iShape);
            }
            iList4.add((Object)iAgent);
            iAgent.setLocation(this.pointInLocalizer.pointIn(iScope, iShape));
        }
        return iList4;
    }

    @Override
    public void setMapper(IList<IShape> iList, String string, GamaField gamaField) {
        this.map = iList;
        this.keyAttMap = string;
        this.mapField = gamaField;
    }

    private void localizationInNestWithNumbers(IScope iScope, IContainer<?, IAgent> iContainer, IShape iShape) throws IOException {
        if (this.mapField != null) {
            this.localizationInNestWithNumbersField(iScope, iContainer, iShape);
        } else {
            this.localizationInNestWithNumbersMap(iScope, iContainer, iShape);
        }
    }

    private void localizationInNestWithNumbersField(IScope iScope, IContainer<?, IAgent> iContainer, IShape iShape) throws IOException {
        Double d;
        ArrayList<ISpatialConstraint> arrayList = new ArrayList<ISpatialConstraint>(this.linker.getConstraints());
        IList iList = null;
        if (iShape == null) {
            iList = GamaListFactory.create();
            int n = 0;
            while (n < this.mapField.numCols) {
                int n2 = 0;
                while (n2 < this.mapField.numRows) {
                    d = this.mapField.getCellShapeAt(iScope, n, n2);
                    iList.add((Object)d);
                    ++n2;
                }
                ++n;
            }
        } else {
            iList = this.mapField.getCellsIntersecting(iScope, iShape);
        }
        double d3 = this.mapField.getNoData(iScope);
        d = this.mapField.listValue(iScope, (IType)Types.FLOAT, false).stream().mapToDouble(d2 -> d2 <= 0.0 || d2 == d3 ? 0.0 : d2).sum();
        if (d == 0.0) {
            return;
        }
        IList iList2 = (IList)iContainer.copy(iScope);
        int n = 0;
        while (n < iList.size()) {
            IShape iShape2 = (IShape)iList.get(n);
            Double d4 = this.mapField.get(iScope, iShape2.getLocation());
            if (!(d4 <= 0.0) && d4 != d3) {
                IShape iShape3 = (IShape)iList.get(n);
                this.localizationConstraint.setBounds(iShape3);
                long l = Math.round((double)iContainer.length(iScope) * d4 / d);
                if (l != 0L) {
                    if (iList2.isEmpty(iScope)) break;
                    for (ISpatialConstraint iSpatialConstraint : this.linker.getConstraints()) {
                        while (!iList2.isEmpty(iScope) && !iSpatialConstraint.isConstraintLimitReach()) {
                            ISpatialConstraint iSpatialConstraint22;
                            IList<IShape> iList3 = this.localizationConstraint.getCandidates(iScope, null);
                            IList<IShape> iList4 = iList3.copy(iScope);
                            for (ISpatialConstraint iSpatialConstraint22 : arrayList) {
                                iList4 = iSpatialConstraint22.getCandidates(iScope, (IContainer<?, ? extends IShape>)iList4);
                            }
                            iSpatialConstraint22 = (IList)this.localizationInNestOp(iScope, (IContainer<?, IAgent>)iList2, iList4, l);
                            iSpatialConstraint22.length(iScope);
                            iList2.removeAll((Collection)((Object)iSpatialConstraint22));
                            if ((l -= (long)iSpatialConstraint22.length(iScope)) == 0L) break;
                            if (iList2.isEmpty(iScope)) continue;
                            iSpatialConstraint.relaxConstraint((IList<IShape>)((IList)this.localizationConstraint.getGeoms()));
                        }
                        if (iList2.isEmpty(iScope) || l == 0L) break;
                    }
                }
            }
            ++n;
        }
    }

    private void localizationInNestWithNumbersMap(IScope iScope, IContainer<?, IAgent> iContainer, IShape iShape2) throws IOException {
        ArrayList<ISpatialConstraint> arrayList = new ArrayList<ISpatialConstraint>(this.linker.getConstraints());
        IList iList = iShape2 == null ? this.map.copy(iScope) : Spatial.Queries.overlapping((IScope)iScope, this.map, (IShape)iShape2);
        iList = Random.opShuffle((IScope)iScope, (IContainer)iList);
        Map<IShape, Double> map = this.map.stream().collect(Collectors.toMap(iShape -> iShape, iShape -> Cast.asFloat((IScope)iScope, (Object)iShape.getAttribute(this.keyAttMap))));
        Double d2 = map.values().stream().mapToDouble(d -> d).sum();
        if (d2 == 0.0) {
            return;
        }
        int n = 0;
        IContainer iContainer2 = (IContainer)iContainer.copy(iScope);
        if (iList != null) {
            int n2 = 0;
            while (n2 < iList.length(iScope)) {
                IShape iShape3 = (IShape)iList.get(n2);
                this.localizationConstraint.setBounds(iShape3);
                long l = Math.round((double)iContainer.length(iScope) * map.get(iShape3) / d2);
                n = (int)((long)n + l);
                if (n2 == iList.length(iScope) - 1) {
                    l += (long)(iContainer.length(iScope) - n);
                }
                if (iContainer.isEmpty(iScope)) break;
                for (ISpatialConstraint iSpatialConstraint : this.linker.getConstraints()) {
                    while (!iContainer2.isEmpty(iScope) && !iSpatialConstraint.isConstraintLimitReach()) {
                        IList<IShape> iList2 = this.localizationConstraint.getCandidates(iScope, null);
                        IList<IShape> iList3 = iList2.copy(iScope);
                        for (ISpatialConstraint iSpatialConstraint2 : arrayList) {
                            iList3 = iSpatialConstraint2.getCandidates(iScope, (IContainer<?, ? extends IShape>)iList3);
                        }
                        IContainer<?, IAgent> iContainer32 = this.localizationInNestOp(iScope, iContainer2, iList3, l);
                        iContainer2 = Containers.minus((IScope)iScope, (IContainer)iContainer2, iContainer32);
                        if ((l -= (long)iContainer32.length(iScope)) == 0L) break;
                        if (iContainer2.isEmpty(iScope)) continue;
                        iSpatialConstraint.relaxConstraint((IList<IShape>)((IList)this.localizationConstraint.getGeoms()));
                    }
                    if (iContainer2.isEmpty(iScope) || l == 0L) break;
                }
                ++n2;
            }
        }
    }

    public void setMinDistance(Double d) {
        this.minDist = d;
    }

    public void setMaxDistance(Double d) {
        this.maxDist = d;
    }

    public void computeMinMaxDistance(IScope iScope, IList<IShape> iList) {
        IShape iShape = Spatial.Operators.union((IScope)iScope, iList);
        IShape iShape2 = null;
        if (this.maxDist != null && this.maxDist > 0.0) {
            if (this.minDist != null && this.minDist >= this.maxDist) {
                iShape2 = Spatial.Transformations.enlarged_by((IScope)iScope, (IShape)iShape, (Double)this.maxDist).getExteriorRing(iScope);
            } else {
                iShape2 = Spatial.Transformations.enlarged_by((IScope)iScope, (IShape)iShape, (Double)this.maxDist);
                if (this.minDist != null && this.minDist > 0.0) {
                    iShape2 = Spatial.Operators.minus((IScope)iScope, (IShape)iShape2, (IShape)Spatial.Transformations.enlarged_by((IScope)iScope, (IShape)iShape, (Double)this.minDist));
                }
            }
            iShape2 = Spatial.Operators.inter((IScope)iScope, (IShape)iShape2, (IShape)iScope.getSimulation().getGeometry());
        } else if (this.minDist != null && this.minDist > 0.0) {
            iShape2 = Spatial.Operators.minus((IScope)iScope, (IShape)iScope.getSimulation().getGeometry(), (IShape)Spatial.Transformations.enlarged_by((IScope)iScope, (IShape)iShape, (Double)this.minDist));
        }
        this.localizationConstraint.setGeoms((IContainer<?, ? extends IShape>)iShape2.getGeometries());
    }
}

