/*
 * Decompiled with CFR 0.152.
 */
package spll.localizer.distribution;

import core.util.random.roulette.ARouletteWheelSelection;
import core.util.random.roulette.RouletteWheelSelectionFactory;
import java.util.stream.Collectors;
import msi.gama.metamodel.agent.IAgent;
import msi.gama.metamodel.shape.IShape;
import msi.gama.runtime.IScope;
import msi.gama.util.GamaListFactory;
import msi.gama.util.IList;
import msi.gaml.types.IType;
import msi.gaml.types.Types;
import spll.localizer.distribution.ISpatialDistribution;
import spll.localizer.distribution.function.ISpatialEntityFunction;

public class BasicSpatialDistribution<N extends Number, E extends IShape>
implements ISpatialDistribution<IShape> {
    private ISpatialEntityFunction<N> function;
    private ARouletteWheelSelection<N, IShape> roulette;

    public BasicSpatialDistribution(ISpatialEntityFunction<N> iSpatialEntityFunction) {
        this.function = iSpatialEntityFunction;
    }

    @Override
    public IShape getCandidate(IScope iScope, IAgent iAgent, IList<? extends IShape> iList) {
        if (this.roulette != null && this.roulette.getKeys().equals(iList)) {
            return (IShape)this.roulette.drawObject();
        }
        return (IShape)RouletteWheelSelectionFactory.getRouletteWheel(iList.stream().map(iShape -> (Number)this.function.apply(iShape)).collect(Collectors.toList()), iList).drawObject();
    }

    @Override
    public IShape getCandidate(IScope iScope, IAgent iAgent) {
        if (this.roulette == null || this.roulette.getKeys().isEmpty()) {
            throw new NullPointerException("No candidate geographic entity to draw from");
        }
        return (IShape)this.roulette.drawObject();
    }

    @Override
    public void setCandidate(IList<? extends IShape> iList) {
        this.roulette = RouletteWheelSelectionFactory.getRouletteWheel(iList.stream().map(iShape -> (Number)this.function.apply(iShape)).toList(), iList);
    }

    @Override
    public IList<IShape> getCandidates(IScope iScope) {
        return GamaListFactory.createWithoutCasting((IType)Types.GEOMETRY, this.roulette.getKeys());
    }

    @Override
    public void removeNest(IShape iShape) {
        this.roulette.remove(iShape);
    }
}

