/*
 * Decompiled with CFR 0.152.
 */
package spll.localizer.distribution;

import msi.gama.metamodel.agent.IAgent;
import msi.gama.metamodel.shape.IShape;
import msi.gama.runtime.IScope;
import msi.gama.util.IList;
import spll.localizer.constraint.SpatialConstraintMaxNumber;
import spll.localizer.distribution.BasicSpatialDistribution;
import spll.localizer.distribution.ComplexSpatialDistribution;
import spll.localizer.distribution.ISpatialDistribution;
import spll.localizer.distribution.UniformSpatialDistribution;
import spll.localizer.distribution.function.AreaFunction;
import spll.localizer.distribution.function.CapacityFunction;
import spll.localizer.distribution.function.DistanceFunction;
import spll.localizer.distribution.function.GravityFunction;
import spll.localizer.distribution.function.ISpatialComplexFunction;
import spll.localizer.distribution.function.ISpatialEntityFunction;

public class SpatialDistributionFactory {
    private static SpatialDistributionFactory sdf = new SpatialDistributionFactory();

    private SpatialDistributionFactory() {
    }

    public static SpatialDistributionFactory getInstance() {
        return sdf;
    }

    public <N extends Number, E extends IShape> ISpatialDistribution<IShape> getDistribution(ISpatialEntityFunction<N> iSpatialEntityFunction) {
        return new BasicSpatialDistribution(iSpatialEntityFunction);
    }

    public <N extends Number, E extends IShape> ISpatialDistribution<IShape> getDistribution(ISpatialEntityFunction<N> iSpatialEntityFunction, IList<IShape> iList) {
        BasicSpatialDistribution basicSpatialDistribution = new BasicSpatialDistribution(iSpatialEntityFunction);
        basicSpatialDistribution.setCandidate(iList);
        return basicSpatialDistribution;
    }

    public <IAgent> ISpatialDistribution<IShape> getUniformDistribution() {
        return new UniformSpatialDistribution();
    }

    public <IAgent> ISpatialDistribution<IShape> getAreaBasedDistribution() {
        return this.getDistribution(new AreaFunction());
    }

    public <IAgent> ISpatialDistribution<IShape> getAreaBasedDistribution(IScope iScope, IList<IShape> iList) {
        return this.getDistribution(new AreaFunction(), iList);
    }

    public <IAgent> ISpatialDistribution<IShape> getCapacityBasedDistribution(SpatialConstraintMaxNumber spatialConstraintMaxNumber) {
        return new BasicSpatialDistribution(new CapacityFunction(spatialConstraintMaxNumber));
    }

    public <N extends Number> ISpatialDistribution getDistribution(ISpatialComplexFunction<N> iSpatialComplexFunction) {
        return new ComplexSpatialDistribution<N>(iSpatialComplexFunction);
    }

    public <N extends Number> ISpatialDistribution getDistribution(ISpatialComplexFunction<N> iSpatialComplexFunction, IList<IShape> iList) {
        ComplexSpatialDistribution<N> complexSpatialDistribution = new ComplexSpatialDistribution<N>(iSpatialComplexFunction);
        complexSpatialDistribution.setCandidate(iList);
        return complexSpatialDistribution;
    }

    public ISpatialDistribution getDistanceBasedDistribution() {
        return new ComplexSpatialDistribution<Double>(new DistanceFunction());
    }

    public ISpatialDistribution getGravityModelDistribution(IList<IShape> iList, double d, IList<IAgent> iList2) {
        return new ComplexSpatialDistribution<Double>(new GravityFunction(iList, d, iList2));
    }

    public ISpatialDistribution getGravityModelDistribution(IScope iScope, IList<IShape> iList, double d, double d2, IList<IAgent> iList2) {
        return new ComplexSpatialDistribution<Double>(new GravityFunction(iScope, iList, d, d2, iList2));
    }
}

