/*
 * Decompiled with CFR 0.152.
 */
package spll.localizer.linker;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.SequencedCollection;
import java.util.function.Function;
import java.util.stream.Collectors;
import msi.gama.metamodel.agent.IAgent;
import msi.gama.metamodel.shape.IShape;
import msi.gama.runtime.IScope;
import msi.gama.util.GamaListFactory;
import msi.gama.util.IContainer;
import msi.gama.util.IList;
import spll.localizer.constraint.ISpatialConstraint;
import spll.localizer.distribution.ISpatialDistribution;
import spll.localizer.linker.ISPLinker;

public class SPLinker
implements ISPLinker<IShape> {
    private ISpatialDistribution<IShape> distribution;
    private List<ISpatialConstraint> constraints;
    private ISPLinker.ConstraintsReleaseRule rule;

    public SPLinker(ISpatialDistribution<IShape> iSpatialDistribution) {
        this.distribution = iSpatialDistribution;
        this.constraints = new ArrayList<ISpatialConstraint>();
        this.rule = ISPLinker.ConstraintsReleaseRule.PRIORITY;
    }

    public SPLinker(ISpatialDistribution<IShape> iSpatialDistribution, ISPLinker.ConstraintsReleaseRule constraintsReleaseRule) {
        this(iSpatialDistribution);
        this.rule = constraintsReleaseRule;
    }

    @Override
    public Optional<IShape> getCandidate(IScope iScope, IAgent iAgent, IList<IShape> iList) {
        IList<IShape> iList2 = this.filter(iScope, iList);
        return iList2.isEmpty() ? Optional.empty() : Optional.ofNullable(this.distribution.getCandidate(iScope, iAgent, iList2));
    }

    @Override
    public Map<IAgent, Optional<IShape>> getCandidates(IScope iScope, IList<IAgent> iList, IList<IShape> iList2) {
        Map<IAgent, Optional<IShape>> map = iList.stream().collect(Collectors.toMap(Function.identity(), iAgent -> this.getCandidate(iScope, (IAgent)iAgent, iList2)));
        SequencedCollection<Object> sequencedCollection = new LinkedHashSet<IList<IShape>>();
        for (IList<IShape> iList3 : map.keySet()) {
            if (!map.get(iList3).isPresent()) {
                sequencedCollection.add(iList3);
                continue;
            }
            this.constraints.forEach(iSpatialConstraint -> {
                boolean bl = iSpatialConstraint.updateConstraint((IShape)((Optional)map.get(iList3)).get());
            });
        }
        if (!sequencedCollection.isEmpty()) {
            IList<IShape> iList3;
            iList3 = null;
            do {
                iList3 = this.filterWithRelease(iScope, iList2);
                map.clear();
                for (IAgent iAgent2 : sequencedCollection) {
                    Optional<IShape> optional = Optional.ofNullable(this.distribution.getCandidate(iScope, iAgent2, (IList<IShape>)iList3.copy(iScope)));
                    if (!optional.isPresent()) continue;
                    map.put(iAgent2, optional);
                    this.constraints.stream().forEach(iSpatialConstraint -> {
                        boolean bl = iSpatialConstraint.updateConstraint((IShape)optional.get());
                    });
                }
            } while (!(sequencedCollection = map.keySet().stream().filter(iAgent -> !((Optional)map.get(iAgent)).isPresent()).toList()).isEmpty() || this.constraints.stream().allMatch(ISpatialConstraint::isConstraintLimitReach));
        }
        return map;
    }

    @Override
    public void setDistribution(ISpatialDistribution<IShape> iSpatialDistribution) {
        this.distribution = iSpatialDistribution;
    }

    @Override
    public ISpatialDistribution<IShape> getDistribution() {
        return this.distribution;
    }

    @Override
    public IList<IShape> filterWithRelease(IScope iScope, IList<IShape> iList) {
        IList<IShape> iList2 = iList.copy(iScope);
        List list = this.constraints.stream().sorted((iSpatialConstraint, iSpatialConstraint2) -> Integer.compare(iSpatialConstraint.getPriority(), iSpatialConstraint2.getPriority())).toList();
        switch (this.rule) {
            case LINEAR: {
                do {
                    IList<IShape> iList3 = iList2.copy(iScope);
                    for (ISpatialConstraint iSpatialConstraint3 : list.stream().filter(iSpatialConstraint -> !iSpatialConstraint.isConstraintLimitReach()).toList()) {
                        iList3 = iSpatialConstraint3.getCandidates(iScope, (IContainer<?, ? extends IShape>)iList2);
                        if (!iList3.isEmpty()) continue;
                        iSpatialConstraint3.relaxConstraint(iList3);
                        iList3 = iSpatialConstraint3.getCandidates(iScope, (IContainer<?, ? extends IShape>)iList3);
                    }
                    if (iList3.isEmpty()) continue;
                    return iList3;
                } while (list.stream().noneMatch(iSpatialConstraint -> !iSpatialConstraint.isConstraintLimitReach()));
                return GamaListFactory.EMPTY_LIST;
            }
        }
        for (ISpatialConstraint iSpatialConstraint4 : list) {
            IList<IShape> iList4 = iSpatialConstraint4.getCandidates(iScope, (IContainer<?, ? extends IShape>)iList2);
            if (iList4.isEmpty()) {
                do {
                    iSpatialConstraint4.relaxConstraint(iList2);
                } while (!(iList4 = iSpatialConstraint4.getCandidates(iScope, (IContainer<?, ? extends IShape>)iList2)).isEmpty() && !iSpatialConstraint4.isConstraintLimitReach());
            }
            if (iList4.isEmpty()) {
                return GamaListFactory.EMPTY_LIST;
            }
            iList2 = iList4;
        }
        return iList2;
    }

    @Override
    public IList<IShape> filter(IScope iScope, IList<IShape> iList) {
        IList<IShape> iList2 = iList.copy(iScope);
        List list = this.constraints.stream().sorted((iSpatialConstraint, iSpatialConstraint2) -> Integer.compare(iSpatialConstraint.getPriority(), iSpatialConstraint2.getPriority())).toList();
        for (ISpatialConstraint iSpatialConstraint3 : list) {
            iList2 = iSpatialConstraint3.getCandidates(iScope, (IContainer<?, ? extends IShape>)iList2);
            if (!iList2.isEmpty()) continue;
            return GamaListFactory.create();
        }
        return iList2;
    }

    @Override
    public void setConstraints(List<ISpatialConstraint> list) {
        this.constraints = list;
    }

    @Override
    public void addConstraints(ISpatialConstraint ... iSpatialConstraintArray) {
        this.constraints.addAll(Arrays.asList(iSpatialConstraintArray));
    }

    @Override
    public List<ISpatialConstraint> getConstraints() {
        return Collections.unmodifiableList(this.constraints);
    }

    @Override
    public ISPLinker.ConstraintsReleaseRule getConstraintsReleaseRule() {
        return this.rule;
    }

    @Override
    public void setConstraintsReleaseRule(ISPLinker.ConstraintsReleaseRule constraintsReleaseRule) {
        this.rule = constraintsReleaseRule;
    }

    @Override
    public void assignLink(IScope iScope, IList<IAgent> iList, IList<? extends IShape> iList2, String string) {
        for (IAgent iAgent : iList) {
            Optional<IShape> optional = this.getCandidate(iScope, iAgent, (IList<IShape>)iList2);
            if (optional.isPresent()) {
                iAgent.setAttribute(string, (Object)optional.get());
                continue;
            }
            iAgent.setAttribute(string, null);
        }
    }
}

