/*
 * Decompiled with CFR 0.152.
 */
package ummisco.matlab.gaml.species;

import com.mathworks.engine.MatlabEngine;
import java.util.ArrayList;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import msi.gama.metamodel.agent.GamlAgent;
import msi.gama.metamodel.agent.IAgent;
import msi.gama.metamodel.population.IPopulation;
import msi.gama.precompiler.GamlAnnotations;
import msi.gama.runtime.IScope;
import msi.gama.runtime.exceptions.GamaRuntimeException;
import msi.gama.util.file.GamaFile;
import ummisco.matlab.gama.matlabengine.MatlabEngineInteraction;
import ummisco.matlab.gama.matlabengine.MatlabEngineManager;

@GamlAnnotations.species(name="agent_MATLAB", doc={@GamlAnnotations.doc(value="The species of agents that can connect to MATLAB software to launch some computations on it.")})
@GamlAnnotations.vars(value={@GamlAnnotations.variable(name="path_to_matlab", type=4, doc={@GamlAnnotations.doc(value="The path to Matlab.")})})
public class AgentMATLAB
extends GamlAgent {
    String pathToMatlab;
    MatlabEngine eng;
    boolean aSyncEngine = true;
    ArrayList<String> addedPaths;

    public AgentMATLAB(IPopulation<? extends IAgent> iPopulation, int n) {
        super(iPopulation, n);
    }

    @GamlAnnotations.getter(value="path_to_matlab", initializer=true)
    public String getPathToMatlab() {
        return this.pathToMatlab;
    }

    @GamlAnnotations.setter(value="path_to_matlab")
    public void setPathToMatlab(String string) {
        this.pathToMatlab = string;
    }

    public boolean init(IScope iScope) {
        boolean bl = super.init(iScope);
        this.eng = MatlabEngineManager.startMatlabEngine(this.getScope(), this.aSyncEngine);
        this.addedPaths = new ArrayList();
        return bl;
    }

    @GamlAnnotations.action(name="restart_engine", args={@GamlAnnotations.arg(name="async", type=3, optional=true, doc={@GamlAnnotations.doc(value="whether the engin is asynchronous")})})
    public void restartEngine(IScope iScope) throws GamaRuntimeException {
        Boolean bl = (Boolean)iScope.getArg("async", 3);
        if (bl == null) {
            bl = false;
        }
        MatlabEngineManager.disconnectMatlabEngine(iScope, this.eng, bl);
        this.eng = MatlabEngineManager.startMatlabEngine(this.getScope(), bl);
        this.addedPaths = new ArrayList();
    }

    @GamlAnnotations.action(name="disconnect_engine", args={@GamlAnnotations.arg(name="async", type=3, optional=true, doc={@GamlAnnotations.doc(value="whether the engin is asynchronous")})})
    public void disconnectEngine(IScope iScope) throws GamaRuntimeException {
        Boolean bl = (Boolean)iScope.getArg("async", 3);
        if (bl == null) {
            bl = false;
        }
        MatlabEngineManager.disconnectMatlabEngine(iScope, this.eng, bl);
    }

    @GamlAnnotations.action(name="test_engine")
    public boolean testConnection(IScope iScope) {
        try {
            double[][] dArray = new double[4][4];
            int n = 0;
            while (n < 4) {
                int n2 = 0;
                while (n2 < 4) {
                    double d;
                    dArray[n][n2] = d = Math.random() * 10.0;
                    ++n2;
                }
                ++n;
            }
            this.eng.putVariableAsync("testGAMA", (Object)dArray);
            this.eng.eval("testGAMAResult=testGAMA(testGAMA>5);");
            Future future = this.eng.getVariableAsync("testGAMAResult");
            future.get();
        }
        catch (IllegalArgumentException | IllegalStateException | InterruptedException | ExecutionException exception) {
            throw GamaRuntimeException.error((String)"Connection to Matlab Failed", (IScope)iScope);
        }
        return true;
    }

    @GamlAnnotations.action(name="eval", args={@GamlAnnotations.arg(name="expression", type=4, optional=true, doc={@GamlAnnotations.doc(value="the expression to evaluate with the Matlab engine")}), @GamlAnnotations.arg(name="file", type=12, optional=true, doc={@GamlAnnotations.doc(value="the file to load in the Matlab Engine")})})
    public void eval(IScope iScope) {
        if (iScope.hasArg("expression")) {
            String string = (String)iScope.getArg("expression", 4);
            MatlabEngineInteraction.eval(iScope, this.eng, string);
        } else if (iScope.hasArg("file")) {
            GamaFile gamaFile = (GamaFile)iScope.getArg("file", 12);
            System.out.println(gamaFile.getPath(iScope));
            System.out.println(gamaFile.getName(iScope));
            String string = gamaFile.getPath(iScope);
            String string2 = gamaFile.getName(iScope);
            String string3 = string.substring(0, string.length() - string2.length());
            if (!this.addedPaths.contains(string3)) {
                MatlabEngineInteraction.eval(iScope, this.eng, "path('" + string3 + "', path)");
                this.addedPaths.add(string3);
            }
            String string4 = string2.substring(0, string2.length() - gamaFile.getExtension(iScope).length() - 1);
            MatlabEngineInteraction.eval(iScope, this.eng, string4);
        }
    }

    @GamlAnnotations.action(name="value_of", args={@GamlAnnotations.arg(name="variable_name", type=4, optional=false, doc={@GamlAnnotations.doc(value="the name of the MATLAB variable that we want to get the value")})})
    public @GamlAnnotations.arg(name="variable_name", type=4, optional=false, doc={@GamlAnnotations.doc(value="the name of the MATLAB variable that we want to get the value")}) @GamlAnnotations.doc(value="the name of the MATLAB variable that we want to get the value") Object get(IScope iScope) {
        String string = (String)iScope.getArg("variable_name", 4);
        return MatlabEngineInteraction.getVariable(iScope, this.eng, string);
    }
}

