/*
 * Decompiled with CFR 0.152.
 */
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import msi.gama.lang.gaml.indexer.GamlResourceIndexer;
import msi.gaml.compilation.GAML;
import msi.gaml.compilation.ast.ISyntacticElement;
import msi.gaml.descriptions.IDescription;
import msi.gaml.types.Types;
import org.eclipse.core.resources.IFile;
import org.eclipse.emf.common.util.URI;
import ummisco.gama.ui.navigator.contents.WrappedGamaFile;

public class GamlToUMLConverter {
    ISyntacticElement model;
    Iterator<URI> importedModelsURIs;
    VisitorForSpeciesChildren visitorForSpeciesChildren;
    VisitorForSpeciesFacets visitorForSpeciesFacets;
    public XMLStringBuilder umlText;
    public Map<String, ISyntacticElement> species;
    public Map<String, Map<String, ISyntacticElement>> attributes;
    public Map<String, Map<String, ISyntacticElement>> operations;
    public Map<String, Map<String, ISyntacticElement>> associations;
    public Map<String, Map<String, ISyntacticElement>> compositions;
    public Map<String, String> generalizations;
    public ArrayList<String> speciesName;
    public int id = 0;
    ISyntacticElement.SyntacticVisitor visitorForSpecies;

    public GamlToUMLConverter(WrappedGamaFile wrappedGamaFile, boolean bl) {
        this.model = GAML.getContents((URI)URI.createURI((String)((IFile)wrappedGamaFile.getResource()).getLocationURI().toString()));
        this.importedModelsURIs = GamlResourceIndexer.allImportsOf((URI)URI.createURI((String)((IFile)wrappedGamaFile.getResource()).getRawLocationURI().toString())).keySet().iterator();
        this.umlText = new XMLStringBuilder();
        this.species = new HashMap<String, ISyntacticElement>();
        this.attributes = new HashMap<String, Map<String, ISyntacticElement>>();
        this.operations = new HashMap<String, Map<String, ISyntacticElement>>();
        this.associations = new HashMap<String, Map<String, ISyntacticElement>>();
        this.compositions = new HashMap<String, Map<String, ISyntacticElement>>();
        this.generalizations = new HashMap<String, String>();
        this.speciesName = new ArrayList();
        this.visitorForSpeciesChildren = new VisitorForSpeciesChildren(this);
        this.visitorForSpeciesFacets = new VisitorForSpeciesFacets(this);
        this.visitorForSpecies = iSyntacticElement -> {
            if ((iSyntacticElement.isSpecies() || iSyntacticElement.getKeyword().equals(IParser.GAMA_KEYWORD_GRID)) && !this.speciesName.contains(iSyntacticElement.getName())) {
                ++this.id;
                this.species.put(Integer.toString(this.id), iSyntacticElement);
                this.speciesName.add(iSyntacticElement.getName());
                this.visitorForSpeciesChildren.setSpecies(Integer.toString(this.id));
                this.visitorForSpeciesFacets.setSpecies(Integer.toString(this.id));
                iSyntacticElement.visitAllChildren((ISyntacticElement.SyntacticVisitor)this.visitorForSpeciesChildren);
                iSyntacticElement.visitFacets((IDescription.IFacetVisitor)this.visitorForSpeciesFacets);
                iSyntacticElement.visitSpecies(this.visitorForSpecies);
            }
        };
        this.loadSpecies();
        this.generateBeginning();
        this.generateSpecies(bl);
        this.generateEnding();
    }

    public void loadSpecies() {
        while (this.importedModelsURIs.hasNext()) {
            URI uRI = this.importedModelsURIs.next();
            ISyntacticElement iSyntacticElement = GAML.getContents((URI)uRI);
            iSyntacticElement.visitSpecies(this.visitorForSpecies);
            iSyntacticElement.visitGrids(this.visitorForSpecies);
        }
        this.model.visitSpecies(this.visitorForSpecies);
        this.model.visitGrids(this.visitorForSpecies);
    }

    public String getIdSpecies(String string) {
        for (String string2 : this.species.keySet()) {
            if (!this.species.get(string2).getName().equals(string)) continue;
            return string2;
        }
        return "";
    }

    public String getIdAttributeFromAssociation(String string, String string2) {
        for (String string3 : this.attributes.get(string).keySet()) {
            if (!this.attributes.get(string).get(string3).getName().equals(string2)) continue;
            return string3;
        }
        return "";
    }

    public String getIdAssociationFromAttribute(String string, String string2) {
        for (String string3 : this.associations.get(string).keySet()) {
            if (!this.associations.get(string).get(string3).getName().equals(string2)) continue;
            return string3;
        }
        return "";
    }

    public String getIdParent(String string) {
        if (this.generalizations.containsKey(string)) {
            return this.getIdSpecies(this.generalizations.get(string));
        }
        return "";
    }

    public void generateBeginning() {
        this.umlText.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        this.umlText.nextLine();
        this.umlText.append("<uml:Model xmi:version=\"2.1\" xmlns:xmi=\"http://schema.omg.org/spec/XMI/2.1\" xmlns:uml=\"http://www.eclipse.org/uml2/3.0.0/UML\" xmi:id=\"_NpznoOUmEeeAeY96UuZjHg\" name=\"" + this.model.getName() + "\">");
    }

    public void generateEnding() {
        this.umlText.nextLine();
        this.umlText.append("</uml:Model>");
    }

    public void generateSpecies(boolean bl) {
        for (String string : this.species.keySet()) {
            this.umlText.nextLine();
            this.umlText.append("\t <" + IParser.XML_TAG_CLASS + " xmi:type=\"" + IParser.XML_KEYWORD_CLASS + "\" " + IParser.XML_KEYWORD_ID + "=\"" + string + "\" name=\"" + this.species.get(string).getName() + "\">");
            String string2 = this.getIdParent(string);
            if (!string2.equals("")) {
                this.umlText.nextLine();
                ++this.id;
                this.umlText.append("\t \t <" + IParser.XML_TAG_GENERALIZATION + " xmi:id=\"" + this.id + "\" general=\"" + string2 + "\"/>");
            }
            if (!bl) {
                if (this.attributes.containsKey(string)) {
                    for (String string3 : this.attributes.get(string).keySet()) {
                        this.umlText.nextLine();
                        this.umlText.append("\t \t <" + IParser.XML_TAG_ATTRIBUTE + " " + IParser.XML_KEYWORD_ID + "=\"" + string3 + "\" name=\"" + this.attributes.get(string).get(string3).getName() + "\" visibility=\"public\" isUnique=\"false\"");
                        var7_12 = this.attributes.get(string).get(string3).getKeyword();
                        if (Types.get((String)var7_12).toString().equals("unknown")) {
                            this.umlText.append(" type=\"" + this.getIdSpecies(var7_12) + "\" association=\"" + this.getIdAssociationFromAttribute(string, this.attributes.get(string).get(string3).getName()) + "\">");
                        } else {
                            this.umlText.append(">");
                            this.umlText.nextLine();
                            this.umlText.append("\t \t \t <" + IParser.XML_TAG_TYPE + " xmi:type=\"uml:PrimitiveType\" href=\"" + IParser.MAP_BUILT_IN_TYPES.get(var7_12) + "\"/>");
                        }
                        this.umlText.nextLine();
                        this.umlText.append("\t \t </" + IParser.XML_TAG_ATTRIBUTE + ">");
                    }
                }
                if (this.operations.containsKey(string)) {
                    for (String string4 : this.operations.get(string).keySet()) {
                        this.umlText.nextLine();
                        this.umlText.append("\t \t <" + IParser.XML_TAG_OPERATION + " " + IParser.XML_KEYWORD_ID + "=\"" + string4 + "\" name=\"" + this.operations.get(string).get(string4).getName() + "\" visibility=\"public\" >");
                        if (this.operations.get(string).get(string4).hasFacet(IParser.GAMA_KEYWORD_TYPE) && !this.operations.get(string).get(string4).getExpressionAt(IParser.GAMA_KEYWORD_TYPE).toString().equals("null")) {
                            var7_12 = this.operations.get(string).get(string4).getExpressionAt(IParser.GAMA_KEYWORD_TYPE).toString();
                            ++this.id;
                            this.umlText.nextLine();
                            this.umlText.append("\t \t \t <" + IParser.XML_TAG_PARAMETER + " xmi:id=\"" + this.id + "\"  isUnique=\"false\" direction=\"return\" ");
                            if (Types.get((String)var7_12).toString().equals(IParser.GAMA_KEYWORD_UNKNOWN)) {
                                this.umlText.append("type=\"" + this.getIdSpecies(var7_12) + "\" >");
                            } else {
                                this.umlText.append(">");
                                this.umlText.nextLine();
                                this.umlText.append("\t \t \t \t <" + IParser.XML_TAG_TYPE + " xmi:type=\"uml:PrimitiveType\" href=\"" + IParser.MAP_BUILT_IN_TYPES.get(var7_12) + "\"/>");
                            }
                            this.umlText.nextLine();
                            this.umlText.append("\t \t \t </" + IParser.XML_TAG_PARAMETER + ">");
                        }
                        var7_12 = iSyntacticElement -> {
                            if (iSyntacticElement.getKeyword().equals(IParser.GAMA_KEYWORD_ARG)) {
                                ++this.id;
                                String string = iSyntacticElement.getExpressionAt(IParser.GAMA_KEYWORD_TYPE).toString();
                                this.umlText.nextLine();
                                this.umlText.append("\t \t \t <" + IParser.XML_TAG_PARAMETER + " xmi:id=\"" + this.id + "\"  isUnique=\"false\"");
                                if (Types.get((String)string).toString().equals(IParser.GAMA_KEYWORD_UNKNOWN)) {
                                    this.umlText.append(" type=\"" + this.getIdSpecies(string) + "\" >");
                                } else {
                                    this.umlText.append(">");
                                    this.umlText.nextLine();
                                    this.umlText.append("\t \t \t \t <" + IParser.XML_TAG_TYPE + " xmi:type=\"uml:PrimitiveType\" href=\"" + IParser.MAP_BUILT_IN_TYPES.get(string) + "\"/>");
                                }
                                this.umlText.nextLine();
                                this.umlText.append("\t \t \t </" + IParser.XML_TAG_PARAMETER + ">");
                            }
                        };
                        this.operations.get(string).get(string4).visitAllChildren((ISyntacticElement.SyntacticVisitor)var7_12);
                        this.umlText.nextLine();
                        this.umlText.append("\t \t </" + IParser.XML_TAG_OPERATION + ">");
                    }
                }
            } else if (this.attributes.containsKey(string)) {
                for (String string5 : this.attributes.get(string).keySet()) {
                    var7_12 = this.attributes.get(string).get(string5).getKeyword();
                    if (!Types.get((String)var7_12).toString().equals("unknown")) continue;
                    this.umlText.nextLine();
                    this.umlText.append("\t \t <" + IParser.XML_TAG_ATTRIBUTE + " " + IParser.XML_KEYWORD_ID + "=\"" + string5 + "\" name=\"" + this.attributes.get(string).get(string5).getName() + "\" visibility=\"public\" isUnique=\"false\"");
                    this.umlText.append(" type=\"" + this.getIdSpecies(var7_12) + "\" association=\"" + this.getIdAssociationFromAttribute(string, this.attributes.get(string).get(string5).getName()) + "\">");
                    this.umlText.nextLine();
                    this.umlText.append("\t \t </" + IParser.XML_TAG_ATTRIBUTE + ">");
                }
            }
            this.umlText.nextLine();
            this.umlText.append("\t </" + IParser.XML_TAG_CLASS + ">");
        }
        for (String string : this.associations.keySet()) {
            for (String string2 : this.associations.get(string).keySet()) {
                this.umlText.nextLine();
                ++this.id;
                this.umlText.append("\t <" + IParser.XML_TAG_ASSOCIATION + " xmi:type=\"" + IParser.XML_KEYWORD_ASSOCIATION + "\" xmi:id=\"" + string2 + "\" memberEnd=\"" + this.getIdAttributeFromAssociation(string, this.associations.get(string).get(string2).getName()) + " " + Integer.toString(this.id) + "\">");
                this.umlText.nextLine();
                this.umlText.append("\t \t <" + IParser.XML_TAG_END + " xmi:id=\"" + this.id + "\" visibility=\"public\" type=\"" + string + "\" association=\"" + string2 + "\" >");
                this.umlText.append("\t \t </" + IParser.XML_TAG_END + " >");
                this.umlText.nextLine();
                this.umlText.append("\t </" + IParser.XML_TAG_ASSOCIATION + ">");
            }
        }
    }

    public void save(String string) {
        try {
            FileWriter fileWriter = new FileWriter(string);
            fileWriter.write(this.umlText.toString());
            fileWriter.flush();
            fileWriter.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public void dispose() {
        this.model.dispose();
        this.model = null;
        this.importedModelsURIs = null;
        this.visitorForSpeciesChildren = null;
        this.visitorForSpeciesFacets = null;
        this.umlText = null;
        this.species = null;
        this.attributes = null;
        this.operations = null;
        this.associations = null;
        this.generalizations = null;
    }
}

