/*
 * Decompiled with CFR 0.152.
 */
package gama.experimental.apsf.spaces;

import gama.core.metamodel.agent.IAgent;
import gama.core.runtime.IScope;
import gama.experimental.apsf.exception.APSFException;
import gama.experimental.apsf.exception.UnBreakableParticle;
import gama.experimental.apsf.spaces.Agglomerate;
import gama.experimental.apsf.spaces.Apsf;
import gama.experimental.apsf.spaces.SoilLocation;
import java.util.ArrayList;
import java.util.List;

public abstract class Particle {
    public static final String SEPARATOR_PARTICLE = ":";
    public static boolean GRAVITY_PROCESS = false;
    public static final String DEFAULT_WHO_GENERATE = "soil";
    protected int level;
    protected double size;
    protected boolean porosityHaveBeenModified = true;
    private String whoGenerate = "soil";
    protected double organicMatterWeight;
    protected double solidWeight;
    protected double porosity = 0.0;
    protected int pI;
    protected int pJ;
    protected int pK;
    protected IAgent agent;
    protected List<IAgent> associatedProcesses = new ArrayList<IAgent>();
    private Agglomerate parent;
    protected SoilLocation location;

    public IAgent getAgent() {
        return this.agent;
    }

    public List<IAgent> getAssociatedProcesses() {
        return this.associatedProcesses;
    }

    public void setAgent(IAgent iAgent) {
        this.agent = iAgent;
    }

    public void addProcesses(IAgent iAgent) {
        this.associatedProcesses.add(iAgent);
    }

    public Particle() {
    }

    public void reduceMatters() {
        if (this.getParent() != null) {
            this.getParent().reduceMatters(this);
        }
        this.porosityHaveBeenModified = true;
    }

    public void reduceMatters(Particle particle) {
        if (this.getParent() != null) {
            this.getParent().reduceMatters(particle);
        }
        this.organicMatterWeight -= particle.getOrganicMatterWeight();
        this.solidWeight -= particle.getSolidWeight();
        this.porosityHaveBeenModified = true;
    }

    public void initMatters(double d, double d2) {
        this.organicMatterWeight = d;
        this.solidWeight = d2;
    }

    public void addMatters() {
        if (this.getParent() != null) {
            this.getParent().addMatters(this);
        }
        this.porosityHaveBeenModified = true;
    }

    public void addMatters(Particle particle) {
        if (this.getParent() != null) {
            this.getParent().addMatters(particle);
        }
        this.organicMatterWeight += particle.getOrganicMatterWeight();
        this.solidWeight += particle.getSolidWeight();
        this.porosityHaveBeenModified = true;
    }

    public Particle(Particle particle) {
        this();
        this.porosityHaveBeenModified = true;
        this.level = particle.level;
        this.size = particle.size;
        this.pI = particle.pI;
        this.pJ = particle.pJ;
        this.pK = particle.pK;
    }

    public void putParticle(IScope iScope, Particle particle) throws APSFException {
        throw new UnBreakableParticle();
    }

    public abstract Particle clone();

    public double getAbsoluteSize() {
        long l = SoilLocation.getMaxCoordinateAccordingToScale(this.location.getScale(), this.getWorld());
        double d = this.getWorld().getDimension() / (double)l;
        return d;
    }

    public void setMatrixCoordinate(int n, int n2, int n3) {
        this.pI = n;
        this.pJ = n2;
        this.pK = n3;
    }

    public SoilLocation getLocation() {
        return this.location;
    }

    public double getVolume() {
        return this.getAbsoluteSize() * this.getAbsoluteSize() * this.getAbsoluteSize();
    }

    public double getSurface() {
        return 6.0 * this.getAbsoluteSize() * this.getAbsoluteSize();
    }

    public static int[] getMatrixId(SoilLocation soilLocation, int n) {
        SoilLocation soilLocation2 = SoilLocation.changeScale(soilLocation, n);
        SoilLocation soilLocation3 = SoilLocation.changeScale(soilLocation, n - 1);
        SoilLocation soilLocation4 = SoilLocation.changeScale(soilLocation3, n);
        int[] nArray = new int[]{soilLocation2.getX() - soilLocation4.getX(), soilLocation2.getY() - soilLocation4.getY(), soilLocation2.getZ() - soilLocation4.getZ()};
        return nArray;
    }

    public static int[] getMatrixId(SoilLocation soilLocation, SoilLocation soilLocation2, int n) {
        int[] cfr_ignored_0 = new int[3];
        int[] cfr_ignored_1 = new int[3];
        int[] nArray = new int[3];
        SoilLocation soilLocation3 = SoilLocation.changeScale(soilLocation, n);
        SoilLocation soilLocation4 = SoilLocation.changeScale(soilLocation2, n);
        nArray[0] = soilLocation3.getX() - soilLocation4.getX();
        nArray[1] = soilLocation3.getY() - soilLocation4.getY();
        nArray[2] = soilLocation3.getZ() - soilLocation4.getZ();
        return nArray;
    }

    public String getKey() {
        return "(" + this.pI + "," + this.pJ + "," + this.pK + ")";
    }

    public static String getKey(int n, int n2, int n3) {
        return "(" + n + "," + n2 + "," + n3 + ")";
    }

    public void setAttribute(String string, Object object) {
    }

    public Object getAttribute(String string) {
        return null;
    }

    public Object parseString(String string) {
        String[] stringArray = string.split(SEPARATOR_PARTICLE);
        this.level = Integer.valueOf(stringArray[0]);
        this.size = Integer.valueOf(stringArray[1]).intValue();
        this.pI = Integer.valueOf(stringArray[2]);
        this.pJ = Integer.valueOf(stringArray[3]);
        this.pK = Integer.valueOf(stringArray[4]);
        this.whoGenerate = stringArray[5];
        return this;
    }

    public String toString() {
        return this.level + SEPARATOR_PARTICLE + this.size + SEPARATOR_PARTICLE + this.pI + SEPARATOR_PARTICLE + this.pJ + SEPARATOR_PARTICLE + this.pK + SEPARATOR_PARTICLE + this.whoGenerate;
    }

    public int getLevel() {
        return this.level;
    }

    public int getPI() {
        return this.pI;
    }

    public int getPK() {
        return this.pK;
    }

    public int getPJ() {
        return this.pJ;
    }

    public String getWhoGenerate() {
        return this.whoGenerate;
    }

    public void setWhoGenerate(String string) {
        this.whoGenerate = string;
    }

    public double getSize() {
        return this.size;
    }

    public Agglomerate getParent() {
        return this.parent;
    }

    public void setParent(Agglomerate agglomerate) {
        this.parent = agglomerate;
        this.organicMatterWeight = agglomerate.getOrganicMatterMass();
        this.solidWeight = agglomerate.getSolidMass();
        this.getLocation().setWorld(agglomerate.getLocation().getWorld());
    }

    public double getParticleSize(SoilLocation soilLocation) {
        int n = (int)soilLocation.getMaxCoordinateAccordingToScale(soilLocation.getWorld());
        return this.getWorld().getDimension() / (double)n;
    }

    public double getOrganicMatterWeight() {
        return this.organicMatterWeight;
    }

    public void setOrganicMatterWeight(double d) {
        this.organicMatterWeight = d;
    }

    public double getSolidWeight() {
        return this.solidWeight;
    }

    public void setSolidWeight(double d) {
        this.solidWeight = d;
    }

    public double getPorosity() {
        return this.porosity;
    }

    public void setLocation(SoilLocation soilLocation) {
        this.location = soilLocation;
    }

    public Apsf getWorld() {
        return this.getLocation().getWorld();
    }

    public abstract String getTemplateName();
}

