/*
 * Decompiled with CFR 0.152.
 */
package gama.experimental.apsf.spaces;

import gama.experimental.apsf.spaces.Apsf;
import javax.vecmath.Point3d;

public class SoilLocation {
    public static final String SEPARATOR_LOCATION = ":";
    private int x;
    private int y;
    private int z;
    private int scale;
    private Apsf world;

    public SoilLocation(int n, int n2, int n3, int n4, Apsf apsf) {
        this.x = n;
        this.y = n2;
        this.z = n3;
        this.scale = n4;
        this.world = apsf;
    }

    public SoilLocation(Apsf apsf) {
        this.world = apsf;
    }

    public Object parseString(String string) {
        String[] stringArray = string.split(SEPARATOR_LOCATION);
        this.x = Integer.valueOf(stringArray[0]);
        this.y = Integer.valueOf(stringArray[1]);
        this.z = Integer.valueOf(stringArray[2]);
        this.scale = Integer.valueOf(stringArray[3]);
        return this;
    }

    public Point3d getAbsoluteCoordinate() {
        double d = SoilLocation.getMaxCoordinateAccordingToScale(this.scale, this.world);
        double d2 = (double)this.x / d * this.world.getDimension();
        double d3 = (double)this.y / d * this.world.getDimension();
        double d4 = (double)this.z / d * this.world.getDimension();
        Point3d point3d = new Point3d(d2, d3, d4);
        return point3d;
    }

    public String toString() {
        return this.x + SEPARATOR_LOCATION + this.y + SEPARATOR_LOCATION + this.z + SEPARATOR_LOCATION + this.scale;
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public int getZ() {
        return this.z;
    }

    public int getScale() {
        return this.scale;
    }

    public static long fact(int n, int n2) {
        return (long)Math.pow(n2, n);
    }

    public boolean equals(Object object) {
        if (object instanceof SoilLocation) {
            SoilLocation soilLocation = (SoilLocation)object;
            if (soilLocation.scale == this.scale && soilLocation.x == this.x && soilLocation.y == this.y && soilLocation.z == this.z) {
                return true;
            }
        }
        return false;
    }

    public long getMaxCoordinateAccordingToScale(Apsf apsf) {
        return SoilLocation.getMaxCoordinateAccordingToScale(this.scale, apsf);
    }

    public static double getCellSize(int n, Apsf apsf) {
        return apsf.getDimension() / (double)SoilLocation.getMaxCoordinateAccordingToScale(n, apsf);
    }

    public static int nbCellPerLevel(Apsf apsf) {
        return apsf.getDivisionPerLevel() * apsf.getDivisionPerLevel() * apsf.getDivisionPerLevel();
    }

    public static long getMaxCoordinateAccordingToScale(int n, Apsf apsf) {
        return SoilLocation.fact(n, apsf.getDivisionPerLevel());
    }

    public static SoilLocation changeScale(SoilLocation soilLocation, int n) {
        if (soilLocation.getScale() == n) {
            return soilLocation;
        }
        Apsf cfr_ignored_0 = soilLocation.world;
        double d = SoilLocation.fact(n, Apsf.DIVISION_PER_LEVEL);
        Apsf cfr_ignored_1 = soilLocation.world;
        double d2 = SoilLocation.fact(soilLocation.getScale(), Apsf.DIVISION_PER_LEVEL);
        int n2 = (int)((double)soilLocation.getX() / d2 * d + 1.0E-5);
        int n3 = (int)((double)soilLocation.getY() / d2 * d + 1.0E-5);
        int n4 = (int)((double)soilLocation.getZ() / d2 * d + 1.0E-5);
        return new SoilLocation(n2, n3, n4, n, soilLocation.world);
    }

    public Apsf getWorld() {
        return this.world;
    }

    public void setWorld(Apsf apsf) {
        this.world = apsf;
    }
}

