/*
 * Decompiled with CFR 0.152.
 */
package gama.experimental.apsf.template;

import gama.experimental.apsf.spaces.Agglomerate;
import gama.experimental.apsf.spaces.OrganicMatter;
import gama.experimental.apsf.spaces.Particle;
import gama.experimental.apsf.spaces.SandParticle;
import gama.experimental.apsf.spaces.SoilLocation;
import gama.experimental.apsf.spaces.WhiteParticle;
import gama.experimental.apsf.template.Template;

public class DejectionFractal
extends Template {
    public static final String DEFAULT_NAME = "dejection template";

    @Override
    public void generateTemplate() {
        int n = (int)((double)(this.size * this.size * this.size) * (1.0 - this.solid - this.fractal - this.organic));
        int n2 = 0;
        while (n2 < this.size) {
            int n3 = 0;
            while (n3 < this.size) {
                int n4 = 0;
                while (n4 < this.size) {
                    Particle particle;
                    float f = 0.0f;
                    double d = Math.random() * (this.fractal + this.solid);
                    if (n > 0) {
                        particle = new WhiteParticle();
                        --n;
                    } else if (d < this.fractal) {
                        f = (float)(0.3 / (1000.0 * this.organic));
                        particle = new Agglomerate(this);
                    } else if (this.fractal <= d && d < this.fractal + this.solid) {
                        particle = new SandParticle();
                    } else {
                        f = (float)(0.7 / (1000.0 * this.organic));
                        particle = new OrganicMatter();
                    }
                    particle.setLocation(new SoilLocation(n2, n3, n4, 1, null));
                    this.setTemplate(particle, n2, n3, n4, f);
                    ++n4;
                }
                ++n3;
            }
            ++n2;
        }
    }

    public DejectionFractal(float f, float f2, float f3, int n) {
        super(DEFAULT_NAME, f, f2, f3, n);
        System.out.println("deection " + f + " " + f2 + " " + f3);
    }

    public DejectionFractal() {
        super(DEFAULT_NAME, 0.0f, 0.0f, 0.0f, 10);
        System.out.println("deection " + this.solid + " " + this.fractal + " " + this.organic);
    }

    public DejectionFractal(String string, float f, float f2, float f3, int n) {
        super(string, f, f2, f3, n);
        System.out.println(string + " " + f + " " + f2 + " " + f3);
    }
}

