/*
 * Decompiled with CFR 0.152.
 */
package gama.experimental.apsf.template;

import gama.core.metamodel.agent.IAgent;
import gama.core.runtime.IScope;
import gama.core.util.IList;
import gama.experimental.apsf.spaces.Agglomerate;
import gama.experimental.apsf.spaces.Apsf;
import gama.experimental.apsf.spaces.Particle;
import gama.experimental.apsf.spaces.SoilLocation;
import gama.experimental.apsf.spaces.WhiteParticle;
import gama.gaml.species.GamlSpecies;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.Vector;

public abstract class Template {
    public static String TEMPLATE_DTD = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><!DOCTYPE Canvas [\n<!ELEMENT Canvas (Cell*)>\n<!ATTLIST SpaceElement Name CDATA #REQUIRED>\n<!ATTLIST SpaceElement Class CDATA #REQUIRED>\n<!ATTLIST SpaceElement Solid CDATA #REQUIRED>\n<!ATTLIST SpaceElement Fractal CDATA #REQUIRED>\n<!ATTLIST SpaceElement Organic CDATA #REQUIRED>\n<!ATTLIST SpaceElement SideSize CDATA #REQUIRED>\n<!ELEMENT Cell (#PCDATA)>\n<!ATTLIST Cell Type CDATA #REQUIRED>\n<!ATTLIST Cell SubTemplatename CDATA #IMPLIED>]>";
    public static float DEFAULT_vMSolid = 2.6f;
    public static float DEFAULT_vMOrganicMatter = 0.8f;
    private static float EPSILON = 25.0f;
    public static final int DEFAULT_SIZE = 20;
    private String templateName;
    private final Map<String, Particle> samplers = new HashMap<String, Particle>();
    private final Map<String, Map<Integer, GamlSpecies>> processes = new HashMap<String, Map<Integer, GamlSpecies>>();
    private Particle[][][] template;
    protected double solid;
    protected double fractal;
    protected double organic;
    private double empty;
    protected float solidMatterVolumicMass = DEFAULT_vMSolid;
    protected float organicMatterVolumicMass = DEFAULT_vMOrganicMatter;
    protected double organicMatterTotalVolumicMass = -1.0;
    protected double solidMatterTotalVolumicMass = -1.0;
    protected Hashtable<String, Template> subTemplate = new Hashtable();
    protected int size;

    public abstract void generateTemplate();

    public Particle getSamplerWithCharacteristics(String string) {
        Particle particle = this.samplers.get(string);
        if (particle == null) {
            ArrayList<Particle> arrayList = this.getCellsWithCharacteristics(string);
            int n = (int)(Math.random() * 1000.0) % arrayList.size();
            particle = arrayList.get(n);
            this.samplers.put(string, particle);
        }
        return particle;
    }

    public void setSamplerWithCharacteristics(String string, Particle particle) {
        this.samplers.put(string, particle);
    }

    public void addProcess(GamlSpecies gamlSpecies, String string, int n) {
        Integer n2;
        Map<Integer, GamlSpecies> map = this.processes.get(string);
        if (map == null) {
            map = new HashMap<Integer, GamlSpecies>();
            this.processes.put(string, map);
        }
        if (map.containsKey(n2 = new Integer(n))) {
            map.remove(n2);
        }
        map.put(n2, gamlSpecies);
    }

    public IAgent createProcessesForParticle(IScope iScope, Particle particle) {
        Map<Integer, GamlSpecies> map = this.processes.get(particle.getTemplateName());
        GamlSpecies gamlSpecies = null;
        if (map != null) {
            gamlSpecies = map.get(new Integer(particle.getLocation().getScale()));
        }
        if (gamlSpecies == null) {
            gamlSpecies = particle.getWorld().getDefaultSpecies();
        }
        if (gamlSpecies == null) {
            return null;
        }
        HashMap<String, Particle> hashMap = new HashMap<String, Particle>();
        hashMap.put("int_followed_particle", particle);
        ArrayList<HashMap<String, Particle>> arrayList = new ArrayList<HashMap<String, Particle>>();
        arrayList.add(hashMap);
        IList iList = gamlSpecies.getPopulation(iScope).createAgents(iScope, 1, arrayList, false, true);
        IAgent iAgent = (IAgent)iList.get(0);
        particle.setAgent(iAgent);
        if (map != null) {
            GamlSpecies gamlSpecies2;
            gamlSpecies = gamlSpecies2 = map.get(new Integer(particle.getLocation().getScale()));
            System.out.println("modification " + gamlSpecies.getName());
            hashMap = new HashMap();
            hashMap.put("int_followed_particle", particle);
            arrayList = new ArrayList();
            arrayList.add(hashMap);
            iList = gamlSpecies.getPopulation(iScope).createAgents(iScope, 1, arrayList, false, true);
            particle.addProcesses((IAgent)iList.get(0));
        }
        return iAgent;
    }

    public boolean isParentOf(String string) {
        Enumeration<String> enumeration = this.subTemplate.keys();
        while (enumeration.hasMoreElements()) {
            if (!enumeration.nextElement().equals(string)) continue;
            return true;
        }
        return false;
    }

    public ArrayList<Particle> getCellsWithCharacteristics(String string) {
        ArrayList<Particle> arrayList = new ArrayList<Particle>();
        Particle[][][] particleArray = this.template;
        int n = this.template.length;
        int n2 = 0;
        while (n2 < n) {
            Particle[][] particleArray2;
            Particle[][] particleArray3 = particleArray2 = particleArray[n2];
            int n3 = particleArray2.length;
            int n4 = 0;
            while (n4 < n3) {
                Particle[] particleArray4;
                Particle[] particleArray5 = particleArray4 = particleArray3[n4];
                int n5 = particleArray4.length;
                int n6 = 0;
                while (n6 < n5) {
                    Particle particle = particleArray5[n6];
                    if (particle.getTemplateName().equals(string)) {
                        arrayList.add(particle);
                    }
                    ++n6;
                }
                ++n4;
            }
            ++n2;
        }
        return arrayList;
    }

    public int getNumberOfCell() {
        return this.template == null ? 0 : this.template.length * this.template[0].length * this.template[0][0].length;
    }

    public double getOrganicMatterTotalVolumicMass(int n, Apsf apsf) {
        this.organicMatterTotalVolumicMass = this.getOrganicMatterTotalVolumicMass(0, 1.0, apsf);
        return this.organicMatterTotalVolumicMass / Math.pow(apsf.getDivisionPerLevel(), n);
    }

    public double getRateOfTemplateWithName(String string) {
        double d = (double)this.getNbCellsOfTemplateWithName(string) / (double)this.getNumberOfCell();
        return d;
    }

    public int getNbCellsOfTemplateWithName(String string) {
        int n = 0;
        Particle[][][] particleArray = this.template;
        int n2 = this.template.length;
        int n3 = 0;
        while (n3 < n2) {
            Particle[][] particleArray2;
            Particle[][] particleArray3 = particleArray2 = particleArray[n3];
            int n4 = particleArray2.length;
            int n5 = 0;
            while (n5 < n4) {
                Particle[] particleArray4;
                Particle[] particleArray5 = particleArray4 = particleArray3[n5];
                int n6 = particleArray4.length;
                int n7 = 0;
                while (n7 < n6) {
                    Particle particle = particleArray5[n7];
                    if (particle.getTemplateName().equals(string)) {
                        ++n;
                    }
                    ++n7;
                }
                ++n5;
            }
            ++n3;
        }
        return n;
    }

    public double getEmptyParticleRate(Apsf apsf) {
        double d = 0.0;
        if (this.empty != -1.0) {
            return this.empty;
        }
        Particle[][][] particleArray = this.template;
        int n = this.template.length;
        int n2 = 0;
        while (n2 < n) {
            Particle[][] particleArray2;
            Particle[][] particleArray3 = particleArray2 = particleArray[n2];
            int n3 = particleArray2.length;
            int n4 = 0;
            while (n4 < n3) {
                Particle[] particleArray4;
                Particle[] particleArray5 = particleArray4 = particleArray3[n4];
                int n5 = particleArray4.length;
                int n6 = 0;
                while (n6 < n5) {
                    Particle particle = particleArray5[n6];
                    if (particle instanceof WhiteParticle) {
                        d += 1.0;
                    }
                    ++n6;
                }
                ++n4;
            }
            ++n2;
        }
        this.empty = d / (double)apsf.getDivisionPerLevel();
        return this.empty;
    }

    public double getOrganicMatterTotalVolumicMass(int n, double d, Apsf apsf) {
        if ((float)n > EPSILON) {
            return 0.0;
        }
        double d2 = 0.0;
        Template template = this.getSubTemplate();
        double d3 = Math.pow(apsf.getDimension(), 3.0);
        double d4 = (double)this.organicMatterVolumicMass * d * this.organic * d3;
        d2 += template.getOrganicMatterTotalVolumicMass(n + 1, d * this.fractal, apsf);
        return d2 += d4;
    }

    public double getPorosity(Apsf apsf) {
        return this.getPorosity(0, 1.0, apsf);
    }

    public double getPorosity(int n, double d, Apsf apsf) {
        if ((float)n > EPSILON) {
            return this.getEmptyParticleRate(apsf);
        }
        double d2 = 0.0;
        Template template = this.getSubTemplate();
        double d3 = d * this.getEmptyParticleRate(apsf);
        double d4 = template.getPorosity(n + 1, d * this.fractal, apsf);
        d2 += d4;
        return d2 += d3;
    }

    public Template getSubTemplate() {
        return this.subTemplate.elements().nextElement();
    }

    public Template getSubTemplateWithName(String string) {
        return this.subTemplate.get(string);
    }

    public Enumeration<Template> getSubTemplates() {
        return this.subTemplate.elements();
    }

    public ArrayList<Template> getAllSubTemplate() {
        return this.getAllSubTemplate(this);
    }

    private ArrayList<Template> getAllSubTemplate(Template template) {
        ArrayList<Template> arrayList = new ArrayList<Template>();
        Collection<Template> collection = template.subTemplate.values();
        arrayList.add(template);
        if (collection.size() == 1 && collection.contains(template)) {
            return arrayList;
        }
        for (Template template2 : this.subTemplate.values()) {
            ArrayList<Template> arrayList2 = template2.getAllSubTemplate(template2);
            for (Template template3 : arrayList2) {
                if (arrayList.contains(template3)) continue;
                arrayList.add(template3);
            }
        }
        return arrayList;
    }

    public Vector<String> getNeededSubTemplates() {
        Vector<String> vector = new Vector<String>();
        if (this.template == null) {
            return vector;
        }
        Particle[][][] particleArray = this.template;
        int n = this.template.length;
        int n2 = 0;
        while (n2 < n) {
            Particle[][] particleArray2;
            Particle[][] particleArray3 = particleArray2 = particleArray[n2];
            int n3 = particleArray2.length;
            int n4 = 0;
            while (n4 < n3) {
                Particle[] particleArray4;
                Particle[] particleArray5 = particleArray4 = particleArray3[n4];
                int n5 = particleArray4.length;
                int n6 = 0;
                while (n6 < n5) {
                    Particle particle = particleArray5[n6];
                    if (particle instanceof Agglomerate && !vector.contains(((Agglomerate)particle).getTemplateName()) && !this.subTemplate.containsKey(((Agglomerate)particle).getTemplateName())) {
                        vector.add(((Agglomerate)particle).getTemplateName());
                    }
                    ++n6;
                }
                ++n4;
            }
            ++n2;
        }
        return vector;
    }

    public double getSolidMatterTotalVolumicMass(int n, Apsf apsf) {
        this.solidMatterTotalVolumicMass = this.getSolidMatterTotalVolumicMass(0, 1, 1.0, apsf);
        return this.solidMatterTotalVolumicMass / Math.pow(apsf.getDivisionPerLevel(), n);
    }

    public double getSolidMatterTotalVolumicMass(int n, int n2, double d, Apsf apsf) {
        if ((float)n > EPSILON) {
            return 0.0;
        }
        double d2 = 0.0;
        Template template = this.getSubTemplate();
        return d2 += template.getSolidMatterTotalVolumicMass(n + 1, n2 + 1, d * this.fractal, apsf);
    }

    public void setTemplate(Particle particle, int n, int n2, int n3, double d) {
        this.organicMatterTotalVolumicMass = -1.0;
        this.template[n][n2][n3] = particle;
        particle.setMatrixCoordinate(n, n2, n3);
    }

    public Collection<Particle> getParticles() {
        Vector<Particle> vector = new Vector<Particle>();
        Particle[][][] particleArray = this.template;
        int n = this.template.length;
        int n2 = 0;
        while (n2 < n) {
            Particle[][] particleArray2;
            Particle[][] particleArray3 = particleArray2 = particleArray[n2];
            int n3 = particleArray2.length;
            int n4 = 0;
            while (n4 < n3) {
                Particle[] particleArray4;
                Particle[] particleArray5 = particleArray4 = particleArray3[n4];
                int n5 = particleArray4.length;
                int n6 = 0;
                while (n6 < n5) {
                    Particle particle = particleArray5[n6];
                    vector.add(particle);
                    ++n6;
                }
                ++n4;
            }
            ++n2;
        }
        return vector;
    }

    public Particle getParticle(int n, int n2, int n3) {
        return this.template[n][n2][n3];
    }

    public Class<? extends Particle> getParticleClass(int n, int n2, int n3) {
        return this.template[n][n2][n3].getClass();
    }

    public Particle getNewParticleInstance(IScope iScope, SoilLocation soilLocation) {
        int[] nArray = Particle.getMatrixId(soilLocation, soilLocation.getScale());
        Particle particle = this.getNewParticleInstance(nArray[0], nArray[1], nArray[2]);
        particle.setLocation(soilLocation);
        IAgent iAgent = this.createProcessesForParticle(iScope, particle);
        particle.setAgent(iAgent);
        return particle;
    }

    public Particle getNewParticleInstance(int n, int n2, int n3) {
        Particle particle = this.template[n][n2][n3].clone();
        return particle;
    }

    public void initialise() {
        int n = 0;
        while (n < this.template.length) {
            int n2 = 0;
            while (n2 < this.template[n].length) {
                int n3 = 0;
                while (n3 < this.template[n][n2].length) {
                    this.template[n][n2][n3] = null;
                    ++n3;
                }
                ++n2;
            }
            ++n;
        }
    }

    public boolean isInAccordanceWithTemplate(Particle particle, int n, int n2, int n3) {
        return particle.getClass().isInstance(this.template[n][n2][n3]);
    }

    public void addSubTemplate(Template template) {
        Template template2 = this.subTemplate.get(template.getTemplateName());
        if (template2 == null) {
            this.subTemplate.put(template.getTemplateName(), template);
        }
    }

    public void initAgglomerate(Hashtable<String, Template> hashtable) {
        Particle[][][] particleArray = this.template;
        int n = this.template.length;
        int n2 = 0;
        while (n2 < n) {
            Particle[][] particleArray2;
            Particle[][] particleArray3 = particleArray2 = particleArray[n2];
            int n3 = particleArray2.length;
            int n4 = 0;
            while (n4 < n3) {
                Particle[] particleArray4;
                Particle[] particleArray5 = particleArray4 = particleArray3[n4];
                int n5 = particleArray4.length;
                int n6 = 0;
                while (n6 < n5) {
                    Particle particle = particleArray5[n6];
                    if (particle instanceof Agglomerate) {
                        ((Agglomerate)particle).setTemplate(hashtable.get(((Agglomerate)particle).getTemplateName()));
                    }
                    ++n6;
                }
                ++n4;
            }
            ++n2;
        }
    }

    private void addSubTemplate(Template[] templateArray) {
        Template[] templateArray2 = templateArray;
        int n = templateArray.length;
        int n2 = 0;
        while (n2 < n) {
            Template template = templateArray2[n2];
            this.addSubTemplate(template);
            ++n2;
        }
    }

    private void initialize(String string, float f, float f2, float f3, int n) {
        this.size = n;
        this.solid = f;
        this.fractal = f2;
        this.organic = f3;
        this.template = new Particle[n][n][n];
        this.subTemplate = new Hashtable();
        this.templateName = string;
        this.empty = -1.0;
    }

    protected Template(String string, float f, float f2, float f3, int n) {
        this.initialize(string, f, f2, f3, n);
        this.addSubTemplate(this);
        this.generateTemplate();
    }

    protected Template(String string, float f, float f2, float f3, int n, Template[] templateArray) {
        this.initialize(string, f, f2, f3, n);
        this.addSubTemplate(templateArray);
        this.generateTemplate();
    }

    protected Template(String string, float f, float f2, float f3, int n, Template template) {
        template = template != null ? template : this;
        this.initialize(string, f, f2, f3, n);
        this.addSubTemplate(template);
        this.generateTemplate();
    }

    public int getSize() {
        return this.size;
    }

    public void setSize(int n) {
        this.size = n;
    }

    public double getFractal() {
        return this.fractal;
    }

    public void setFractal(double d) {
        this.fractal = d;
    }

    public double getOrganic() {
        return this.organic;
    }

    public void setOrganic(double d) {
        this.organic = d;
    }

    public double getSolid() {
        return this.solid;
    }

    public void setSolid(double d) {
        this.solid = d;
    }

    public float getOrganicMatterVolumicMass() {
        return this.organicMatterVolumicMass;
    }

    public void setOrganicMatterVolumicMass(float f) {
        this.organicMatterVolumicMass = f;
    }

    public float getSolidVolumicMass() {
        return this.solidMatterVolumicMass;
    }

    public void setSolidVolumicMass(float f) {
        this.solidMatterVolumicMass = f;
    }

    public String getTemplateName() {
        return this.templateName;
    }

    public void setTemplateName(String string) {
        this.templateName = string;
    }

    public String toString() {
        Object object = "";
        object = (String)object + "<Canvas Class='" + this.getClass().getName() + "' Name='" + this.getTemplateName() + "' Solid='" + this.solid + "' Fractal='" + this.fractal + "' Organic='" + this.organic + "' SideSize='" + this.size + "'>";
        int n = 0;
        while (n < this.template.length) {
            int n2 = 0;
            while (n2 < this.template[n].length) {
                int n3 = 0;
                while (n3 < this.template[n][n2].length) {
                    if (this.template[n][n2][n3] instanceof Agglomerate) {
                        Agglomerate agglomerate = (Agglomerate)this.template[n][n2][n3];
                        object = (String)object + "<Cell Type='Fractal' x='" + n + "' y='" + n2 + "' z='" + n3 + "' SubTemplateName='" + agglomerate.getTemplateName() + "' ></Cell>";
                    } else {
                        object = (String)object + "<Cell Type='" + this.template[n][n2][n3].getClass().getName() + "' x='" + n + "' y='" + n2 + "' z='" + n3 + "' ></Cell>";
                    }
                    ++n3;
                }
                ++n2;
            }
            ++n;
        }
        object = (String)object + "</Canvas>";
        return object;
    }
}

