/*
 * Decompiled with CFR 0.152.
 */
package gama.experimental.camisole;

import umontreal.ssj.randvar.NormalGen;
import umontreal.ssj.randvarmulti.DirichletGen;
import umontreal.ssj.rng.GenF2w32;
import umontreal.ssj.rng.RandomStream;

public abstract class RandomGenerator {
    private static int[] SEED_APSF = null;
    private static GenF2w32 RANDOM_STREAM_GENERATOR = null;
    static NormalGen normalGen = null;

    public static void setSeed(int[] nArray) {
        SEED_APSF = nArray;
    }

    public static int[] generateSeed() {
        if (SEED_APSF != null) {
            return SEED_APSF;
        }
        int[] nArray = new int[25];
        int n = 0;
        while (n < nArray.length) {
            nArray[n] = (int)(Math.random() * 1000.0) + 1;
            ++n;
        }
        SEED_APSF = nArray;
        return SEED_APSF;
    }

    private static void generateRandomStream() {
        if (SEED_APSF == null) {
            RandomGenerator.generateSeed();
        }
        RANDOM_STREAM_GENERATOR = new GenF2w32();
        RANDOM_STREAM_GENERATOR.setSeed(SEED_APSF);
    }

    public static DirichletGen getDirichletGen() {
        if (RANDOM_STREAM_GENERATOR == null) {
            RandomGenerator.generateRandomStream();
        }
        double[] dArray = new double[]{1.0, 1.0, 1.0, 1.0};
        DirichletGen dirichletGen = new DirichletGen((RandomStream)RANDOM_STREAM_GENERATOR, dArray);
        return dirichletGen;
    }

    public static NormalGen getNormalGen(double d, double d2) {
        if (RANDOM_STREAM_GENERATOR == null) {
            RandomGenerator.generateRandomStream();
        }
        return new NormalGen((RandomStream)RANDOM_STREAM_GENERATOR, 10.0, 5.0);
    }
}

