/*
 * Decompiled with CFR 0.152.
 */
package gama.experimental.camisole.skills;

import gama.annotations.precompiler.GamlAnnotations;
import gama.core.metamodel.agent.IAgent;
import gama.core.metamodel.shape.GamaPoint;
import gama.core.runtime.IScope;
import gama.core.util.GamaListFactory;
import gama.core.util.IList;
import gama.experimental.apsf.spaces.Particle;
import gama.experimental.apsf.spaces.SoilLocation;
import gama.experimental.camisole.skills.ApsfSkill;
import gama.gaml.skills.Skill;
import gama.gaml.types.IType;
import gama.gaml.types.Types;
import javax.vecmath.Point3d;

@GamlAnnotations.vars(value={@GamlAnnotations.variable(name="int_followed_particle", type=0, doc={@GamlAnnotations.doc(value="followed particle in the soil")}), @GamlAnnotations.variable(name="location", type=7, doc={@GamlAnnotations.doc(value="location")}), @GamlAnnotations.variable(name="my_neighbors", type=5, doc={@GamlAnnotations.doc(value="neighbors of cell")}), @GamlAnnotations.variable(name="my_neighbors_local", type=5, doc={@GamlAnnotations.doc(value="local neighbors of cell")}), @GamlAnnotations.variable(name="size", type=2, doc={@GamlAnnotations.doc(value="location")}), @GamlAnnotations.variable(name="i", type=1, doc={@GamlAnnotations.doc(value="i location of particle in the soil")}), @GamlAnnotations.variable(name="j", type=1, doc={@GamlAnnotations.doc(value="j location of particle in the soil")}), @GamlAnnotations.variable(name="k", type=1, doc={@GamlAnnotations.doc(value="k location of particle in the soil")}), @GamlAnnotations.variable(name="scale", type=1, doc={@GamlAnnotations.doc(value="scale location of particle in the soil")}), @GamlAnnotations.variable(name="organic_matter", type=2, doc={@GamlAnnotations.doc(value="quantity of organic matter in the particle")}), @GamlAnnotations.variable(name="my_type", type=4, doc={@GamlAnnotations.doc(value="scale location of particle in the soil")})})
@GamlAnnotations.skill(name="apsf_particle", concept={"skill"})
public class ApsfParticleSkill
extends Skill {
    private boolean isBuiltinAttribute(IAgent iAgent, String string) {
        String[] stringArray;
        String[] stringArray2 = stringArray = new String[]{"int_followed_particle", "location", "my_neighbors", "my_neighbors_local", "size", "i", "j", "k", "scale", "organic_matter", "my_type"};
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String string2 = stringArray2[n2];
            if (string2.equals(string)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private Particle getParticle(IAgent iAgent) {
        Particle particle = (Particle)iAgent.getAttribute("int_followed_particle");
        return particle;
    }

    @GamlAnnotations.getter(value="i")
    public int getI(IAgent iAgent) {
        Particle particle = this.getParticle(iAgent);
        if (particle == null) {
            return -1;
        }
        return particle.getPI();
    }

    @GamlAnnotations.getter(value="location", initializer=true)
    public GamaPoint getParticuleLocation(IAgent iAgent) {
        Particle particle = this.getParticle(iAgent);
        if (particle == null) {
            return null;
        }
        Point3d point3d = particle.getLocation().getAbsoluteCoordinate();
        IAgent iAgent2 = particle.getWorld().getUnderworldAgent();
        GamaPoint gamaPoint = iAgent2.getLocation();
        double d = particle.getWorld().getDimension() / 200.0;
        double d2 = particle.getAbsoluteSize() / 2.0;
        return new GamaPoint((point3d.x + d2) / 100.0 - d + gamaPoint.getX(), (point3d.y + d2) / 100.0 - d + gamaPoint.getY(), (point3d.z + d2) / 100.0 - d + gamaPoint.getZ());
    }

    @GamlAnnotations.getter(value="size", initializer=true)
    public float getParticuleSize(IAgent iAgent) {
        Particle particle = this.getParticle(iAgent);
        if (particle == null) {
            return 0.0f;
        }
        return (float)particle.getAbsoluteSize() / 100.0f;
    }

    @GamlAnnotations.getter(value="j")
    public int getJ(IAgent iAgent) {
        Particle particle = this.getParticle(iAgent);
        if (particle == null) {
            return -1;
        }
        return particle.getPJ();
    }

    @GamlAnnotations.getter(value="k")
    public int getK(IAgent iAgent) {
        Particle particle = this.getParticle(iAgent);
        if (particle == null) {
            return -1;
        }
        return particle.getPK();
    }

    @GamlAnnotations.getter(value="scale")
    public int getScale(IAgent iAgent) {
        Particle particle = this.getParticle(iAgent);
        if (particle == null) {
            return -1;
        }
        return particle.getLevel();
    }

    @GamlAnnotations.getter(value="organic_matter")
    public float getOrganicMatter(IScope iScope) {
        Particle particle = this.getParticle(iScope.getAgent());
        if (particle == null) {
            return 0.0f;
        }
        return (float)particle.getOrganicMatterWeight();
    }

    @GamlAnnotations.setter(value="organic_matter")
    public void setOrganicMatter(IAgent iAgent, double d) {
        Particle particle = this.getParticle(iAgent.getAgent());
        if (particle == null) {
            return;
        }
        particle.setOrganicMatterWeight(d);
    }

    @GamlAnnotations.getter(value="my_type")
    public String getParticleType(IScope iScope) {
        Particle particle = this.getParticle(iScope.getAgent());
        if (particle == null) {
            return null;
        }
        return ApsfSkill.apsfToUser(particle);
    }

    public IList<IAgent> getNeighbors(IScope iScope, boolean bl) {
        IList iList = GamaListFactory.create((IScope)iScope, (IType)Types.AGENT, (Object[])new IAgent[0]);
        Particle particle = this.getParticle(iScope.getAgent());
        SoilLocation soilLocation = particle.getLocation();
        int n = (int)SoilLocation.getMaxCoordinateAccordingToScale(soilLocation.getScale(), soilLocation.getWorld());
        int n2 = soilLocation.getWorld().getDivisionPerLevel();
        int n3 = -1;
        while (n3 <= 1) {
            int n4 = -1;
            while (n4 <= 1) {
                int n5 = -1;
                while (n5 <= 1) {
                    int n6 = 0;
                    int n7 = 0;
                    int n8 = 0;
                    if (bl) {
                        n6 = this.torusCoordinate(soilLocation.getX() + n3, n, n2);
                        n7 = this.torusCoordinate(soilLocation.getY() + n4, n, n2);
                        n8 = this.torusCoordinate(soilLocation.getZ() + n5, n, n2);
                    } else {
                        n6 = this.torusCoordinate(soilLocation.getX() + n3, n);
                        n7 = this.torusCoordinate(soilLocation.getY() + n4, n);
                        n8 = this.torusCoordinate(soilLocation.getZ() + n5, n);
                    }
                    SoilLocation soilLocation2 = new SoilLocation(n6, n7, n8, soilLocation.getScale(), particle.getWorld());
                    Particle particle2 = particle.getWorld().getParticleAtLocation(iScope, soilLocation2);
                    iList.add((Object)particle2.getAgent());
                    ++n5;
                }
                ++n4;
            }
            ++n3;
        }
        return iList;
    }

    @GamlAnnotations.getter(value="my_neighbors")
    public IList<IAgent> getNeighborsGlobal(IScope iScope) {
        return this.getNeighbors(iScope, false);
    }

    @GamlAnnotations.getter(value="my_neighbors_local")
    public IList<IAgent> getNeighborsLocal(IScope iScope) {
        return this.getNeighbors(iScope, true);
    }

    private int torusCoordinate(int n, int n2) {
        if (n < 0) {
            return n2 + n;
        }
        if (n >= n2) {
            return n - n2;
        }
        return n;
    }

    private int torusCoordinate(int n, int n2, int n3) {
        int n4 = this.torusCoordinate(n, n2);
        return n4 % n3;
    }

    GamaPoint getCellLocation(IScope iScope) {
        Particle particle = this.getParticle(iScope.getAgent());
        SoilLocation soilLocation = particle.getLocation();
        Point3d point3d = soilLocation.getAbsoluteCoordinate();
        GamaPoint gamaPoint = new GamaPoint(point3d.x, point3d.y, point3d.z);
        return gamaPoint;
    }
}

