/*
 * Decompiled with CFR 0.152.
 */
package gama.experimental.cim.files;

import gama.annotations.precompiler.GamlAnnotations;
import gama.core.common.geometry.Envelope3D;
import gama.core.metamodel.shape.GamaPoint;
import gama.core.metamodel.shape.IShape;
import gama.core.runtime.IScope;
import gama.core.runtime.exceptions.GamaRuntimeException;
import gama.core.util.GamaListFactory;
import gama.core.util.IAddressableContainer;
import gama.core.util.IContainer;
import gama.core.util.IList;
import gama.core.util.file.GamaGeometryFile;
import gama.gaml.operators.spatial.SpatialCreation;
import gama.gaml.types.GamaGeometryType;
import gama.gaml.types.IType;
import gama.gaml.types.Types;
import java.util.List;
import java.util.TreeMap;
import org.citygml4j.cityjson.CityJSONContext;
import org.citygml4j.cityjson.CityJSONContextException;
import org.citygml4j.cityjson.reader.CityJSONInputFactory;
import org.citygml4j.cityjson.reader.CityJSONReadException;
import org.citygml4j.core.model.building.Building;
import org.citygml4j.core.model.core.AbstractCityObject;
import org.citygml4j.core.model.core.AbstractCityObjectProperty;
import org.citygml4j.core.model.core.AbstractSpace;
import org.citygml4j.core.model.core.AbstractSpaceBoundary;
import org.citygml4j.core.model.core.AbstractSpaceBoundaryProperty;
import org.citygml4j.core.model.core.CityModel;
import org.citygml4j.core.model.generics.GenericOccupiedSpace;
import org.citygml4j.core.visitor.ObjectWalker;
import org.xmlobjects.gml.model.geometry.AbstractGeometry;
import org.xmlobjects.gml.model.geometry.DirectPositionList;
import org.xmlobjects.gml.model.geometry.GeometryProperty;
import org.xmlobjects.gml.model.geometry.primitives.LinearRing;
import org.xmlobjects.gml.visitor.ObjectVisitor;

@GamlAnnotations.file(name="cityjson", extensions={"json"}, buffer_type=5, buffer_content=13, buffer_index=1, concept={"gis", "file"}, doc={@GamlAnnotations.doc(value="Represents geospatial files written using the GeoJSON format. The internal representation is a list of geometries")})
public class GamaCityJsonFile
extends GamaGeometryFile {
    Envelope3D envelope;

    public GamaCityJsonFile(IScope iScope, String string) throws GamaRuntimeException {
        super(iScope, string);
    }

    protected IShape buildGeometry(IScope iScope) {
        return GamaGeometryType.geometriesToGeometry((IScope)iScope, (IContainer)this.getBuffer());
    }

    protected void fillBuffer(IScope iScope) throws GamaRuntimeException {
        if (this.getBuffer() != null) {
            return;
        }
        this.setBuffer((IAddressableContainer)GamaListFactory.create((IType)Types.GEOMETRY));
        this.readShapes(iScope);
    }

    public Envelope3D computeEnvelope(IScope iScope) {
        this.fillBuffer(iScope);
        return this.envelope;
    }

    public IShape buildShape(IScope iScope, AbstractGeometry abstractGeometry) {
        if (abstractGeometry instanceof LinearRing) {
            LinearRing linearRing = (LinearRing)abstractGeometry;
            DirectPositionList directPositionList = linearRing.getControlPoints().getPosList();
            IList iList = GamaListFactory.create();
            List list = directPositionList.getValue();
            int n = 0;
            while (n < list.size() - 2) {
                iList.add((Object)new GamaPoint(((Double)list.get(n)).doubleValue(), ((Double)list.get(n + 1)).doubleValue(), ((Double)list.get(n + 2)).doubleValue()));
                n += 3;
            }
            return SpatialCreation.polygon((IScope)iScope, (IContainer)iList);
        }
        return null;
    }

    public IShape BuildGeometriesGeom(final IScope iScope, List<GeometryProperty<?>> list) {
        if (list == null || list.isEmpty()) {
            return null;
        }
        final IList iList = GamaListFactory.create();
        list.forEach(geometryProperty -> geometryProperty.getObject().accept((ObjectVisitor)new ObjectWalker(){

            public void visit(AbstractGeometry abstractGeometry) {
                System.out.println("- child " + abstractGeometry.getClass().getSimpleName());
                IShape iShape = GamaCityJsonFile.this.buildShape(iScope, abstractGeometry);
                if (iShape != null) {
                    iList.add((Object)iShape);
                }
                super.visit(abstractGeometry);
            }
        }));
        return SpatialCreation.geometryCollection((IScope)iScope, (IContainer)iList);
    }

    public IShape BuildGeometriesSpace(final IScope iScope, List<AbstractSpaceBoundaryProperty> list) {
        if (list == null || list.isEmpty()) {
            return null;
        }
        final IList iList = GamaListFactory.create();
        list.forEach(abstractSpaceBoundaryProperty -> ((AbstractSpaceBoundary)abstractSpaceBoundaryProperty.getObject()).accept((org.citygml4j.core.visitor.ObjectVisitor)new ObjectWalker(){

            public void visit(AbstractGeometry abstractGeometry) {
                System.out.println("- child " + abstractGeometry.getClass().getSimpleName());
                IShape iShape = GamaCityJsonFile.this.buildShape(iScope, abstractGeometry);
                if (iShape != null) {
                    iList.add((Object)iShape);
                }
                super.visit(abstractGeometry);
            }
        }));
        return SpatialCreation.geometryCollection((IScope)iScope, (IContainer)iList);
    }

    protected void readShapes(IScope iScope) {
        try {
            Object object;
            Object object2;
            GamaPoint gamaPoint;
            Throwable throwable;
            CityJSONContext cityJSONContext = CityJSONContext.newInstance();
            CityJSONInputFactory cityJSONInputFactory = cityJSONContext.createCityJSONInputFactory();
            CityModel cityModel = null;
            try {
                throwable = null;
                gamaPoint = null;
                try {
                    object2 = cityJSONInputFactory.createCityJSONReader(this.getFile(iScope).toPath());
                    try {
                        cityModel = (CityModel)object2.next();
                    }
                    finally {
                        if (object2 != null) {
                            object2.close();
                        }
                    }
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (CityJSONReadException cityJSONReadException) {
                cityJSONReadException.printStackTrace();
            }
            cityModel.getFeatureMembers().forEach(abstractFeatureProperty -> System.out.println(abstractFeatureProperty));
            throwable = cityModel.getBoundedBy() != null ? cityModel.getBoundedBy().getEnvelope() : null;
            gamaPoint = null;
            if (throwable != null) {
                object2 = throwable.getLowerCorner().getValue();
                object = throwable.getUpperCorner().getValue();
                gamaPoint = new GamaPoint(((Double)object2.get(0)).doubleValue(), ((Double)object2.get(1)).doubleValue(), ((Double)object2.get(2)).doubleValue());
                this.envelope = Envelope3D.of((double)((Double)object2.get(0)), (double)((Double)object.get(0)), (double)((Double)object2.get(1)), (double)((Double)object.get(1)), (double)((Double)object2.get(2)), (double)((Double)object.get(2)));
            }
            object2 = new TreeMap();
            object = GamaListFactory.create();
            for (AbstractCityObjectProperty abstractCityObjectProperty : cityModel.getCityObjectMembers()) {
                List list;
                Object object3;
                AbstractCityObject abstractCityObject = (AbstractCityObject)abstractCityObjectProperty.getObject();
                object2.merge(abstractCityObject.getClass().getSimpleName(), 1, Integer::sum);
                object2.forEach((string, n) -> System.out.println(string + ": " + String.valueOf(n) + " instance(s)"));
                IShape iShape = null;
                Object object4 = abstractCityObject.getGeometryInfo().getLods().iterator();
                while (object4.hasNext()) {
                    object3 = (Integer)object4.next();
                    list = abstractCityObject.getGeometryInfo().getGeometries(((Integer)object3).intValue());
                    IShape iShape2 = this.BuildGeometriesGeom(iScope, list);
                    if (iShape2 == null) continue;
                    if (iShape == null) {
                        iShape = iShape2;
                    }
                    iShape.getOrCreateAttributes().put((Object)("lod" + String.valueOf(object3)), (Object)iShape2.copy(iScope));
                }
                if (iShape != null) {
                    object.add(iShape);
                }
                if (abstractCityObject instanceof AbstractSpace && (object4 = this.BuildGeometriesSpace(iScope, (List<AbstractSpaceBoundaryProperty>)(object3 = ((AbstractSpace)abstractCityObject).getBoundaries()))) != null) {
                    if (gamaPoint != null) {
                        object4.setLocation(object4.getLocation().minus(gamaPoint));
                    }
                    object.add(object4);
                }
                switch (object3 = abstractCityObject.getClass().getSimpleName()) {
                    case "Building": {
                        list = (Building)abstractCityObject;
                        System.out.println(list.getId());
                        break;
                    }
                    case "GenericOccupiedSpace": {
                        list = (GenericOccupiedSpace)abstractCityObject;
                        System.out.println(list.getId());
                        break;
                    }
                    default: {
                        System.out.println("Unexpected city object: " + (String)object3);
                    }
                }
                System.out.println("shapes: " + object.size());
                this.setBuffer((IAddressableContainer)object);
                if (this.envelope != null) continue;
                this.envelope = Envelope3D.of((List)object);
            }
        }
        catch (CityJSONContextException cityJSONContextException) {
            cityJSONContextException.printStackTrace();
        }
    }
}

