/*
 * Decompiled with CFR 0.152.
 */
package gama.experimental.gaming.ui.skills;

import gama.annotations.precompiler.GamlAnnotations;
import gama.core.common.interfaces.ILayer;
import gama.core.metamodel.agent.IAgent;
import gama.core.metamodel.shape.GamaPoint;
import gama.core.outputs.IOutput;
import gama.core.outputs.LayeredDisplayOutput;
import gama.core.runtime.IScope;
import gama.gaml.skills.Skill;
import java.util.ArrayList;
import org.locationtech.jts.geom.Envelope;

@GamlAnnotations.vars(value={@GamlAnnotations.variable(name="locked_location", type=7, doc={@GamlAnnotations.doc(value="locked location")}), @GamlAnnotations.variable(name="locked_ui_width", type=2, doc={@GamlAnnotations.doc(value="locked width")}), @GamlAnnotations.variable(name="locked_ui_height", type=2, doc={@GamlAnnotations.doc(value="locked height")}), @GamlAnnotations.variable(name="ui_width", type=2, doc={@GamlAnnotations.doc(value="resized width")}), @GamlAnnotations.variable(name="ui_height", type=2, doc={@GamlAnnotations.doc(value="resized height")}), @GamlAnnotations.variable(name="locked_display", type=4, doc={@GamlAnnotations.doc(value="map of location")})})
@GamlAnnotations.skill(name="UI_location", concept={"gui", "communication", "skill"})
public class UILocatedSkill
extends Skill {
    private ArrayList<IAgent> followedAgent = null;

    @GamlAnnotations.action(name="lock_agent_at", args={@GamlAnnotations.arg(name="ui_location", type=7, optional=false, doc={@GamlAnnotations.doc(value="location in the display")}), @GamlAnnotations.arg(name="display_name", type=4, optional=false, doc={@GamlAnnotations.doc(value="name of the display")}), @GamlAnnotations.arg(name="ui_height", type=2, optional=false, doc={@GamlAnnotations.doc(value="width of the object in %")}), @GamlAnnotations.arg(name="ui_width", type=2, optional=false, doc={@GamlAnnotations.doc(value="height of the object in %")})}, doc={@GamlAnnotations.doc(value="", returns="", examples={@GamlAnnotations.example(value="")})})
    public void setAgentLocationInUI(IScope iScope) {
        if (this.followedAgent == null) {
            this.initialize(iScope);
        }
        IAgent iAgent = iScope.getAgent();
        String string = (String)iScope.getArg("display_name", 4);
        GamaPoint gamaPoint = (GamaPoint)iScope.getArg("ui_location", 7);
        double d = (Double)iScope.getArg("ui_width", 2);
        double d2 = (Double)iScope.getArg("ui_height", 2);
        this.setAgentLocationUI(iAgent, string, gamaPoint, d, d2);
        this.moveAgentUI(iAgent);
    }

    private void setAgentLocation(IAgent iAgent, GamaPoint gamaPoint) {
        iAgent.setAttribute("locked_location", (Object)gamaPoint);
    }

    public void setAgentLocationUI(IAgent iAgent, String string, GamaPoint gamaPoint, double d, double d2) {
        this.followedAgent.add(iAgent);
        iAgent.setAttribute("locked_display", (Object)string);
        this.setAgentLocation(iAgent, gamaPoint);
        iAgent.setAttribute("locked_ui_width", (Object)d);
        iAgent.setAttribute("locked_ui_height", (Object)d2);
    }

    public void lockAgent(IAgent iAgent) {
        this.followedAgent.add(iAgent);
    }

    public void unlockAgent(IAgent iAgent) {
        this.followedAgent.remove(iAgent);
    }

    @GamlAnnotations.action(name="refresh_me", args={}, doc={@GamlAnnotations.doc(value="", returns="", examples={@GamlAnnotations.example(value="")})})
    public void moveAgentUI(IScope iScope) {
        IAgent iAgent = iScope.getAgent();
        this.moveAgentUI(iAgent);
    }

    private void moveAgentUI(IAgent iAgent) {
        IScope iScope = iAgent.getScope();
        String string = (String)iAgent.getAttribute("locked_display");
        GamaPoint gamaPoint = (GamaPoint)iAgent.getAttribute("locked_location");
        double d = (Double)iAgent.getAttribute("locked_ui_width");
        double d2 = (Double)iAgent.getAttribute("locked_ui_height");
        IOutput iOutput = iScope.getSimulation().getOutputManager().getOutputWithOriginalName(string);
        if (!(iOutput instanceof LayeredDisplayOutput)) {
            return;
        }
        LayeredDisplayOutput layeredDisplayOutput = (LayeredDisplayOutput)iOutput;
        if (layeredDisplayOutput.getSurface() == null) {
            return;
        }
        Envelope envelope = layeredDisplayOutput.getSurface().getVisibleRegionForLayer((ILayer)layeredDisplayOutput.getSurface().getManager().getItems().get(0));
        double d3 = Math.max(0.0, envelope.getMinX());
        double d4 = Math.max(0.0, envelope.getMinY());
        double d5 = Math.min(envelope.getMaxX(), layeredDisplayOutput.getSurface().getEnvWidth());
        double d6 = Math.min(envelope.getMaxY(), layeredDisplayOutput.getSurface().getEnvHeight());
        double d7 = d3 + gamaPoint.x * (d5 - d3);
        double d8 = d4 + gamaPoint.y * (d6 - d4);
        double d9 = (d5 - d3) * d;
        double d10 = (d6 - d4) * d2;
        GamaPoint gamaPoint2 = new GamaPoint(d7, d8);
        iAgent.setAttribute("ui_width", (Object)d9);
        iAgent.setAttribute("ui_height", (Object)d10);
        iAgent.setLocation(gamaPoint2);
    }

    @GamlAnnotations.action(name="move_agent_at", args={@GamlAnnotations.arg(name="ui_location", type=7, optional=false, doc={@GamlAnnotations.doc(value="location in the display")})}, doc={@GamlAnnotations.doc(value="", returns="", examples={@GamlAnnotations.example(value="")})})
    public void moveAgentAt(IScope iScope) {
        IAgent iAgent = iScope.getAgent();
        GamaPoint gamaPoint = (GamaPoint)iScope.getArg("ui_location", 7);
        this.setAgentLocation(iAgent, gamaPoint);
        this.moveAgentUI(iAgent);
    }

    public void moveAllAgent() {
        for (IAgent iAgent : this.followedAgent) {
            this.moveAgentUI(iAgent);
        }
    }

    private void removeLockedAgent(IScope iScope) {
        this.followedAgent.clear();
        this.followedAgent = null;
    }

    private void removeDeadLockedAgent() {
        ArrayList<IAgent> arrayList = new ArrayList<IAgent>();
        for (IAgent iAgent : this.followedAgent) {
            if (!iAgent.dead()) continue;
            arrayList.add(iAgent);
        }
        for (IAgent iAgent : arrayList) {
            this.followedAgent.remove(iAgent);
        }
    }

    protected void initialize(IScope iScope) {
        this.followedAgent = new ArrayList();
        this.registerSimulationEvent(iScope);
    }

    private void registerSimulationEvent(IScope iScope2) {
        iScope2.getSimulation().postEndAction(iScope -> {
            this.removeDeadLockedAgent();
            return null;
        });
        iScope2.getSimulation().postDisposeAction(iScope -> {
            this.removeLockedAgent(iScope);
            return null;
        });
    }
}

