/*
 * Decompiled with CFR 0.152.
 */
package gama.experimental.gaming.ui.skills;

import gama.annotations.precompiler.GamlAnnotations;
import gama.core.metamodel.agent.IAgent;
import gama.core.metamodel.shape.GamaPoint;
import gama.core.runtime.IScope;
import gama.core.util.IList;
import gama.experimental.gaming.ui.skills.UILocatedSkill;
import java.util.ArrayList;
import java.util.Iterator;

@GamlAnnotations.vars(value={@GamlAnnotations.variable(name="locked_location", type=7, doc={@GamlAnnotations.doc(value="locked location")}), @GamlAnnotations.variable(name="locked_ui_width", type=2, doc={@GamlAnnotations.doc(value="locked width")}), @GamlAnnotations.variable(name="locked_ui_height", type=2, doc={@GamlAnnotations.doc(value="locked height")}), @GamlAnnotations.variable(name="ui_width", type=2, doc={@GamlAnnotations.doc(value="resized width")}), @GamlAnnotations.variable(name="ui_height", type=2, doc={@GamlAnnotations.doc(value="resized height")}), @GamlAnnotations.variable(name="number_of_lines", type=1, doc={@GamlAnnotations.doc(value="number of displayed lines")}), @GamlAnnotations.variable(name="number_of_columns", type=1, doc={@GamlAnnotations.doc(value="number of columns")}), @GamlAnnotations.variable(name="matrix_data", type=16, doc={@GamlAnnotations.doc(value="resized height")}), @GamlAnnotations.variable(name="locked_display", type=4, doc={@GamlAnnotations.doc(value="map of location")})})
@GamlAnnotations.skill(name="UI_table", concept={"gui", "communication", "skill"})
public class UITableSkill
extends UILocatedSkill {
    @Override
    @GamlAnnotations.action(name="lock_agent_at", args={@GamlAnnotations.arg(name="ui_location", type=7, optional=false, doc={@GamlAnnotations.doc(value="name of the display")}), @GamlAnnotations.arg(name="display_name", type=4, optional=false, doc={@GamlAnnotations.doc(value="name of the display")}), @GamlAnnotations.arg(name="number_of_lines", type=1, optional=false, doc={@GamlAnnotations.doc(value="number of displayed lines")}), @GamlAnnotations.arg(name="number_of_columns", type=1, optional=false, doc={@GamlAnnotations.doc(value="number of columns")}), @GamlAnnotations.arg(name="ui_height", type=2, optional=false, doc={@GamlAnnotations.doc(value="width of the object in %")}), @GamlAnnotations.arg(name="ui_width", type=2, optional=false, doc={@GamlAnnotations.doc(value="height of the object in %")})}, doc={@GamlAnnotations.doc(value="", returns="", examples={@GamlAnnotations.example(value="")})})
    public void setAgentLocationInUI(IScope iScope) {
        super.setAgentLocationInUI(iScope);
        IAgent iAgent = iScope.getAgent();
        int n = (Integer)iScope.getArg("number_of_columns", 1);
        int n2 = (Integer)iScope.getArg("number_of_lines", 1);
        iAgent.setAttribute("number_of_lines", (Object)n2);
        iAgent.setAttribute("number_of_columns", (Object)n);
        ArrayList arrayList = new ArrayList();
        iAgent.setAttribute("matrix_data", arrayList);
    }

    @GamlAnnotations.action(name="add_line", args={@GamlAnnotations.arg(name="elements", type=16, optional=false, doc={@GamlAnnotations.doc(value="list of agent to display")})}, doc={@GamlAnnotations.doc(value="", returns="", examples={@GamlAnnotations.example(value="")})})
    public void addLine(IScope iScope) {
        IAgent iAgent = iScope.getAgent();
        IList iList = (IList)iScope.getArg("elements", 16);
        ArrayList arrayList = (ArrayList)iAgent.getAttribute("matrix_data");
        float f = ((Float)iAgent.getAttribute("locked_ui_width")).floatValue();
        float f2 = ((Float)iAgent.getAttribute("locked_ui_height")).floatValue();
        int n = (Integer)iAgent.getAttribute("number_of_columns");
        int n2 = (Integer)iAgent.getAttribute("number_of_lines");
        String string = (String)iAgent.getAttribute("locked_display");
        IAgent[] iAgentArray = new IAgent[iList.size()];
        int n3 = 0;
        Iterator iterator2 = iList.iterator();
        while (iterator2.hasNext()) {
            IAgent iAgent2;
            iAgentArray[n3] = iAgent2 = (IAgent)iterator2.next();
            ++n3;
        }
        int n4 = arrayList.size();
        arrayList.add(iAgentArray);
        n3 = 0;
        for (Iterator iterator2 : iList) {
            GamaPoint gamaPoint = this.getCellCoordinate(iAgent, n4, n3);
            iterator2.setAttribute("locked_location", gamaPoint);
            iterator2.setAttribute("locked_ui_width", Float.valueOf(f / (float)n));
            iterator2.setAttribute("locked_ui_height", Float.valueOf(f2 / (float)n2));
            iterator2.setAttribute("locked_display", string);
            iterator2.setAttribute("i_coordinate", n4);
            iterator2.setAttribute("j_coordinate", n3);
            ++n3;
        }
    }

    public GamaPoint getCellCoordinate(IAgent iAgent, int n, int n2) {
        GamaPoint gamaPoint = (GamaPoint)iAgent.getAttribute("locked_location");
        float f = ((Float)iAgent.getAttribute("locked_ui_width")).floatValue();
        float f2 = ((Float)iAgent.getAttribute("locked_ui_height")).floatValue();
        int n3 = (Integer)iAgent.getAttribute("number_of_columns");
        int n4 = (Integer)iAgent.getAttribute("number_of_lines");
        double d = gamaPoint.x + (double)((float)n2 * (f / (float)n3));
        double d2 = gamaPoint.y + (double)((float)n * (f2 / (float)n4));
        GamaPoint gamaPoint2 = new GamaPoint(d, d2, 0.0);
        return gamaPoint2;
    }

    @Override
    public void initialize(IScope iScope) {
        super.initialize(iScope);
    }
}

