/*
 * Decompiled with CFR 0.152.
 */
package core.configuration;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import core.configuration.dictionary.IGenstarDictionary;
import core.configuration.jackson.GenstarConfigurationFileDeserializer;
import core.configuration.jackson.GenstarConfigurationFileSerializer;
import core.metamodel.attribute.Attribute;
import core.metamodel.io.GSSurveyWrapper;
import core.metamodel.value.IValue;
import gama.dev.DEBUG;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

@JsonTypeName(value="CONFIGURATION FILE")
@JsonSerialize(using=GenstarConfigurationFileSerializer.class)
@JsonDeserialize(using=GenstarConfigurationFileDeserializer.class)
public class GenstarConfigurationFile {
    public static final String SELF = "CONFIGURATION FILE";
    public static final String BASE_DIR = "MAIN DIRECTORY";
    public static final String INPUT_FILES = "INPUT FILES";
    public static final String DICOS = "DICTIONARIES";
    public static final String LAYER = "LAYER LEVEL";
    private final Map<GSSurveyWrapper, List<Integer>> dataFiles = new HashMap<GSSurveyWrapper, List<Integer>>();
    private Set<IGenstarDictionary<Attribute<? extends IValue>>> dictionaries = new HashSet<IGenstarDictionary<Attribute<? extends IValue>>>();
    protected Path baseDirectory = null;

    @JsonProperty(value="INPUT FILES")
    public Map<GSSurveyWrapper, List<Integer>> getWrappers() {
        return Collections.unmodifiableMap(this.dataFiles);
    }

    @JsonProperty(value="INPUT FILES")
    public void setWrappers(Map<GSSurveyWrapper, List<Integer>> map) {
        this.dataFiles.putAll(map);
    }

    public List<GSSurveyWrapper> getSurveyWrappers() {
        return this.getSurveyWrappers(0);
    }

    public List<GSSurveyWrapper> getSurveyWrappers(int n) {
        if (this.dataFiles.values().stream().noneMatch(list -> list.contains(n))) {
            throw new NullPointerException("No survey wrappers for layer " + n);
        }
        return this.dataFiles.keySet().stream().filter(gSSurveyWrapper -> this.dataFiles.get(gSSurveyWrapper).contains(n)).toList();
    }

    public void setSurveyWrappers(List<GSSurveyWrapper> list) {
        list.stream().forEach(gSSurveyWrapper -> {
            List<Integer> list = this.dataFiles.put((GSSurveyWrapper)gSSurveyWrapper, Arrays.asList(0));
        });
    }

    public void addSurveyWrapper(GSSurveyWrapper gSSurveyWrapper) {
        this.dataFiles.putIfAbsent(gSSurveyWrapper, Arrays.asList(0));
    }

    public void addSurveyWrapper(GSSurveyWrapper gSSurveyWrapper, Integer ... integerArray) {
        this.dataFiles.putIfAbsent(gSSurveyWrapper, Arrays.asList(integerArray));
    }

    public IGenstarDictionary<Attribute<? extends IValue>> getDictionary() {
        return this.getDictionaries().size() == 1 ? this.dictionaries.iterator().next() : this.getDictionary(0);
    }

    public void setDictionary(IGenstarDictionary<Attribute<? extends IValue>> iGenstarDictionary) {
        this.dictionaries.add(iGenstarDictionary);
    }

    public IGenstarDictionary<Attribute<? extends IValue>> getDictionary(int n) {
        Optional<IGenstarDictionary> optional = this.dictionaries.stream().filter(iGenstarDictionary -> iGenstarDictionary.getLevel() == n).findFirst();
        return optional.isEmpty() ? null : optional.get();
    }

    @JsonProperty(value="DICTIONARIES")
    public Set<IGenstarDictionary<Attribute<? extends IValue>>> getDictionaries() {
        return Collections.unmodifiableSet(this.dictionaries);
    }

    @JsonProperty(value="DICTIONARIES")
    public void setDictionaries(Set<IGenstarDictionary<Attribute<? extends IValue>>> set) {
        if (set.stream().noneMatch(iGenstarDictionary -> iGenstarDictionary.getLevel() == 0)) {
            throw new IllegalArgumentException("Dictionary must include 0 based layer population");
        }
        set.stream().forEach(this::isCircleReferencedAttribute);
        this.dictionaries = set;
    }

    @JsonProperty(value="MAIN DIRECTORY")
    public Path getBaseDirectory() {
        return this.baseDirectory;
    }

    @JsonProperty(value="MAIN DIRECTORY")
    public void setBaseDirectory(Path path) {
        DEBUG.OUT((Object)("Setting Genstar configuration basepath to " + String.valueOf(path)));
        this.baseDirectory = path;
    }

    public int getLevel() {
        return this.dictionaries.size();
    }

    public List<Integer> getLayers() {
        return this.dictionaries.stream().map(IGenstarDictionary::getLevel).toList();
    }

    private void isCircleReferencedAttribute(IGenstarDictionary<Attribute<? extends IValue>> iGenstarDictionary) throws IllegalArgumentException {
        HashSet<Attribute<? extends IValue>> hashSet = new HashSet<Attribute<? extends IValue>>();
        if (iGenstarDictionary != null) {
            hashSet.addAll(iGenstarDictionary.getAttributes());
        }
        Map<Attribute, Attribute> map = hashSet.stream().filter(attribute -> !attribute.getReferentAttribute().equals(attribute)).collect(Collectors.toMap(attribute -> attribute, Attribute::getReferentAttribute));
        Map<Attribute, Attribute> map2 = map.keySet().stream().filter(map::containsValue).collect(Collectors.toMap(attribute -> attribute, map::get));
        if (!map2.isEmpty() && map2.keySet().containsAll(map2.values())) {
            throw new IllegalArgumentException("You cannot setup circular references between attributes: " + map2.entrySet().stream().map(entry -> ((Attribute)entry.getKey()).getAttributeName() + " > " + ((Attribute)entry.getValue()).getAttributeName()).reduce((string, string2) -> string.concat(" >> " + string2)).orElse(""));
        }
    }
}

