/*
 * Decompiled with CFR 0.152.
 */
package core.configuration;

import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import core.configuration.GenstarConfigurationFile;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class GenstarJsonUtil {
    public static final String GENSTAR_EXT = "gns";
    private final ObjectMapper om = new ObjectMapper();

    public GenstarJsonUtil() {
        this(Arrays.asList(SerializationFeature.INDENT_OUTPUT), Collections.emptyList());
    }

    public GenstarJsonUtil(List<SerializationFeature> list, List<DeserializationFeature> list2) {
        SimpleModule simpleModule = new SimpleModule();
        simpleModule.addSerializer(Path.class, (JsonSerializer)new ToStringSerializer());
        this.om.registerModule((Module)simpleModule);
        list.stream().forEach(serializationFeature -> {
            ObjectMapper objectMapper = this.om.configure(serializationFeature, !this.om.getSerializationConfig().isEnabled(serializationFeature));
        });
        list2.stream().forEach(deserializationFeature -> {
            ObjectMapper objectMapper = this.om.configure(deserializationFeature, !this.om.getDeserializationConfig().isEnabled(deserializationFeature));
        });
    }

    public void marshalToGenstarJson(Path path, Object object, boolean bl, SerializationFeature ... serializationFeatureArray) throws JsonGenerationException, JsonMappingException, IOException {
        File file = path.toFile();
        if (bl) {
            file.deleteOnExit();
        }
        Stream.of(serializationFeatureArray).forEach(serializationFeature -> {
            ObjectMapper objectMapper = this.om.enable(serializationFeature);
        });
        this.om.writeValue(file, object);
    }

    public String genstarJsonToString(Object object, SerializationFeature ... serializationFeatureArray) throws JsonProcessingException {
        Stream.of(serializationFeatureArray).forEach(serializationFeature -> {
            ObjectMapper objectMapper = this.om.enable(serializationFeature);
        });
        return this.om.writeValueAsString(object);
    }

    public <T> T unmarshalFromGenstarJson(Path path, Class<T> clazz) throws IOException, IllegalArgumentException {
        if (!path.toString().endsWith(GENSTAR_EXT)) {
            throw new IllegalArgumentException("The file " + path.toFile().getName() + " is not a \"gns\" file");
        }
        return (T)this.om.readerFor(clazz).readValue(path.toFile());
    }

    public GenstarConfigurationFile unmarchalConfigurationFileFromGenstarJson(Path path) throws IOException {
        if (!path.toString().endsWith(GENSTAR_EXT)) {
            throw new IllegalArgumentException("The file " + path.toFile().getName() + " is not a \"gns\" file");
        }
        GenstarConfigurationFile genstarConfigurationFile = (GenstarConfigurationFile)this.om.readerFor(GenstarConfigurationFile.class).readValue(path.toFile());
        genstarConfigurationFile.setBaseDirectory(path.getParent());
        return genstarConfigurationFile;
    }

    public static String getJsonNodeContentToString(JsonNode jsonNode) {
        HashMap hashMap = new HashMap();
        jsonNode.fields().forEachRemaining(entry -> {
            JsonNode jsonNode = hashMap.put((String)entry.getKey(), (JsonNode)entry.getValue());
        });
        return hashMap.entrySet().stream().map(entry -> (String)entry.getKey() + " [" + ((JsonNode)entry.getValue()).getNodeType().toString() + "] is null ? " + ((JsonNode)entry.getValue()).isNull()).collect(Collectors.joining("\n"));
    }
}

