/*
 * Decompiled with CFR 0.152.
 */
package core.configuration.jackson.attribute;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.node.JsonNodeType;
import core.metamodel.attribute.Attribute;
import core.metamodel.attribute.AttributeFactory;
import core.metamodel.attribute.EmergentAttribute;
import core.metamodel.attribute.IAttribute;
import core.metamodel.attribute.MappedAttribute;
import core.metamodel.attribute.emergent.aggregator.IAggregatorValueFunction;
import core.metamodel.attribute.emergent.filter.GSMatchFilter;
import core.metamodel.attribute.emergent.filter.GSMatchSelection;
import core.metamodel.attribute.emergent.filter.GSNoFilter;
import core.metamodel.attribute.emergent.filter.IGSEntitySelector;
import core.metamodel.attribute.record.RecordAttribute;
import core.metamodel.entity.IEntity;
import core.metamodel.entity.comparator.ImplicitEntityComparator;
import core.metamodel.entity.comparator.function.IComparatorFunction;
import core.metamodel.entity.matcher.AttributeVectorMatcher;
import core.metamodel.entity.matcher.IGSEntityMatcher;
import core.metamodel.entity.matcher.MatchType;
import core.metamodel.entity.matcher.TagMatcher;
import core.metamodel.entity.tag.EntityTag;
import core.metamodel.value.IValue;
import core.metamodel.value.categoric.NominalValue;
import core.metamodel.value.categoric.OrderedValue;
import core.metamodel.value.numeric.RangeValue;
import core.util.data.GSEnumDataType;
import core.util.exception.GSIllegalRangedData;
import core.util.exception.GenstarException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

public class AttributeDeserializer
extends StdDeserializer<IAttribute<? extends IValue>> {
    protected static final Map<String, Attribute<? extends IValue>> DES_DEMO_ATTRIBUTES = new HashMap<String, Attribute<? extends IValue>>();
    private static final long serialVersionUID = 1L;

    public AttributeDeserializer() {
        this(null);
    }

    public AttributeDeserializer(Class<?> clazz) {
        super(clazz);
    }

    public IAttribute<? extends IValue> deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
        ObjectMapper objectMapper = (ObjectMapper)jsonParser.getCodec();
        JsonNode jsonNode = (JsonNode)objectMapper.readTree(jsonParser);
        String string = jsonParser.getParsingContext().getCurrentName();
        try {
            return switch (string) {
                case "ATTRIBUTE" -> this.deserializeAttribute(jsonNode);
                case "MAPPED ATTRIBUTE" -> {
                    String var7_8;
                    switch (var7_8 = jsonNode.get("MAPPER").get("TYPE").asText()) {
                        case "REC": {
                            yield this.deserializeRMA(jsonNode);
                        }
                        case "AGG": {
                            yield this.deserializeAMA(jsonNode);
                        }
                        case "UND": {
                            yield this.deserializeUMA(jsonNode);
                        }
                    }
                    throw new IllegalArgumentException("Trying to deserialize unrecognized mapper: " + var7_8);
                }
                case "RECORD ATTRIBUTE" -> this.deserializeRA(jsonNode);
                case "EMERGENT ATTRIBUTE" -> this.deserializeEA(jsonNode);
                default -> throw new IllegalArgumentException("Trying to parse unknown attribute type: " + string);
            };
        }
        catch (GSIllegalRangedData gSIllegalRangedData) {
            gSIllegalRangedData.printStackTrace();
            throw new GenstarException();
        }
    }

    private Attribute<? extends IValue> deserializeAttribute(JsonNode jsonNode) throws GSIllegalRangedData {
        Attribute<? extends IValue> attribute;
        String string = this.getName(jsonNode);
        if (DES_DEMO_ATTRIBUTES.containsKey(string)) {
            return DES_DEMO_ATTRIBUTES.get(string);
        }
        try {
            attribute = AttributeFactory.getFactory().createAttribute(string, this.getType(jsonNode), this.getValues(jsonNode), this.getRecordMapping(jsonNode));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            attribute = AttributeFactory.getFactory().createAttribute(string, this.getType(jsonNode), this.getValues(jsonNode));
        }
        DES_DEMO_ATTRIBUTES.put(string, attribute);
        return attribute;
    }

    private IAttribute<? extends IValue> deserializeEA(JsonNode jsonNode) {
        String string = this.getName(jsonNode);
        if (DES_DEMO_ATTRIBUTES.containsKey(string)) {
            return DES_DEMO_ATTRIBUTES.get(string);
        }
        EmergentAttribute<? extends IValue, ?, ?> emergentAttribute = null;
        try {
            emergentAttribute = this.getEmergentAttribute(jsonNode);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        DES_DEMO_ATTRIBUTES.put(string, emergentAttribute);
        return emergentAttribute;
    }

    private Attribute<? extends IValue> deserializeUMA(JsonNode jsonNode) throws GSIllegalRangedData {
        MappedAttribute<IValue, ? extends IValue> mappedAttribute;
        String string = this.getName(jsonNode);
        if (DES_DEMO_ATTRIBUTES.containsKey(string)) {
            return DES_DEMO_ATTRIBUTES.get(string);
        }
        try {
            mappedAttribute = AttributeFactory.getFactory().createSTSMappedAttribute(this.getName(jsonNode), this.getType(jsonNode), this.getReferentAttribute(jsonNode), this.getOrderedMapper(jsonNode), this.getRecordMapping(jsonNode));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            mappedAttribute = AttributeFactory.getFactory().createSTSMappedAttribute(this.getName(jsonNode), this.getType(jsonNode), this.getReferentAttribute(jsonNode), this.getOrderedMapper(jsonNode));
        }
        DES_DEMO_ATTRIBUTES.put(string, mappedAttribute);
        return mappedAttribute;
    }

    private Attribute<? extends IValue> deserializeRMA(JsonNode jsonNode) throws GSIllegalRangedData {
        String string = this.getName(jsonNode);
        if (DES_DEMO_ATTRIBUTES.containsKey(string)) {
            return DES_DEMO_ATTRIBUTES.get(string);
        }
        MappedAttribute<IValue, ? extends IValue> mappedAttribute = AttributeFactory.getFactory().createSTOMappedAttribute(this.getName(jsonNode), this.getType(jsonNode), this.getReferentAttribute(jsonNode), this.getOrderedRecord(jsonNode));
        DES_DEMO_ATTRIBUTES.put(string, mappedAttribute);
        return mappedAttribute;
    }

    private Attribute<? extends IValue> deserializeAMA(JsonNode jsonNode) throws GSIllegalRangedData {
        String string = this.getName(jsonNode);
        if (DES_DEMO_ATTRIBUTES.containsKey(string)) {
            return DES_DEMO_ATTRIBUTES.get(string);
        }
        MappedAttribute<IValue, IValue> mappedAttribute = null;
        Map<String, Collection<String>> map = this.getOrderedAggregate(jsonNode);
        switch (this.getType(jsonNode)) {
            case Range: {
                try {
                    mappedAttribute = AttributeFactory.getFactory().createRangeAggregatedAttribute(string, this.deserializeAttribute(RangeValue.class, jsonNode.findValue("REFERENT ATTRIBUTE")), map, this.getRecordMapping(jsonNode));
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    mappedAttribute = AttributeFactory.getFactory().createRangeAggregatedAttribute(string, this.deserializeAttribute(RangeValue.class, jsonNode.findValue("REFERENT ATTRIBUTE")), map);
                }
                break;
            }
            case Nominal: {
                try {
                    mappedAttribute = AttributeFactory.getFactory().createNominalAggregatedAttribute(string, this.deserializeAttribute(NominalValue.class, jsonNode.findValue("REFERENT ATTRIBUTE")), map, this.getRecordMapping(jsonNode));
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    mappedAttribute = AttributeFactory.getFactory().createNominalAggregatedAttribute(string, this.deserializeAttribute(NominalValue.class, jsonNode.findValue("REFERENT ATTRIBUTE")), map);
                }
                break;
            }
            case Order: {
                try {
                    mappedAttribute = AttributeFactory.getFactory().createOrderedAggregatedAttribute(string, this.deserializeAttribute(OrderedValue.class, jsonNode.findValue("REFERENT ATTRIBUTE")), map.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> new ArrayList((Collection)entry.getValue()), (list, list2) -> list, LinkedHashMap::new)), this.getRecordMapping(jsonNode));
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    mappedAttribute = AttributeFactory.getFactory().createOrderedAggregatedAttribute(string, this.deserializeAttribute(OrderedValue.class, jsonNode.findValue("REFERENT ATTRIBUTE")), map.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> new ArrayList((Collection)entry.getValue()), (list, list2) -> list, LinkedHashMap::new)));
                }
                break;
            }
            default: {
                throw new IllegalArgumentException("Trying to parse unknown value type: " + String.valueOf((Object)this.getType(jsonNode)));
            }
        }
        DES_DEMO_ATTRIBUTES.put(string, mappedAttribute);
        return mappedAttribute;
    }

    private <V extends IValue> Attribute<V> deserializeAttribute(Class<V> clazz, JsonNode jsonNode) throws GSIllegalRangedData {
        if (!jsonNode.asText().isEmpty()) {
            Attribute<? extends IValue> attribute = DES_DEMO_ATTRIBUTES.get(jsonNode.asText());
            if (attribute.getValueSpace().getType().equals((Object)GSEnumDataType.getType(clazz))) {
                return attribute;
            }
            throw new IllegalStateException("Trying to deserialize attribute \"" + jsonNode.asText() + "\" of type " + String.valueOf((Object)attribute.getValueSpace().getType()) + " as a " + clazz.getCanonicalName() + " attribute type");
        }
        Attribute<V> attribute = AttributeFactory.getFactory().createAttribute(this.getName(jsonNode.findValue("ATTRIBUTE")), this.getValues(jsonNode.findValue("ATTRIBUTE")), clazz);
        DES_DEMO_ATTRIBUTES.put(attribute.getAttributeName(), attribute);
        return attribute;
    }

    private RecordAttribute<? extends IAttribute<? extends IValue>, ? extends IAttribute<? extends IValue>> deserializeRA(JsonNode jsonNode) throws GSIllegalRangedData {
        return AttributeFactory.getFactory().createRecordAttribute(this.getName(jsonNode), GSEnumDataType.valueOf(jsonNode.findValue("PROXY ATTRIBUTE TYPE").asText()), this.getReferentAttribute(jsonNode));
    }

    private String getName(JsonNode jsonNode) {
        return jsonNode.get("NAME").asText();
    }

    private GSEnumDataType getType(JsonNode jsonNode) {
        return GSEnumDataType.valueOf(jsonNode.findValue("TYPE").asText());
    }

    private List<String> getValues(JsonNode jsonNode) {
        return jsonNode.findValue("VALUE SPACE").findValue("VALUES").findValues("INPUT VALUE").stream().map(JsonNode::asText).toList();
    }

    private Attribute<? extends IValue> getReferentAttribute(JsonNode jsonNode) throws GSIllegalRangedData {
        JsonNode jsonNode2 = jsonNode.findValue("REFERENT ATTRIBUTE");
        if (JsonNodeType.STRING.equals((Object)jsonNode2.getNodeType())) {
            return DES_DEMO_ATTRIBUTES.get(jsonNode2.asText());
        }
        return this.deserializeAttribute(jsonNode.findValue("REFERENT ATTRIBUTE").findValue("ATTRIBUTE"));
    }

    private Map<String, String> getRecordMapping(JsonNode jsonNode) {
        JsonNode jsonNode2 = jsonNode.findValue("ENCODED VALUES");
        if (jsonNode2 == null || !jsonNode2.has("MAPPING")) {
            throw new IllegalArgumentException("Trying to unmap the mapper but cannot access array mapping: node type instade is " + String.valueOf(jsonNode.getNodeType()));
        }
        HashMap<String, String> hashMap = new HashMap<String, String>();
        JsonNode jsonNode3 = jsonNode2.get("MAPPING");
        int n = 0;
        while (jsonNode3.has(n)) {
            String[] stringArray = jsonNode3.get(n++).asText().split(" : ");
            String[] stringArray2 = stringArray[1].split(";");
            int n2 = stringArray2.length;
            int n3 = 0;
            while (n3 < n2) {
                String string = stringArray2[n3];
                hashMap.put(string, stringArray[0].trim());
                ++n3;
            }
        }
        return hashMap;
    }

    private LinkedHashMap<String, String> getOrderedRecord(JsonNode jsonNode) {
        JsonNode jsonNode2 = this.validateMapper(jsonNode);
        LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>();
        int n = 0;
        while (jsonNode2.has(n)) {
            String[] stringArray;
            if ((stringArray = jsonNode2.get(n++).asText().split(" : ")).length != 2) {
                throw new IllegalArgumentException("Not a key / value match but has " + stringArray.length + " match");
            }
            linkedHashMap.put(stringArray[0].trim(), stringArray[1].trim());
        }
        return linkedHashMap;
    }

    private Map<Collection<String>, Collection<String>> getOrderedMapper(JsonNode jsonNode) {
        JsonNode jsonNode2 = this.validateMapper(jsonNode);
        LinkedHashMap<Collection<String>, Collection<String>> linkedHashMap = new LinkedHashMap<Collection<String>, Collection<String>>();
        int n = 0;
        while (jsonNode2.has(n)) {
            String[] stringArray;
            if ((stringArray = jsonNode2.get(n++).asText().split(" : ")).length != 2) {
                throw new IllegalArgumentException("Not a key / value match but has " + stringArray.length + " match");
            }
            linkedHashMap.put(Arrays.asList(stringArray[0].split(";")).stream().map(String::trim).toList(), Arrays.asList(stringArray[1].split(";")).stream().map(String::trim).toList());
        }
        return linkedHashMap;
    }

    private Map<String, Collection<String>> getOrderedAggregate(JsonNode jsonNode) {
        JsonNode jsonNode2 = this.validateMapper(jsonNode);
        LinkedHashMap<String, Collection<String>> linkedHashMap = new LinkedHashMap<String, Collection<String>>();
        int n = 0;
        while (jsonNode2.has(n)) {
            String[] stringArray;
            if ((stringArray = jsonNode2.get(n++).asText().split(" : ")).length != 2) {
                throw new IllegalArgumentException("Not a key / value match but has " + stringArray.length + " match");
            }
            linkedHashMap.put(stringArray[0].trim(), Arrays.asList(stringArray[1].split(";")).stream().map(String::trim).toList());
        }
        return linkedHashMap;
    }

    private JsonNode validateMapper(JsonNode jsonNode) {
        JsonNode jsonNode2 = jsonNode.findValue("THE MAP");
        if (!jsonNode2.isArray()) {
            throw new IllegalArgumentException("Trying to unmap the mapper but cannot access array mapping: node type instade is " + String.valueOf(jsonNode2.getNodeType()));
        }
        return jsonNode2;
    }

    private EmergentAttribute<? extends IValue, ?, ?> getEmergentAttribute(JsonNode jsonNode) throws IOException {
        String string = this.getName(jsonNode);
        JsonNode jsonNode2 = jsonNode.get("EMERGENT FUNCTION");
        JsonNode jsonNode3 = jsonNode.get("EMERGENT FILTER");
        JsonNode jsonNode4 = jsonNode2.get("VALUE MAPPING");
        EmergentAttribute<IValue, Object, ?> emergentAttribute = null;
        String string2 = jsonNode2.get("TYPE ID").textValue();
        Attribute<? extends IValue> attribute = null;
        if (jsonNode2.has("REFERENT ATTRIBUTE")) {
            attribute = DES_DEMO_ATTRIBUTES.get(jsonNode2.get("REFERENT ATTRIBUTE").asText());
        }
        switch (string2) {
            case "EMERGENT COUNT FUNCTION": {
                if (attribute == null) {
                    emergentAttribute = AttributeFactory.getFactory().createSizeAttribute(string);
                    break;
                }
                emergentAttribute = AttributeFactory.getFactory().createCountAttribute(string, this.getValues(jsonNode.findValue("ATTRIBUTE")), this.getCountMapping(jsonNode4), this.getCollectionTransposer(jsonNode3));
                break;
            }
            case "AGGREGATE VALUE FUNCTION": {
                emergentAttribute = AttributeFactory.getFactory().createAggregatedValueOfAttribute(string, attribute, this.getAggrgatorFunction(jsonNode2.get("AGGREGATOR")), this.getCollectionTransposer(jsonNode3));
                break;
            }
            case "ENTITY ATTRIBUTE VALUE FUNCTION": {
                if ("Identity".equals(jsonNode4.get(0).asText())) {
                    emergentAttribute = AttributeFactory.getFactory().createValueOfAttribute(string, attribute, this.getEntityTransposer(jsonNode3));
                    break;
                }
                emergentAttribute = AttributeFactory.getFactory().createValueOfAttribute(string, attribute, this.getValues(jsonNode.findValue("ATTRIBUTE")), this.getMapping(jsonNode4), this.getEntityTransposer(jsonNode3));
                break;
            }
            default: {
                throw new IllegalStateException("Emergent function type " + jsonNode2.get("TYPE ID").textValue() + " is unrecognized");
            }
        }
        return emergentAttribute;
    }

    private Map<String, String> getMapping(JsonNode jsonNode) {
        if (!jsonNode.isArray()) {
            throw new GenstarException("Error when deserializing mapping: " + jsonNode.toString());
        }
        HashMap<String, String> hashMap = new HashMap<String, String>();
        int n = 0;
        while (jsonNode.has(n)) {
            String[] stringArray;
            if ((stringArray = jsonNode.get(n++).asText().split(" : ")).length != 2) {
                throw new IllegalArgumentException("Not a key / value match but has " + stringArray.length + " match");
            }
            hashMap.put(stringArray[0].trim(), stringArray[1].trim());
        }
        return hashMap;
    }

    private Map<Integer, String> getCountMapping(JsonNode jsonNode) {
        if (!jsonNode.isArray()) {
            throw new GenstarException("Error when deserializing mapping: " + jsonNode.toString());
        }
        HashMap<Integer, String> hashMap = new HashMap<Integer, String>();
        int n = 0;
        while (jsonNode.has(n)) {
            String[] stringArray;
            if ((stringArray = jsonNode.get(n++).asText().split(" : ")).length != 2) {
                throw new IllegalArgumentException("Not a key / value match but has " + stringArray.length + " match");
            }
            hashMap.put(Integer.valueOf(stringArray[0].trim()), stringArray[1].trim());
        }
        return hashMap;
    }

    private <V extends IValue> IAggregatorValueFunction<V> getAggrgatorFunction(JsonNode jsonNode) throws IOException {
        return (IAggregatorValueFunction)new ObjectMapper().readValue(jsonNode.toString(), IAggregatorValueFunction.class);
    }

    private IGSEntitySelector<Collection<IEntity<? extends IAttribute<? extends IValue>>>, ?> getCollectionTransposer(JsonNode jsonNode) throws IOException {
        GSMatchFilter<Object> gSMatchFilter = null;
        String string = jsonNode.get("TYPE").asText();
        JsonNode jsonNode2 = jsonNode.get("MATCHERS");
        String string2 = jsonNode2.get("ENTITY MATCH TYPE").asText();
        MatchType matchType = MatchType.valueOf(jsonNode.get("MATCH TYPE").asText());
        ImplicitEntityComparator implicitEntityComparator = this.getComparator(jsonNode.get("COMPARATOR"));
        if (Objects.equals(string, "SELECTION FILTER")) {
            throw new IllegalArgumentException("Trying to deserialize transposer to collection of sub entities with a selection filter");
        }
        switch (string) {
            case "MATCH FILTER": {
                if (Objects.equals(string2, "VECTOR VALUE MATCHER")) {
                    gSMatchFilter = new GSMatchFilter<IValue>(new AttributeVectorMatcher(this.getValueMatchers(jsonNode.get("MATCH VECTOR"))), matchType);
                } else if (Objects.equals(string2, "TAG MATCHER")) {
                    gSMatchFilter = new GSMatchFilter<EntityTag>(new TagMatcher(this.getTagMatchers(jsonNode.get("MATCH VECTOR"))), matchType);
                }
                if (implicitEntityComparator == null && gSMatchFilter != null) {
                    gSMatchFilter.setComparator(implicitEntityComparator);
                }
                return gSMatchFilter;
            }
            case "EMPTY FILTER": {
                return new GSNoFilter();
            }
        }
        throw new GenstarException("Deserialization failed to create IGSEntityTransposer of type " + string);
    }

    private IGSEntitySelector<IEntity<? extends IAttribute<? extends IValue>>, ?> getEntityTransposer(JsonNode jsonNode) throws IOException {
        GSMatchSelection<EntityTag> gSMatchSelection = null;
        String string = jsonNode.get("TYPE").asText();
        JsonNode jsonNode2 = jsonNode.get("MATCHERS");
        String string2 = jsonNode2.get("ENTITY MATCH TYPE").asText();
        MatchType matchType = MatchType.valueOf(jsonNode.get("MATCH TYPE").asText());
        ImplicitEntityComparator implicitEntityComparator = this.getComparator(jsonNode.get("COMPARATOR"));
        if (!"SELECTION FILTER".equals(string)) {
            throw new IllegalArgumentException("Trying to deserialize entity transposer of sub entities with a filter mechanism : " + string);
        }
        gSMatchSelection = switch (string2) {
            case "VECTOR VALUE MATCHER" -> new GSMatchSelection<IValue>(new AttributeVectorMatcher(this.getValueMatchers(jsonNode2.get("MATCH VECTOR"))), matchType);
            case "TAG MATCHER" -> new GSMatchSelection<EntityTag>(new TagMatcher(this.getTagMatchers(jsonNode2.get("MATCH VECTOR"))), matchType);
            default -> throw new GenstarException("Trying to deserialize " + IGSEntityMatcher.class.getSimpleName() + " with unkown match type: " + string2);
        };
        gSMatchSelection.setComparator(implicitEntityComparator);
        return gSMatchSelection;
    }

    private IValue[] getValueMatchers(JsonNode jsonNode) {
        if (!jsonNode.isArray()) {
            throw new IllegalArgumentException("This node is not an array of matchers (node type is " + String.valueOf(jsonNode.getNodeType()) + ")");
        }
        ArrayList arrayList = new ArrayList();
        int n = 0;
        while (jsonNode.has(n)) {
            String string = jsonNode.get(n++).asText();
            Attribute attribute2 = DES_DEMO_ATTRIBUTES.values().stream().filter(attribute -> attribute.getValueSpace().contains(string)).findFirst().orElse(null);
            if (attribute2 == null) continue;
            Object v = attribute2.getValueSpace().getValue(string);
            arrayList.add(v);
        }
        return arrayList.toArray(new IValue[arrayList.size()]);
    }

    private EntityTag[] getTagMatchers(JsonNode jsonNode) {
        if (!jsonNode.isArray()) {
            throw new IllegalArgumentException("This node is not an array of matchers (node type is " + String.valueOf(jsonNode.getNodeType()) + ")");
        }
        ArrayList<EntityTag> arrayList = new ArrayList<EntityTag>();
        int n = 0;
        while (jsonNode.has(n)) {
            String string = jsonNode.get(n++).asText();
            arrayList.add(EntityTag.valueOf(string));
        }
        return arrayList.toArray(new EntityTag[arrayList.size()]);
    }

    private ImplicitEntityComparator getComparator(JsonNode jsonNode) throws IllegalArgumentException, IOException {
        JsonNode jsonNode2;
        ImplicitEntityComparator implicitEntityComparator = new ImplicitEntityComparator(new IAttribute[0]);
        if (jsonNode.has("CONTENT") && "Default".equals(jsonNode.get("CONTENT").asText())) {
            return implicitEntityComparator;
        }
        JsonNode jsonNode3 = jsonNode.get("LISTED ATTRIBUTES");
        int n = -1;
        HashMap<IAttribute, Boolean> hashMap = new HashMap<IAttribute, Boolean>();
        while (jsonNode3.has(++n)) {
            jsonNode2 = jsonNode3.get(n).asText().split(" : ");
            hashMap.put(DES_DEMO_ATTRIBUTES.get(jsonNode2[0]), Boolean.valueOf((String)jsonNode2[1]));
        }
        hashMap.entrySet().stream().forEach(entry -> {
            ImplicitEntityComparator implicitEntityComparator2 = implicitEntityComparator.setAttribute((IAttribute)entry.getKey(), (Boolean)entry.getValue());
        });
        jsonNode2 = jsonNode.get("CUSTOM COMPARATOR FUNCTIONS");
        n = -1;
        HashSet<IComparatorFunction> hashSet = new HashSet<IComparatorFunction>();
        ObjectMapper objectMapper = new ObjectMapper();
        while (jsonNode2.has(++n)) {
            hashSet.add((IComparatorFunction)objectMapper.readerFor(IComparatorFunction.class).readValue(jsonNode2.get(n).asText()));
        }
        hashSet.stream().forEach(implicitEntityComparator::setComparatorFunction);
        return implicitEntityComparator;
    }
}

