/*
 * Decompiled with CFR 0.152.
 */
package core.configuration.jackson.attribute;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.jsontype.TypeSerializer;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import core.metamodel.attribute.emergent.AggregateValueFunction;
import core.metamodel.attribute.emergent.CountValueFunction;
import core.metamodel.attribute.emergent.EntityValueFunction;
import core.metamodel.attribute.emergent.IGSValueFunction;
import core.metamodel.value.IValue;
import java.io.IOException;
import java.util.Map;

public class EmergentFunctionSerializer
extends StdSerializer<IGSValueFunction<?, ? extends IValue>> {
    private static final long serialVersionUID = 1L;

    protected EmergentFunctionSerializer() {
        this(null);
    }

    protected EmergentFunctionSerializer(Class<IGSValueFunction<?, ? extends IValue>> clazz) {
        super(clazz);
    }

    public void serialize(IGSValueFunction<?, ? extends IValue> iGSValueFunction, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
    }

    public void serializeWithType(IGSValueFunction<?, ? extends IValue> iGSValueFunction, JsonGenerator jsonGenerator, SerializerProvider serializerProvider, TypeSerializer typeSerializer) throws IOException {
        String string = typeSerializer.getTypeIdResolver().idFromValue(iGSValueFunction);
        jsonGenerator.writeStartObject();
        jsonGenerator.writeStringField("TYPE ID", string);
        jsonGenerator.writeStringField("REFERENT ATTRIBUTE", iGSValueFunction.getReferent().getAttributeName());
        if ("AGGREGATE VALUE FUNCTION".equals(string)) {
            jsonGenerator.writeFieldName("AGGREGATOR");
            jsonGenerator.writeStartObject();
            jsonGenerator.writeStringField("TYPE", typeSerializer.getTypeIdResolver().idFromValue(((AggregateValueFunction)iGSValueFunction).getAggregator()));
            jsonGenerator.writeEndObject();
        } else {
            Map map = null;
            boolean bl = false;
            if ("EMERGENT COUNT FUNCTION".equals(string)) {
                map = ((CountValueFunction)iGSValueFunction).getMapping();
            } else if ("ENTITY ATTRIBUTE VALUE FUNCTION".equals(string)) {
                Map.Entry entry2 = (EntityValueFunction)iGSValueFunction;
                map = ((EntityValueFunction)((Object)entry2)).getMapping();
                bl = map.entrySet().stream().allMatch(entry -> entry.getKey().equals(entry.getValue()));
            }
            jsonGenerator.writeArrayFieldStart("VALUE MAPPING");
            if (bl) {
                jsonGenerator.writeString("Identity");
            } else if (map != null) {
                for (Map.Entry entry2 : map.entrySet()) {
                    String string2 = entry2.getKey().getClass().getSuperclass().equals(IValue.class) ? ((IValue)entry2.getKey()).getStringValue() : entry2.getKey().toString();
                    String string3 = ((IValue)entry2.getValue()).getStringValue();
                    jsonGenerator.writeString(string2 + " : " + string3);
                }
            }
            jsonGenerator.writeEndArray();
        }
        jsonGenerator.writeEndObject();
    }
}

