/*
 * Decompiled with CFR 0.152.
 */
package core.configuration.jackson.attribute.value;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.jsontype.TypeSerializer;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import core.metamodel.attribute.mapper.value.EncodedValueMapper;
import core.metamodel.value.IValue;
import core.metamodel.value.categoric.NominalValue;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;

public class RecordValueSerializer<K extends IValue>
extends StdSerializer<EncodedValueMapper<K>> {
    private static final long serialVersionUID = 1L;

    protected RecordValueSerializer() {
        this(null);
    }

    protected RecordValueSerializer(Class<EncodedValueMapper<K>> clazz) {
        super(clazz);
    }

    public void serialize(EncodedValueMapper<K> encodedValueMapper, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
        jsonGenerator.writeStartObject(encodedValueMapper);
        jsonGenerator.writeArrayFieldStart("MAPPING");
        for (String string : this.getRecordList(encodedValueMapper)) {
            jsonGenerator.writeString(string);
        }
        jsonGenerator.writeEndArray();
        jsonGenerator.writeEndObject();
    }

    public void serializeWithType(EncodedValueMapper<K> encodedValueMapper, JsonGenerator jsonGenerator, SerializerProvider serializerProvider, TypeSerializer typeSerializer) throws IOException {
    }

    private List<String> getRecordList(EncodedValueMapper<K> encodedValueMapper) {
        HashMap hashMap = new HashMap();
        for (NominalValue nominalValue : encodedValueMapper.getRecords()) {
            K k = encodedValueMapper.getRelatedValue(nominalValue);
            if (!hashMap.containsKey(k)) {
                hashMap.put(k, new HashSet());
            }
            ((Collection)hashMap.get(k)).add(nominalValue);
        }
        return hashMap.entrySet().stream().map(entry -> ((IValue)entry.getKey()).getStringValue() + " : " + ((Collection)entry.getValue()).stream().map(nominalValue -> nominalValue.getStringValue()).collect(Collectors.joining(";"))).toList();
    }
}

