/*
 * Decompiled with CFR 0.152.
 */
package core.configuration.jackson.entity;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import core.configuration.jackson.entity.EntityMatcherSerializer;
import core.metamodel.attribute.IAttribute;
import core.metamodel.entity.comparator.HammingEntityComparator;
import core.metamodel.entity.comparator.ImplicitEntityComparator;
import core.metamodel.entity.comparator.function.IComparatorFunction;
import core.metamodel.entity.matcher.AttributeVectorMatcher;
import core.metamodel.entity.matcher.IGSEntityMatcher;
import core.metamodel.value.IValue;
import core.util.data.GSEnumDataType;
import java.io.IOException;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class EntityComparatorSerializer
extends StdSerializer<ImplicitEntityComparator> {
    private static final long serialVersionUID = 1L;

    protected EntityComparatorSerializer() {
        this(null);
    }

    protected EntityComparatorSerializer(Class<ImplicitEntityComparator> clazz) {
        super(clazz);
    }

    public void serialize(ImplicitEntityComparator implicitEntityComparator, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
        AttributeVectorMatcher attributeVectorMatcher;
        List list = Stream.of(GSEnumDataType.values()).map(gSEnumDataType -> implicitEntityComparator.getComparatorFunction((GSEnumDataType)((Object)((Object)gSEnumDataType)))).filter(iComparatorFunction -> iComparatorFunction.getName().startsWith("CUSTOM - ")).collect(Collectors.toList());
        List<IAttribute<? extends IValue>> list2 = implicitEntityComparator.getAttributes();
        if (implicitEntityComparator instanceof HammingEntityComparator) {
            HammingEntityComparator hammingEntityComparator = (HammingEntityComparator)implicitEntityComparator;
            attributeVectorMatcher = hammingEntityComparator.getVectorMatcher();
        } else {
            attributeVectorMatcher = null;
        }
        AttributeVectorMatcher attributeVectorMatcher2 = attributeVectorMatcher;
        jsonGenerator.writeStartObject();
        if (list.isEmpty() && list2.isEmpty() && (attributeVectorMatcher2 == null || attributeVectorMatcher2.getMapVector().isEmpty())) {
            jsonGenerator.writeStringField("CONTENT", "Default");
        } else {
            jsonGenerator.writeArrayFieldStart("LISTED ATTRIBUTES");
            for (IAttribute<? extends IValue> object : list2) {
                jsonGenerator.writeString(object.getAttributeName() + " : " + implicitEntityComparator.isReverseAttribute(object));
            }
            jsonGenerator.writeEndArray();
            jsonGenerator.writeArrayFieldStart("CUSTOM COMPARATOR FUNCTIONS");
            for (IComparatorFunction iComparatorFunction2 : list) {
                jsonGenerator.writeObject((Object)iComparatorFunction2);
            }
            jsonGenerator.writeEndArray();
            if (implicitEntityComparator instanceof HammingEntityComparator) {
                jsonGenerator.writeFieldName("HAMMING VECTOR MATCHER");
                EntityMatcherSerializer entityMatcherSerializer = new EntityMatcherSerializer();
                entityMatcherSerializer.serializeWithType(attributeVectorMatcher2, jsonGenerator, serializerProvider, serializerProvider.findTypeSerializer(serializerProvider.constructType(IGSEntityMatcher.class)));
            } else {
                jsonGenerator.writeStringField("HAMMING VECTOR MATCHER", "Empty");
            }
        }
        jsonGenerator.writeEndObject();
    }
}

