/*
 * Decompiled with CFR 0.152.
 */
package core.metamodel.attribute.emergent.filter.predicate;

import core.metamodel.attribute.IAttribute;
import core.metamodel.attribute.emergent.filter.GSMatchFilter;
import core.metamodel.attribute.emergent.filter.IGSEntitySelector;
import core.metamodel.attribute.emergent.filter.predicate.GSMatchPredicate;
import core.metamodel.entity.IEntity;
import core.metamodel.entity.matcher.AttributeVectorMatcher;
import core.metamodel.entity.matcher.IGSEntityMatcher;
import core.metamodel.entity.matcher.MatchType;
import core.metamodel.value.IValue;
import java.util.Collection;
import java.util.function.Function;

public class GSPredicateFactory {
    private static final GSPredicateFactory FACTORY = new GSPredicateFactory();
    private static Function<Collection<IEntity<? extends IAttribute<? extends IValue>>>, Boolean> EXIST_P;

    private GSPredicateFactory() {
    }

    public static GSPredicateFactory getFactory() {
        return FACTORY;
    }

    public <T> GSMatchPredicate<Collection<IEntity<? extends IAttribute<? extends IValue>>>, T> createExistPredicate(IGSEntityMatcher<T> iGSEntityMatcher, MatchType matchType) {
        return new GSMatchPredicate(new GSMatchFilter<T>(iGSEntityMatcher, matchType), this.getExistanceFunction());
    }

    public <T> GSMatchPredicate<Collection<IEntity<? extends IAttribute<? extends IValue>>>, T> createExistPredicate(IGSEntitySelector<Collection<IEntity<? extends IAttribute<? extends IValue>>>, T> iGSEntitySelector, MatchType matchType, IValue ... iValueArray) {
        return new GSMatchPredicate<Collection<IEntity<? extends IAttribute<? extends IValue>>>, T>(iGSEntitySelector, this.getExistanceFunction(matchType, iValueArray));
    }

    public <T> GSMatchPredicate<IEntity<? extends IAttribute<? extends IValue>>, T> createExistPredicate(IGSEntitySelector<IEntity<? extends IAttribute<? extends IValue>>, T> iGSEntitySelector, IValue ... iValueArray) {
        return new GSMatchPredicate<IEntity<? extends IAttribute<? extends IValue>>, T>(iGSEntitySelector, this.getExistanceFunction(iValueArray));
    }

    private Function<IEntity<? extends IAttribute<? extends IValue>>, Boolean> getExistanceFunction(IValue[] iValueArray) {
        return new Function<IEntity<? extends IAttribute<? extends IValue>>, Boolean>(iValueArray){
            private AttributeVectorMatcher avm;
            {
                this.avm = new AttributeVectorMatcher(iValueArray);
            }

            @Override
            public Boolean apply(IEntity<? extends IAttribute<? extends IValue>> iEntity) {
                return this.avm.entityMatch(iEntity, MatchType.ALL);
            }
        };
    }

    private Function<Collection<IEntity<? extends IAttribute<? extends IValue>>>, Boolean> getExistanceFunction(MatchType matchType, IValue ... iValueArray) {
        switch (matchType) {
            case NONE: {
                return new Function<Collection<IEntity<? extends IAttribute<? extends IValue>>>, Boolean>(iValueArray){
                    private AttributeVectorMatcher avm;
                    {
                        this.avm = new AttributeVectorMatcher(iValueArray);
                    }

                    @Override
                    public Boolean apply(Collection<IEntity<? extends IAttribute<? extends IValue>>> collection) {
                        return collection.stream().noneMatch(iEntity -> this.avm.entityMatch((IEntity<? extends IAttribute<? extends IValue>>)iEntity, MatchType.ALL));
                    }
                };
            }
            case ANY: {
                return new Function<Collection<IEntity<? extends IAttribute<? extends IValue>>>, Boolean>(iValueArray){
                    private AttributeVectorMatcher avm;
                    {
                        this.avm = new AttributeVectorMatcher(iValueArray);
                    }

                    @Override
                    public Boolean apply(Collection<IEntity<? extends IAttribute<? extends IValue>>> collection) {
                        return collection.stream().anyMatch(iEntity -> this.avm.entityMatch((IEntity<? extends IAttribute<? extends IValue>>)iEntity, MatchType.ALL));
                    }
                };
            }
        }
        return new Function<Collection<IEntity<? extends IAttribute<? extends IValue>>>, Boolean>(iValueArray){
            private AttributeVectorMatcher avm;
            {
                this.avm = new AttributeVectorMatcher(iValueArray);
            }

            @Override
            public Boolean apply(Collection<IEntity<? extends IAttribute<? extends IValue>>> collection) {
                return collection.stream().allMatch(iEntity -> this.avm.entityMatch((IEntity<? extends IAttribute<? extends IValue>>)iEntity, MatchType.ALL));
            }
        };
    }

    private Function<Collection<IEntity<? extends IAttribute<? extends IValue>>>, Boolean> getExistanceFunction() {
        if (EXIST_P == null) {
            EXIST_P = new Function<Collection<IEntity<? extends IAttribute<? extends IValue>>>, Boolean>(){

                @Override
                public Boolean apply(Collection<IEntity<? extends IAttribute<? extends IValue>>> collection) {
                    return !collection.isEmpty();
                }
            };
        }
        return EXIST_P;
    }
}

