/*
 * Decompiled with CFR 0.152.
 */
package core.metamodel.attribute.mapper;

import core.metamodel.attribute.MappedAttribute;
import core.metamodel.attribute.mapper.IAttributeMapper;
import core.metamodel.value.IValue;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.stream.Collectors;

public class AggregateMapper<V extends IValue>
implements IAttributeMapper<V, V> {
    private Map<V, Collection<V>> map = new LinkedHashMap<V, Collection<V>>();
    private MappedAttribute<V, V> relatedAttribute;

    @Override
    public boolean add(V v, V v2) {
        if (this.map.containsKey(v)) {
            return this.map.get(v).add(v2);
        }
        if (this.getRelatedAttribute().getValueSpace().contains((IValue)v) && this.getRelatedAttribute().getReferentAttribute().getValueSpace().getValues().contains(v2)) {
            this.map.put((ArrayList<IValue>)v, (Collection<ArrayList<IValue>>)new ArrayList<IValue>(Arrays.asList(v2)));
            return true;
        }
        return false;
    }

    @Override
    public Collection<V> getMappedValues(IValue iValue) {
        if (this.map.containsKey(iValue)) {
            return this.map.get(iValue);
        }
        if (this.map.values().stream().flatMap(Collection::stream).anyMatch(iValue2 -> iValue2.equals(iValue))) {
            return this.map.entrySet().stream().filter(entry -> ((Collection)entry.getValue()).contains(iValue)).map(entry -> (IValue)entry.getKey()).collect(Collectors.toSet());
        }
        throw new NullPointerException("The value " + String.valueOf(iValue) + " is not part of any known link attribute (" + String.valueOf(this) + " < " + String.valueOf(this.getRelatedAttribute().getReferentAttribute()) + ")");
    }

    @Override
    public void setRelatedAttribute(MappedAttribute<V, V> mappedAttribute) {
        this.relatedAttribute = mappedAttribute;
    }

    @Override
    public MappedAttribute<V, V> getRelatedAttribute() {
        return this.relatedAttribute;
    }

    @Override
    public Map<Collection<V>, Collection<V>> getRawMapper() {
        return this.map.keySet().stream().collect(Collectors.toMap(iValue -> Collections.singleton(iValue), iValue -> Collections.unmodifiableCollection(this.map.get(iValue))));
    }

    public Map<V, Collection<V>> getMapper() {
        return Collections.unmodifiableMap(this.map);
    }

    public void setMapper(Map<V, Collection<V>> map) {
        this.map = map;
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + (this.map == null ? 0 : this.map.hashCode());
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        AggregateMapper aggregateMapper = (AggregateMapper)object;
        return !(this.map == null ? aggregateMapper.map != null : !this.map.equals(aggregateMapper.map));
    }
}

