/*
 * Decompiled with CFR 0.152.
 */
package core.metamodel.attribute.mapper;

import com.fasterxml.jackson.annotation.JsonProperty;
import core.metamodel.attribute.MappedAttribute;
import core.metamodel.attribute.mapper.IAttributeMapper;
import core.metamodel.value.IValue;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

public class RecordMapper<K extends IValue, V extends IValue>
implements IAttributeMapper<K, V> {
    @JsonProperty(value="THE MAP")
    private Map<K, V> record = new LinkedHashMap();
    private MappedAttribute<K, V> relatedAttribute;

    @Override
    public boolean add(K k, V v) {
        if (this.record.containsKey(k)) {
            throw new IllegalStateException("Trying to erase existing record: [" + k.getStringValue() + " => " + String.valueOf(this.record.get(k)) + "]");
        }
        this.record.put(k, v);
        return true;
    }

    public Set<? extends IValue> getMappedValues(IValue iValue) {
        if (!this.record.containsKey(iValue) && !this.record.containsValue(iValue)) {
            throw new NullPointerException("The value " + String.valueOf(iValue) + " is not part of any known linked attribute (" + String.valueOf(this) + " || " + String.valueOf(this.relatedAttribute.getReferentAttribute()) + ")");
        }
        return Collections.singleton(this.record.containsKey(iValue) ? (IValue)this.record.get(iValue) : this.record.keySet().stream().filter(iValue2 -> ((IValue)this.record.get(iValue2)).equals(iValue)).findAny().get());
    }

    @Override
    public void setRelatedAttribute(MappedAttribute<K, V> mappedAttribute) {
        this.relatedAttribute = mappedAttribute;
    }

    @Override
    public MappedAttribute<K, V> getRelatedAttribute() {
        return this.relatedAttribute;
    }

    @Override
    public Map<Collection<K>, Collection<V>> getRawMapper() {
        return this.record.keySet().stream().collect(Collectors.toMap(iValue -> Collections.singleton(iValue), iValue -> Collections.singleton((IValue)this.record.get(iValue))));
    }

    public Map<K, V> getMapper() {
        return Collections.unmodifiableMap(this.record);
    }

    public void setMapper(Map<K, V> map) {
        this.record = map;
    }

    public K getKey(V v) {
        Optional<Map.Entry> optional = this.record.entrySet().stream().filter(entry -> ((IValue)entry.getValue()).equals(v)).findFirst();
        if (optional.isPresent()) {
            return (K)((IValue)optional.get().getKey());
        }
        throw new NullPointerException("Not any key for value record " + String.valueOf(v));
    }

    public K getKey(String string) {
        Optional<IValue> optional = this.record.values().stream().filter(iValue -> iValue.getStringValue().equals(string)).findFirst();
        if (optional.isPresent()) {
            return this.getKey(optional.get());
        }
        throw new NullPointerException("Not any key for value record " + string);
    }

    public V getValue(K k) {
        IValue iValue = this.record.getOrDefault(k, null);
        if (iValue != null) {
            return (V)iValue;
        }
        throw new NullPointerException("Not any value for key record " + String.valueOf(k));
    }

    public V getValue(String string) {
        Optional<IValue> optional = this.record.keySet().stream().filter(iValue -> iValue.getStringValue().equals(string)).findFirst();
        if (optional.isPresent()) {
            return this.getValue(optional.get());
        }
        throw new NullPointerException("Not any value for key record " + string);
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + (this.record == null ? 0 : this.record.hashCode());
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        RecordMapper recordMapper = (RecordMapper)object;
        return !(this.record == null ? recordMapper.record != null : !this.record.equals(recordMapper.record));
    }
}

