/*
 * Decompiled with CFR 0.152.
 */
package core.metamodel.attribute.mapper.value;

import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import core.configuration.jackson.attribute.value.RecordValueSerializer;
import core.metamodel.attribute.Attribute;
import core.metamodel.attribute.AttributeFactory;
import core.metamodel.value.IValue;
import core.metamodel.value.IValueSpace;
import core.metamodel.value.categoric.NominalValue;
import core.metamodel.value.categoric.template.GSCategoricTemplate;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;

@JsonTypeName(value="ENCODED VALUES")
@JsonSerialize(using=RecordValueSerializer.class)
public class EncodedValueMapper<K extends IValue> {
    public static final String SELF = "ENCODED VALUES";
    public static final String MAPPING = "MAPPING";
    private static final String ATTRIBUTE_NAME = "ENCODE ATT";
    private IValueSpace<K> values;
    private Map<NominalValue, K> mapper;
    private Attribute<NominalValue> self;

    public EncodedValueMapper(IValueSpace<K> iValueSpace) {
        this.values = iValueSpace;
        this.mapper = new HashMap<NominalValue, K>();
        this.self = AttributeFactory.getFactory().createNominalAttribute(ATTRIBUTE_NAME, new GSCategoricTemplate());
    }

    public EncodedValueMapper(IValueSpace<K> iValueSpace, Map<String, K> map) {
        this(iValueSpace);
        for (Map.Entry<String, K> entry : map.entrySet()) {
            this.putMapping((IValue)entry.getValue(), entry.getKey());
        }
    }

    public void putMapping(K k, String ... stringArray) {
        String[] stringArray2 = stringArray;
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String string = stringArray2[n2];
            this.mapper.put(this.self.getValueSpace().addValue(string), (NominalValue)k);
            ++n2;
        }
    }

    public boolean putMapping(String string, String ... stringArray) {
        Object v = null;
        try {
            v = this.values.getValue(string);
        }
        catch (NullPointerException nullPointerException) {
            return false;
        }
        String[] stringArray2 = stringArray;
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String string2 = stringArray2[n2];
            this.mapper.put(this.self.getValueSpace().addValue(string2), (NominalValue)v);
            ++n2;
        }
        return true;
    }

    public K getRelatedValue(IValue iValue) {
        return (K)((IValue)this.mapper.get(iValue));
    }

    public K getRelatedValue(String string) {
        return (K)((IValue)this.mapper.get(this.self.getValueSpace().getValue(string)));
    }

    public Collection<NominalValue> getRecords(K k) {
        return this.mapper.keySet().stream().filter(nominalValue -> ((IValue)this.mapper.get(nominalValue)).equals(k)).collect(Collectors.toSet());
    }

    public Collection<NominalValue> getRecords(String string) {
        K k = this.values.getValue(string);
        return this.mapper.keySet().stream().filter(nominalValue -> ((IValue)this.mapper.get(nominalValue)).equals(k)).collect(Collectors.toSet());
    }

    public Collection<NominalValue> getRecords() {
        return Collections.unmodifiableSet(this.mapper.keySet());
    }

    public boolean hasValueOrRecord(String string) {
        return this.mapper.entrySet().stream().anyMatch(entry -> ((NominalValue)entry.getKey()).getStringValue().equals(string) || ((IValue)entry.getValue()).getStringValue().equals(string));
    }

    public IValue transpose(IValue iValue) {
        if (!this.hasValueOrRecord(iValue.getStringValue())) {
            throw new NullPointerException("There is not any mapping for " + iValue.getStringValue());
        }
        return this.mapper.keySet().contains(iValue) ? (IValue)this.getRecords(iValue.getStringValue()).stream().findAny().get() : this.getRelatedValue(iValue.getStringValue());
    }
}

