/*
 * Decompiled with CFR 0.152.
 */
package core.metamodel.value.categoric;

import core.metamodel.attribute.IAttribute;
import core.metamodel.value.IValue;
import core.metamodel.value.IValueSpace;
import core.metamodel.value.categoric.NominalValue;
import core.metamodel.value.categoric.template.GSCategoricTemplate;
import core.util.data.GSEnumDataType;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class NominalSpace
implements IValueSpace<NominalValue> {
    private final IAttribute<NominalValue> attribute;
    protected Map<String, NominalValue> values;
    private NominalValue emptyValue;
    private final Set<String> excludedValues;
    private final GSCategoricTemplate ct;

    public NominalSpace(IAttribute<NominalValue> iAttribute, GSCategoricTemplate gSCategoricTemplate) {
        this.attribute = iAttribute;
        this.values = new HashMap<String, NominalValue>();
        this.excludedValues = new HashSet<String>();
        this.emptyValue = new NominalValue(this, null);
        this.ct = gSCategoricTemplate;
    }

    @Override
    public GSEnumDataType getType() {
        return GSEnumDataType.Nominal;
    }

    @Override
    public Class<NominalValue> getTypeClass() {
        return NominalValue.class;
    }

    @Override
    public boolean isValidCandidate(String string) {
        return true;
    }

    @Override
    public NominalValue proposeValue(String string) {
        return new NominalValue(this, string);
    }

    @Override
    public NominalValue getInstanceValue(String string) {
        return new NominalValue(this, this.ct.getFormatedString(string));
    }

    @Override
    public NominalValue addValue(String string) throws IllegalArgumentException {
        if (this.excludedValues.contains(string)) {
            return this.emptyValue;
        }
        String string2 = this.ct.getFormatedString(string);
        NominalValue nominalValue = this.values.get(string2);
        if (nominalValue == null) {
            nominalValue = new NominalValue(this, string2);
            this.values.put(string2, nominalValue);
        }
        return nominalValue;
    }

    @Override
    public Set<NominalValue> getValues() {
        return new HashSet<NominalValue>(this.values.values());
    }

    @Override
    public NominalValue getValue(String string) throws NullPointerException {
        NominalValue nominalValue = this.values.get(string);
        if (nominalValue == null) {
            nominalValue = this.values.get(this.ct.getFormatedString(string));
        }
        if (nominalValue == null) {
            throw new NullPointerException("The string value " + string + " is not comprise in the value space " + this.toString());
        }
        return nominalValue;
    }

    @Override
    public boolean contains(IValue iValue) {
        if (iValue == null || !iValue.getClass().equals(NominalValue.class)) {
            return false;
        }
        return this.values.containsValue(iValue);
    }

    @Override
    public NominalValue getEmptyValue() {
        return this.emptyValue;
    }

    @Override
    public void setEmptyValue(String string) {
        String string2 = this.ct.getFormatedString(string);
        NominalValue nominalValue = this.values.get(string2);
        if (nominalValue == null) {
            nominalValue = new NominalValue(this, string2);
        }
        this.emptyValue = nominalValue;
    }

    @Override
    public void addExceludedValue(String string) {
        this.excludedValues.add(string);
    }

    @Override
    public IAttribute<NominalValue> getAttribute() {
        return this.attribute;
    }

    public GSCategoricTemplate getCategoricTemplate() {
        return this.ct;
    }

    @Override
    public IValueSpace<NominalValue> clone(IAttribute<NominalValue> iAttribute) {
        return new NominalSpace(iAttribute, this.getCategoricTemplate());
    }

    public int hashCode() {
        int n = this.getHashCode();
        return 31 * n + this.ct.hashCode();
    }

    public boolean equals(Object object) {
        NominalSpace nominalSpace;
        return object instanceof NominalSpace && this.isEqual(nominalSpace = (NominalSpace)object) && Objects.equals(this.ct, nominalSpace.getCategoricTemplate());
    }

    public String toString() {
        return this.toPrettyString();
    }

    @Override
    public boolean contains(String string) {
        return this.values.containsKey(string);
    }

    @Override
    public boolean containsAllLabels(Collection<String> collection) {
        return this.values.values().stream().allMatch(nominalValue -> collection.contains(nominalValue.getStringValue()));
    }
}

