/*
 * Decompiled with CFR 0.152.
 */
package core.util;

import gama.dev.DEBUG;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.text.similarity.LevenshteinDistance;

public class GSDisplayUtil {
    private GSDisplayUtil() {
    }

    public static String prettyPrint(Collection<?> collection, String string) {
        return GSDisplayUtil.prettyPrint(collection, string, 0);
    }

    public static String prettyPrint(Collection<?> collection, String string, int n) {
        Class<?> clazz = collection.getClass();
        n = n <= 0 ? collection.size() : n;
        return switch (clazz.getCanonicalName()) {
            case "List" -> GSDisplayUtil.prettyPrintList((List)collection, string, n);
            case "Map" -> GSDisplayUtil.prettyPrintMap((Map)((Object)collection), string, n);
            case "Set" -> GSDisplayUtil.prettyPrintSet((Set)collection, string, n);
            default -> collection.stream().limit(n).map(Object::toString).collect(Collectors.joining(string));
        };
    }

    public static String prettyPrintList(List<?> list, String string, int n) {
        return list.stream().limit(n).map(Object::toString).collect(Collectors.joining(string));
    }

    public static String prettyPrintMap(Map<?, ?> map, String string, int n) {
        return map.entrySet().stream().limit(n).map(entry -> "\"" + entry.getKey().toString() + "=" + entry.getValue().toString() + "\"").collect(Collectors.joining(string));
    }

    public static String prettyPrintSet(Set<?> set, String string, int n) {
        return set.stream().limit(n).map(Object::toString).collect(Collectors.joining(string));
    }

    public static void println(Object object, Object object2) {
        if (object2 == null) {
            GSDisplayUtil.println(object, null);
        } else {
            GSDisplayUtil.println(object, object2.toString());
        }
    }

    public static void println(Object object, Object object2, Object ... objectArray) {
        if (object2 == null) {
            GSDisplayUtil.println(object, null, objectArray);
        } else {
            GSDisplayUtil.println(object, object2.toString(), objectArray);
        }
    }

    public static void println(Object object, String string) {
        GSDisplayUtil.println(object.getClass().getSimpleName(), string);
    }

    public static void println(Object object, String string, Object ... objectArray) {
        GSDisplayUtil.println(object.getClass().getSimpleName(), string, objectArray);
    }

    public static void println(Class<?> clazz, String string, String string2) {
        Method method2 = Collections.min(Arrays.asList(clazz.getDeclaredMethods()), Comparator.comparing(method -> LevenshteinDistance.getDefaultInstance().apply((CharSequence)method.getName(), (CharSequence)string)));
        GSDisplayUtil.println(clazz.getSimpleName() + " : " + method2.getName(), string2);
    }

    public static void println(Class<?> clazz, String string, String string2, Object ... objectArray) {
        Method method2 = Collections.min(Arrays.asList(clazz.getDeclaredMethods()), Comparator.comparing(method -> LevenshteinDistance.getDefaultInstance().apply((CharSequence)method.getName(), (CharSequence)string)));
        GSDisplayUtil.println(clazz.getSimpleName() + " : " + method2.getName(), string2, objectArray);
    }

    public static void println(String string, String string2) {
        DEBUG.OUT((Object)("[" + string + "] : " + string2));
    }

    public static void println(String string, String string2, Object ... objectArray) {
        StringBuilder stringBuilder = new StringBuilder();
        String[] stringArray = string2.split("{}");
        int n = 0;
        while (n < stringArray.length) {
            String string3 = "";
            try {
                string3 = objectArray[n].toString();
            }
            catch (NullPointerException nullPointerException) {}
            stringBuilder.append(stringArray).append(string3);
            ++n;
        }
        GSDisplayUtil.println(string, stringBuilder.toString());
    }
}

