/*
 * Decompiled with CFR 0.152.
 */
package core.util.random;

import core.util.data.GSDataParser;
import core.util.data.GSEnumDataType;
import core.util.exception.GenstarException;
import core.util.random.GenstarRandom;
import java.util.Collection;
import java.util.List;
import java.util.Random;
import java.util.Set;

public class GenstarRandomUtils {
    private GenstarRandomUtils() {
    }

    public static <T> T oneOf(List<T> list) {
        if (list.isEmpty()) {
            throw new IllegalArgumentException("cannot take one value out of an empty list");
        }
        if (list.size() == 1) {
            return list.get(0);
        }
        return list.get(GenstarRandom.getInstance().nextInt(list.size()));
    }

    public static <T> T oneOf(Set<T> set) {
        if (set.isEmpty()) {
            throw new IllegalArgumentException("cannot take one value out of an empty set");
        }
        if (set.size() == 1) {
            return set.iterator().next();
        }
        return (T)set.stream().skip(GenstarRandom.getInstance().nextInt(set.size())).findFirst().orElseThrow(AssertionError::new);
    }

    public static <T> T oneOf(Collection<T> collection) {
        if (collection.isEmpty()) {
            throw new IllegalArgumentException("cannot take one value out of an empty list");
        }
        if (collection.size() == 1) {
            return collection.iterator().next();
        }
        return collection.stream().skip(GenstarRandom.getInstance().nextInt(collection.size())).findFirst().orElseThrow(AssertionError::new);
    }

    public static boolean flip(double d) {
        return GenstarRandom.getInstance().nextDouble() < d;
    }

    public static Number rnd(Number number, Number number2) {
        Random random = GenstarRandom.getInstance();
        GSDataParser gSDataParser = new GSDataParser();
        GSEnumDataType gSEnumDataType = gSDataParser.getValueType(number.toString());
        return switch (gSEnumDataType) {
            case GSEnumDataType.Continue -> random.nextDouble() * (number2.doubleValue() - number.doubleValue()) + number.doubleValue();
            case GSEnumDataType.Integer -> random.nextInt(number2.intValue() - number.intValue()) + number.intValue();
            default -> throw new GenstarException();
        };
    }
}

