/*
 * Decompiled with CFR 0.152.
 */
package core.util.stats;

import core.util.stats.GSEnumStats;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.DoubleSummaryStatistics;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.stream.DoubleStream;
import java.util.stream.IntStream;
import java.util.stream.Stream;

public class GSBasicStats<T extends Number> {
    private EnumMap<GSEnumStats, Double> map;
    private double floatPrecision = 1.0E-4;
    private int nbNoData = 0;

    public GSBasicStats(List<T> list) {
        ArrayList<T> arrayList = new ArrayList<T>(list);
        this.map = new EnumMap(GSEnumStats.class);
        DoubleSummaryStatistics doubleSummaryStatistics = list.parallelStream().mapToDouble(Number::doubleValue).collect(DoubleSummaryStatistics::new, DoubleSummaryStatistics::accept, DoubleSummaryStatistics::combine);
        this.map.put(GSEnumStats.av, (double)Math.round(doubleSummaryStatistics.getAverage() / this.floatPrecision) * this.floatPrecision);
        this.map.put(GSEnumStats.min, (double)Math.round(doubleSummaryStatistics.getMin() / this.floatPrecision) * this.floatPrecision);
        this.map.put(GSEnumStats.max, (double)Math.round(doubleSummaryStatistics.getMax() / this.floatPrecision) * this.floatPrecision);
        this.map.put(GSEnumStats.sum, (double)Math.round(doubleSummaryStatistics.getSum() / this.floatPrecision) * this.floatPrecision);
        arrayList.sort(Comparator.comparing(Number::doubleValue));
        this.map.put(GSEnumStats.med, (double)Math.round(((Number)list.get(list.size() % 2 == 0 ? list.size() / 2 : (list.size() + 1) / 2)).doubleValue() / this.floatPrecision) * this.floatPrecision);
        int n = arrayList.size() % 5;
        int n2 = arrayList.size() % 5 == 0 ? arrayList.size() / 5 : (arrayList.size() - n) / 5;
        this.map.put(GSEnumStats.q_one, (double)Math.round(((Number)arrayList.get(n2)).doubleValue() / this.floatPrecision) * this.floatPrecision);
        this.map.put(GSEnumStats.q_two, (double)Math.round(((Number)arrayList.get(n2 * 2)).doubleValue() / this.floatPrecision) * this.floatPrecision);
        this.map.put(GSEnumStats.q_three, (double)Math.round(((Number)arrayList.get(n2 * 3)).doubleValue() / this.floatPrecision) * this.floatPrecision);
        this.map.put(GSEnumStats.q_four, (double)Math.round(((Number)arrayList.get(n2 * 4)).doubleValue() / this.floatPrecision) * this.floatPrecision);
    }

    public GSBasicStats(List<T> list, List<T> list2) {
        this(list.parallelStream().filter(number -> !list2.contains(number)).toList());
        this.nbNoData = (int)list.parallelStream().filter(list2::contains).count();
    }

    public void setFloatingPrecision(double d) {
        this.floatPrecision = d;
    }

    public double[] getStat(GSEnumStats ... gSEnumStatsArray) {
        double[] dArray = new double[gSEnumStatsArray.length];
        IntStream.range(0, gSEnumStatsArray.length).forEach(n -> {
            double d = this.map.get((Object)gSEnumStatsArray[n]);
        });
        return dArray;
    }

    public String getStatReport() {
        StringBuilder stringBuilder = new StringBuilder();
        StringBuilder stringBuilder2 = new StringBuilder();
        for (Map.Entry<GSEnumStats, Double> entry : this.map.entrySet()) {
            if (!stringBuilder.isEmpty()) {
                stringBuilder.append("\t");
            }
            stringBuilder.append((Object)entry.getKey());
            if (!stringBuilder2.isEmpty()) {
                stringBuilder2.append("\t");
            }
            stringBuilder2.append(entry.getValue());
        }
        return String.valueOf(stringBuilder) + "\n" + String.valueOf(stringBuilder2);
    }

    public long getNoDataCount() {
        return this.nbNoData;
    }

    public static List<Integer> transpose(int[] nArray) {
        return IntStream.of(nArray).boxed().toList();
    }

    public static List<Double> transpose(double[] dArray) {
        return DoubleStream.of(dArray).boxed().toList();
    }

    public static List<Double> transpose(float[] fArray) {
        return IntStream.range(0, fArray.length).mapToDouble(n -> fArray[n]).boxed().toList();
    }

    public static List<Integer> transpose(int[][] nArray) {
        return ((Stream)Arrays.stream(nArray).parallel()).flatMapToInt(Arrays::stream).boxed().toList();
    }

    public static List<Double> transpose(double[][] dArray) {
        return ((Stream)Arrays.stream(dArray).parallel()).flatMapToDouble(Arrays::stream).boxed().toList();
    }

    public static List<Double> transpose(float[][] fArray) {
        ArrayList<Double> arrayList = new ArrayList<Double>();
        int n = 0;
        while (n < fArray.length) {
            int n3 = n++;
            arrayList.addAll(IntStream.range(0, fArray[n3].length).parallel().mapToDouble(n2 -> fArray[n3][n2]).boxed().toList());
        }
        return arrayList;
    }
}

