/*
 * Decompiled with CFR 0.152.
 */
package espacedev.gaml.extensions.genstar.type;

import core.util.random.GenstarRandom;
import gama.annotations.precompiler.GamlAnnotations;
import gama.core.common.interfaces.IValue;
import gama.core.runtime.IScope;
import gama.core.util.file.json.Json;
import gama.core.util.file.json.JsonValue;
import gama.gaml.types.IType;
import java.util.Random;

@GamlAnnotations.vars(value={@GamlAnnotations.variable(name="min_value", type=2, doc={@GamlAnnotations.doc(value="The lower bound of the range.")}), @GamlAnnotations.variable(name="max_value", type=2, doc={@GamlAnnotations.doc(value="The upper bound of the range.")})})
public class GamaRange
implements IValue {
    Number min;
    Number max;

    public GamaRange(Number number, Number number2) {
        this.min = number;
        this.max = number2;
    }

    @GamlAnnotations.getter(value="min_value")
    public Number getMin() {
        return this.min.doubleValue();
    }

    @GamlAnnotations.getter(value="max_value")
    public Number getMax() {
        return this.max.doubleValue();
    }

    public JsonValue serializeToJson(Json json) {
        return null;
    }

    public String stringValue(IScope iScope) {
        return this.serializeToJson(Json.getNew()).asString();
    }

    public String toString() {
        return String.valueOf(this.min) + "->" + String.valueOf(this.max);
    }

    public IValue copy(IScope iScope) {
        return new GamaRange(this.min, this.max);
    }

    public Object cast(IScope iScope, IType iType) {
        Object object;
        if (iType == null) {
            object = this;
        } else {
            switch (iType.id()) {
                case 1: {
                    object = this.intValue();
                    break;
                }
                case 2: {
                    object = this.floatValue();
                    break;
                }
                case 4: {
                    object = this.stringValue(iScope);
                    break;
                }
                default: {
                    object = this;
                }
            }
        }
        return object;
    }

    private double floatValue() {
        Random random = GenstarRandom.getInstance();
        return (this.max.doubleValue() - this.min.doubleValue() + 1.0) * random.nextDouble() + this.min.doubleValue();
    }

    private int intValue() {
        return (int)this.floatValue();
    }
}

