/*
 * Decompiled with CFR 0.152.
 */
package gospl;

import core.metamodel.IPopulation;
import core.metamodel.attribute.Attribute;
import core.metamodel.entity.ADemoEntity;
import core.metamodel.entity.EntityUniqueId;
import core.metamodel.value.IValue;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;

public class GosplPopulation
implements IPopulation<ADemoEntity, Attribute<? extends IValue>> {
    private final Collection<ADemoEntity> population;
    private Set<Attribute<? extends IValue>> attributes = null;

    public GosplPopulation() {
        this.population = new HashSet<ADemoEntity>();
    }

    public GosplPopulation(GosplPopulation gosplPopulation) {
        this.population = new HashSet<ADemoEntity>();
        for (ADemoEntity aDemoEntity : gosplPopulation.population) {
            ADemoEntity aDemoEntity2 = aDemoEntity.clone();
            this.population.add(aDemoEntity2);
        }
        this.attributes = new HashSet<Attribute<? extends IValue>>(gosplPopulation.getPopulationAttributes());
    }

    public GosplPopulation(Collection<ADemoEntity> collection) {
        this.population = collection.isEmpty() ? new HashSet<ADemoEntity>() : new HashSet<ADemoEntity>(collection);
    }

    protected final void _checkEntityAttributes(ADemoEntity aDemoEntity) throws IllegalArgumentException {
        if (this.attributes != null && !aDemoEntity.getAttributes().equals(this.attributes)) {
            throw new IllegalArgumentException("the entity should contain attributes " + this.attributes.toString());
        }
    }

    public void setExpectedAttributes(Collection<Attribute<IValue>> collection) {
        this.attributes = new HashSet<Attribute<IValue>>(collection);
        for (ADemoEntity aDemoEntity : this.population) {
            this._checkEntityAttributes(aDemoEntity);
        }
    }

    @Override
    public int size() {
        return this.population.size();
    }

    @Override
    public boolean isEmpty() {
        return this.population.isEmpty();
    }

    @Override
    public boolean contains(Object object) {
        return this.population.contains(object);
    }

    @Override
    public Iterator<ADemoEntity> iterator() {
        return this.population.iterator();
    }

    @Override
    public Object[] toArray() {
        return this.population.toArray();
    }

    @Override
    public <T> T[] toArray(T[] TArray) {
        return this.population.toArray(TArray);
    }

    @Override
    public boolean add(ADemoEntity aDemoEntity) {
        if (this.attributes != null) {
            this._checkEntityAttributes(aDemoEntity);
        }
        if (this.population.add(aDemoEntity)) {
            aDemoEntity._setEntityId(EntityUniqueId.createNextId(this, aDemoEntity.getEntityType()));
            return true;
        }
        return false;
    }

    @Override
    public boolean remove(Object object) {
        return this.population.remove(object);
    }

    @Override
    public boolean containsAll(Collection<?> collection) {
        return this.population.containsAll(collection);
    }

    @Override
    public boolean addAll(Collection<? extends ADemoEntity> collection) {
        boolean bl = false;
        for (ADemoEntity aDemoEntity : collection) {
            boolean bl2 = bl = this.add(aDemoEntity) || bl;
        }
        return bl;
    }

    @Override
    public boolean removeAll(Collection<?> collection) {
        return this.population.removeAll(collection);
    }

    @Override
    public boolean retainAll(Collection<?> collection) {
        return this.population.retainAll(collection);
    }

    @Override
    public void clear() {
        this.population.clear();
    }

    @Override
    public GosplPopulation clone() {
        return new GosplPopulation(this.population);
    }

    @Override
    public Set<Attribute<? extends IValue>> getPopulationAttributes() {
        if (this.attributes == null) {
            this.attributes = this.population.stream().flatMap(aDemoEntity -> aDemoEntity.getAttributes().stream()).collect(Collectors.toSet());
        }
        return Collections.unmodifiableSet(this.attributes);
    }

    @Override
    public boolean isAllPopulationOfType(String string) {
        for (ADemoEntity aDemoEntity : this.population) {
            if (Objects.equals(string, aDemoEntity.getEntityType())) continue;
            return false;
        }
        return true;
    }

    @Override
    public Attribute<? extends IValue> getPopulationAttributeNamed(String string) {
        this.attributes = this.getPopulationAttributes();
        for (Attribute<? extends IValue> attribute : this.attributes) {
            if (!attribute.getAttributeName().equals(string)) continue;
            return attribute;
        }
        return null;
    }
}

