/*
 * Decompiled with CFR 0.152.
 */
package gospl.algo;

import java.util.Arrays;
import java.util.Set;
import java.util.stream.Collectors;

public interface IGosplConcept {

    public static enum EGosplAlgorithm {
        HS("Hierarchical Sampling", EGosplGenerationConcept.SR),
        DS("Direct Sampling", EGosplGenerationConcept.SR),
        SA("Simulated Annealing", EGosplGenerationConcept.CO),
        TABU("Tabu Search", EGosplGenerationConcept.CO),
        RS("Random Search (Hill Climbing)", EGosplGenerationConcept.CO),
        US("Uniform Sampling", EGosplGenerationConcept.CO);

        public String name;
        public EGosplGenerationConcept concept;

        private EGosplAlgorithm(String string2, EGosplGenerationConcept eGosplGenerationConcept) {
            this.name = string2;
            this.concept = eGosplGenerationConcept;
        }

        public static Set<EGosplAlgorithm> getConceptAvailableAlgorithms(EGosplGenerationConcept eGosplGenerationConcept) {
            return Arrays.asList(EGosplAlgorithm.values()).stream().filter(eGosplAlgorithm -> eGosplAlgorithm.concept.equals((Object)eGosplGenerationConcept)).collect(Collectors.toSet());
        }
    }

    public static enum EGosplFittingProcedure {
        IPF("Factor estimation model"),
        MCMC("Metropolis-Hastings"),
        BNSL("Structure learning model");

        public String detail;

        private EGosplFittingProcedure(String string2) {
            this.detail = string2;
        }
    }

    public static enum EGosplGenerationConcept {
        CO("Draw individual entity from a sample to generate a synthetic population"),
        SR("Sample individual entity from a distribution of attribute to generate a synthetic population"),
        MULTILEVEL("Use a combination of methods to generate a multi-level synthetic population"),
        MIXTURE("Update individual entity to enhance a synthetic population");

        private final String description;

        private EGosplGenerationConcept(String string2) {
            this.description = string2;
        }
    }
}

