/*
 * Decompiled with CFR 0.152.
 */
package gospl.algo.co.hillclimbing;

import core.util.GSPerformanceUtil;
import gospl.GosplPopulation;
import gospl.algo.co.metamodel.AOptimizationAlgorithm;
import gospl.algo.co.metamodel.neighbor.IPopulationNeighborSearch;
import gospl.algo.co.metamodel.neighbor.PopulationEntityNeighborSearch;
import gospl.algo.co.metamodel.solution.ISyntheticPopulationSolution;

public class HillClimbing
extends AOptimizationAlgorithm<GosplPopulation> {
    private final int nbIteration;

    public HillClimbing(double d, int n) {
        this(new PopulationEntityNeighborSearch(), d, n);
    }

    public HillClimbing(IPopulationNeighborSearch<GosplPopulation, ?> iPopulationNeighborSearch, double d, int n) {
        super(iPopulationNeighborSearch, d);
        this.nbIteration = n;
    }

    @Override
    public ISyntheticPopulationSolution<GosplPopulation> run(ISyntheticPopulationSolution<GosplPopulation> iSyntheticPopulationSolution) {
        GSPerformanceUtil gSPerformanceUtil = new GSPerformanceUtil("Start HIll Climbing Algorithm\nPopulation size = " + iSyntheticPopulationSolution.getSolution().size() + "\nSample size = " + super.getSample().size() + "\nMax iteration = " + this.nbIteration + "\nNeighbor search = " + super.getNeighborSearchAlgorithm().getClass().getSimpleName() + "\nSolution = " + iSyntheticPopulationSolution.getClass().getSimpleName(), GSPerformanceUtil.Level.DEBUG);
        gSPerformanceUtil.setObjectif(this.nbIteration);
        ISyntheticPopulationSolution<GosplPopulation> iSyntheticPopulationSolution2 = iSyntheticPopulationSolution;
        double d = iSyntheticPopulationSolution2.getFitness(this.getObjectives());
        super.getNeighborSearchAlgorithm().updatePredicates(iSyntheticPopulationSolution.getSolution());
        int n = 0;
        int n2 = this.computeBuffer(d, iSyntheticPopulationSolution);
        while (n++ < this.nbIteration && d > this.getFitnessThreshold()) {
            ISyntheticPopulationSolution<GosplPopulation> iSyntheticPopulationSolution3 = iSyntheticPopulationSolution2.getRandomNeighbor(super.getNeighborSearchAlgorithm(), n2);
            double d2 = iSyntheticPopulationSolution3.getFitness(this.getObjectives());
            if (d2 < d) {
                iSyntheticPopulationSolution2 = iSyntheticPopulationSolution3;
                d = d2;
                super.getNeighborSearchAlgorithm().updatePredicates(iSyntheticPopulationSolution2.getSolution());
                n2 = this.computeBuffer(d, iSyntheticPopulationSolution2);
            }
            if (n % (this.nbIteration / 10) != 0) continue;
            gSPerformanceUtil.sysoStempPerformance((double)n / gSPerformanceUtil.getObjectif(), (Object)this);
            gSPerformanceUtil.sysoStempMessage("Best fitness = " + d + " (buffer = " + n2 + ") | Pop size = " + iSyntheticPopulationSolution2.getSolution().size());
        }
        return iSyntheticPopulationSolution2;
    }
}

