/*
 * Decompiled with CFR 0.152.
 */
package gospl.algo.co.metamodel;

import core.metamodel.IPopulation;
import core.metamodel.attribute.Attribute;
import core.metamodel.entity.ADemoEntity;
import core.metamodel.value.IValue;
import gospl.algo.co.metamodel.IOptimizationAlgorithm;
import gospl.algo.co.metamodel.neighbor.IPopulationNeighborSearch;
import gospl.algo.co.metamodel.solution.ISyntheticPopulationSolution;
import gospl.distribution.matrix.INDimensionalMatrix;
import java.util.HashSet;
import java.util.Set;

public abstract class AOptimizationAlgorithm<Population extends IPopulation<ADemoEntity, Attribute<? extends IValue>>>
implements IOptimizationAlgorithm<Population, ISyntheticPopulationSolution<Population>> {
    private final Set<INDimensionalMatrix<Attribute<? extends IValue>, IValue, Integer>> objectives;
    private IPopulationNeighborSearch<Population, ?> neighborSearch;
    private IPopulation<ADemoEntity, Attribute<? extends IValue>> sample;
    private double fitnessThreshold;
    private double k_neighborRatio = Math.pow(10.0, -3.0);

    protected AOptimizationAlgorithm(IPopulationNeighborSearch<Population, ?> iPopulationNeighborSearch, double d) {
        this.neighborSearch = iPopulationNeighborSearch;
        this.objectives = new HashSet<INDimensionalMatrix<Attribute<? extends IValue>, IValue, Integer>>();
        this.setFitnessThreshold(d);
    }

    protected AOptimizationAlgorithm(IPopulationNeighborSearch<Population, ?> iPopulationNeighborSearch, Population Population, double d) {
        this.neighborSearch = iPopulationNeighborSearch;
        this.setSample(Population);
        this.objectives = new HashSet<INDimensionalMatrix<Attribute<? extends IValue>, IValue, Integer>>();
        this.setFitnessThreshold(d);
    }

    @Override
    public Set<INDimensionalMatrix<Attribute<? extends IValue>, IValue, Integer>> getObjectives() {
        return this.objectives;
    }

    @Override
    public void addObjectives(INDimensionalMatrix<Attribute<? extends IValue>, IValue, Integer> iNDimensionalMatrix) {
        this.objectives.add(iNDimensionalMatrix);
    }

    @Override
    public IPopulation<ADemoEntity, Attribute<? extends IValue>> getSample() {
        return this.sample;
    }

    @Override
    public void setSample(Population Population) {
        this.sample = Population;
        this.neighborSearch.setSample(Population);
    }

    @Override
    public IPopulationNeighborSearch<Population, ?> getNeighborSearchAlgorithm() {
        return this.neighborSearch;
    }

    @Override
    public void setNeighborSearch(IPopulationNeighborSearch<Population, ?> iPopulationNeighborSearch) {
        this.neighborSearch = iPopulationNeighborSearch;
    }

    @Override
    public double getFitnessThreshold() {
        return this.fitnessThreshold;
    }

    @Override
    public void setFitnessThreshold(double d) {
        this.fitnessThreshold = d;
    }

    @Override
    public double getKNeighborRatio() {
        return this.k_neighborRatio;
    }

    @Override
    public void setKNeighborRatio(double d) {
        this.k_neighborRatio = d;
    }

    public int computeBuffer(double d, ISyntheticPopulationSolution<Population> iSyntheticPopulationSolution) {
        return (int)Math.round((double)iSyntheticPopulationSolution.getSolution().size() * this.k_neighborRatio * Math.log(1.0 + d * this.k_neighborRatio));
    }
}

