/*
 * Decompiled with CFR 0.152.
 */
package gospl.algo.co.metamodel.neighbor;

import core.metamodel.attribute.Attribute;
import core.metamodel.entity.ADemoEntity;
import core.metamodel.value.IValue;
import core.util.GSPerformanceUtil;
import core.util.random.GenstarRandomUtils;
import gospl.GosplMultitypePopulation;
import gospl.GosplPopulation;
import gospl.algo.co.metamodel.neighbor.IPopulationNeighborSearch;
import gospl.algo.co.metamodel.neighbor.PopulationRandomNeighborSearch;
import gospl.distribution.GosplNDimensionalMatrixFactory;
import gospl.distribution.matrix.INDimensionalMatrix;
import gospl.validation.GosplIndicatorFactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

public class MultiPopulationNeighborSearch
implements IPopulationNeighborSearch<GosplMultitypePopulation<ADemoEntity>, INDimensionalMatrix<Attribute<? extends IValue>, IValue, Integer>> {
    private final IPopulationNeighborSearch<GosplPopulation, INDimensionalMatrix<Attribute<? extends IValue>, IValue, Integer>> search;
    private Map<Integer, INDimensionalMatrix<Attribute<? extends IValue>, IValue, Integer>> predicates;
    private Map<Integer, INDimensionalMatrix<Attribute<? extends IValue>, IValue, Integer>> objectives;
    private static final int maxSizeGrowthFactor = 3;
    private GosplMultitypePopulation<ADemoEntity> sample;

    public MultiPopulationNeighborSearch() {
        this.search = new PopulationRandomNeighborSearch<INDimensionalMatrix<Attribute<? extends IValue>, IValue, Integer>>();
    }

    public MultiPopulationNeighborSearch(IPopulationNeighborSearch<GosplPopulation, INDimensionalMatrix<Attribute<? extends IValue>, IValue, Integer>> iPopulationNeighborSearch) {
        this.search = iPopulationNeighborSearch;
    }

    @Override
    public Map<ADemoEntity, ADemoEntity> getPairwisedEntities(GosplMultitypePopulation<ADemoEntity> gosplMultitypePopulation, INDimensionalMatrix<Attribute<? extends IValue>, IValue, Integer> iNDimensionalMatrix, int n) {
        return this.getPairwisedEntities(gosplMultitypePopulation, iNDimensionalMatrix, n, false);
    }

    @Override
    public Map<ADemoEntity, ADemoEntity> getPairwisedEntities(GosplMultitypePopulation<ADemoEntity> gosplMultitypePopulation, int n, boolean bl) {
        return this.getPairwisedEntities(gosplMultitypePopulation, GenstarRandomUtils.oneOf(this.getPredicates()), n, bl);
    }

    @Override
    public Map<ADemoEntity, ADemoEntity> getPairwisedEntities(GosplMultitypePopulation<ADemoEntity> gosplMultitypePopulation, INDimensionalMatrix<Attribute<? extends IValue>, IValue, Integer> iNDimensionalMatrix, int n, boolean bl) {
        return this.getPairwisedEntities(gosplMultitypePopulation, iNDimensionalMatrix, Collections.max(this.sample.getEntityLevel()), n, bl);
    }

    public Map<ADemoEntity, ADemoEntity> getPairwisedEntities(GosplMultitypePopulation<ADemoEntity> gosplMultitypePopulation, INDimensionalMatrix<Attribute<? extends IValue>, IValue, Integer> iNDimensionalMatrix, int n, int n3, boolean bl) {
        GSPerformanceUtil gSPerformanceUtil = new GSPerformanceUtil(this.getClass().getCanonicalName() + "#getPairwisedEntities", GSPerformanceUtil.Level.TRACE);
        GosplPopulation gosplPopulation = new GosplPopulation(gosplMultitypePopulation.getSubPopulation(n));
        GosplPopulation gosplPopulation2 = new GosplPopulation(this.sample.getSubPopulation(n));
        this.search.setSample(gosplPopulation2);
        if (gosplPopulation2.stream().anyMatch(aDemoEntity -> aDemoEntity.getEntityId() == null || aDemoEntity.getEntityId().isEmpty())) {
            throw new IllegalStateException("Entities to swap with from original sample should have ID's");
        }
        Map<ADemoEntity, ADemoEntity> map = this.search.getPairwisedEntities(gosplPopulation, iNDimensionalMatrix, n3, bl);
        gSPerformanceUtil.sysoStempPerformance("Propose swaps (" + map.size() + "):\n".concat(map.entrySet().stream().limit(10L).map(Object::toString).collect(Collectors.joining("\n"))), this.getClass());
        List<Integer> list = gosplMultitypePopulation.getEntityLevel().stream().filter(n2 -> n2 < n).toList();
        if (list.size() > 1) {
            throw new UnsupportedOperationException("Cannot yet operate combinatorial optimization on synthetic population with more than 2 layeres");
        }
        List<Integer> list2 = gosplMultitypePopulation.getEntityLevel().stream().filter(n2 -> n2 > n).toList();
        if (list2.size() > 1) {
            throw new UnsupportedOperationException("Cannot yet operate combinatorial optimization on synthetic population with entities encapsulated in more than 1 group (e.g. individuals > households > classes");
        }
        if (list2.size() == 1) {
            HashSet hashSet = new HashSet();
            HashSet hashSet2 = new HashSet();
            gSPerformanceUtil.sysoStempMessage("Trying to build upper level entities from child drawn");
            int n4 = 1;
            do {
                Map<ADemoEntity, ADemoEntity> map2 = n4++ == 1 ? map : this.search.getPairwisedEntities(gosplPopulation, iNDimensionalMatrix, n3 * n4++, bl);
                Map map3 = map2.keySet().stream().collect(Collectors.groupingBy(aDemoEntity -> (ADemoEntity)aDemoEntity.getParent(), Collectors.toSet()));
                Map map4 = map2.values().stream().collect(Collectors.groupingBy(aDemoEntity -> (ADemoEntity)aDemoEntity.getParent(), Collectors.toSet()));
                hashSet.addAll(map3.keySet().stream().filter(aDemoEntity -> ((Set)map3.get(aDemoEntity)).containsAll(aDemoEntity.getChildren()) && !map.containsKey(aDemoEntity)).collect(Collectors.toSet()));
                hashSet2.addAll(map4.keySet().stream().filter(aDemoEntity -> ((Set)map4.get(aDemoEntity)).containsAll(aDemoEntity.getChildren()) && !map.containsValue(aDemoEntity)).collect(Collectors.toSet()));
                int n5 = n3 - map.size();
                if (hashSet.isEmpty() || hashSet2.isEmpty()) continue;
                n5 = IntStream.of(n5, hashSet.size() > hashSet2.size() ? hashSet2.size() : hashSet.size()).min().getAsInt();
                for (ADemoEntity aDemoEntity2 : hashSet.stream().limit(n5).collect(Collectors.toSet())) {
                    ADemoEntity aDemoEntity3 = (ADemoEntity)GenstarRandomUtils.oneOf(hashSet2);
                    map.put(aDemoEntity2, aDemoEntity3);
                    hashSet2.remove(aDemoEntity3);
                }
            } while (map.size() >= n3 || n4 == 3);
        }
        return map;
    }

    @Override
    public Collection<INDimensionalMatrix<Attribute<? extends IValue>, IValue, Integer>> getPredicates() {
        return Collections.unmodifiableCollection(this.predicates.values());
    }

    @Override
    public void setPredicates(Collection<INDimensionalMatrix<Attribute<? extends IValue>, IValue, Integer>> collection) {
        if (collection.isEmpty()) {
            throw new IllegalArgumentException("Predicat cannot be empty");
        }
        if (this.predicates == null) {
            this.predicates = new HashMap<Integer, INDimensionalMatrix<Attribute<? extends IValue>, IValue, Integer>>();
        }
        Iterator<INDimensionalMatrix<Attribute<? extends IValue>, IValue, Integer>> iterator = collection.iterator();
        int n = 0;
        while (iterator.hasNext()) {
            this.predicates.put(n++, iterator.next());
        }
    }

    @Override
    public void updatePredicates(GosplMultitypePopulation<ADemoEntity> gosplMultitypePopulation) {
        for (Integer n : new ArrayList<Integer>(this.objectives.keySet())) {
            HashSet<INDimensionalMatrix<Attribute<? extends IValue>, IValue, Integer>> hashSet = new HashSet<INDimensionalMatrix<Attribute<? extends IValue>, IValue, Integer>>(Arrays.asList(this.objectives.get(n)));
            this.setPredicates((Collection<INDimensionalMatrix<Attribute<? extends IValue>, IValue, Integer>>)Collections.singleton(GosplIndicatorFactory.getFactory().getAbsoluteErrors(gosplMultitypePopulation.getSubPopulation(n), this.predicates.get(n), hashSet)));
        }
    }

    @Override
    public void setSample(GosplMultitypePopulation<ADemoEntity> gosplMultitypePopulation) {
        this.sample = gosplMultitypePopulation;
    }

    public void addObjectives(INDimensionalMatrix<Attribute<? extends IValue>, IValue, Integer> iNDimensionalMatrix, int n) {
        if (this.objectives == null) {
            this.objectives = new HashMap<Integer, INDimensionalMatrix<Attribute<? extends IValue>, IValue, Integer>>();
        }
        this.objectives.put(n, iNDimensionalMatrix);
        if (this.predicates == null) {
            this.predicates = new HashMap<Integer, INDimensionalMatrix<Attribute<? extends IValue>, IValue, Integer>>();
        }
        this.predicates.put(n, GosplNDimensionalMatrixFactory.getFactory().createEmtpyContingencies(this.objectives.get(n).getDimensions(), true));
    }
}

