/*
 * Decompiled with CFR 0.152.
 */
package gospl.algo.ipf.margin;

import core.metamodel.attribute.Attribute;
import core.metamodel.value.IValue;
import core.util.GSPerformanceUtil;
import gama.dev.DEBUG;
import gospl.algo.ipf.margin.Margin;
import gospl.algo.ipf.margin.MarginDescriptor;
import gospl.distribution.matrix.AFullNDimensionalMatrix;
import gospl.distribution.matrix.INDimensionalMatrix;
import gospl.distribution.matrix.control.AControl;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class MarginalsIPFBuilder<T extends Number> {
    public Collection<Margin<T>> buildCompliantMarginals(INDimensionalMatrix<Attribute<? extends IValue>, IValue, T> iNDimensionalMatrix, AFullNDimensionalMatrix<T> aFullNDimensionalMatrix) {
        Object object2 = new StringBuilder();
        for (Attribute<IValue> object3 : iNDimensionalMatrix.getDimensions()) {
            if (aFullNDimensionalMatrix.getDimensions().contains(object3) || iNDimensionalMatrix.getDimensions().contains(object3.getReferentAttribute()) || aFullNDimensionalMatrix.getDimensions().stream().anyMatch(attribute2 -> attribute2.getReferentAttribute().equals(object3))) continue;
            ((StringBuilder)object2).append("control does not contains seed dimension ").append(object3).append(" (you might add a referent attribute?);\n");
        }
        if (((StringBuilder)object2).length() > 0) {
            throw new IllegalArgumentException("Cannot build marginals for control and seed that does not match their attributes: " + ((StringBuilder)object2).toString());
        }
        DEBUG.OUT((Object)("Estimates seed's referent marginals from control matrix : " + iNDimensionalMatrix.getDimensions().stream().map(attribute -> attribute.getAttributeName().substring(0, attribute.getAttributeName().length() < 5 ? attribute.getAttributeName().length() : 5)).collect(Collectors.joining(" x "))));
        object2 = this.getSeedToControl(iNDimensionalMatrix, aFullNDimensionalMatrix);
        DEBUG.OUT((Object)("Matching seed-control attributes are: " + object2.entrySet().stream().map(entry -> "[" + ((Attribute)entry.getKey()).getAttributeName() + " - " + ((Attribute)entry.getValue()).getAttributeName() + "]").collect(Collectors.joining(" "))));
        DEBUG.OUT((Object)("Unmatched attributes are: " + Arrays.toString(aFullNDimensionalMatrix.getDimensions().stream().filter(arg_0 -> MarginalsIPFBuilder.lambda$3((Map)object2, arg_0)).toArray())));
        if (object2.isEmpty()) {
            throw new IllegalArgumentException("Seed attributes do not match any attributes in control distribution");
        }
        ArrayList<Margin<T>> arrayList = new ArrayList<Margin<T>>();
        GSPerformanceUtil gSPerformanceUtil = new GSPerformanceUtil("Trying to build marginals for attribute set " + Arrays.toString(object2.keySet().toArray()), GSPerformanceUtil.Level.TRACE);
        gSPerformanceUtil.sysoStempPerformance(0, (Object)this);
        for (Attribute attribute3 : object2.values()) {
            Collection<MarginDescriptor> collection = this.getMarginalDescriptors(attribute3, object2.values().stream().filter(attribute2 -> !attribute2.equals(attribute3)).collect(Collectors.toSet()), iNDimensionalMatrix, aFullNDimensionalMatrix);
            DEBUG.OUT((Object)("Attribute '" + attribute3.getAttributeName() + "' marginal descriptors: " + collection.size() + " margin(s), " + collection.stream().flatMap(marginDescriptor -> marginDescriptor.getSeed().stream()).collect(Collectors.toSet()).size() + " seed values over "));
            Margin<T> margin = new Margin<T>(attribute3, (Attribute)object2.get(attribute3));
            AControl<T> aControl2 = iNDimensionalMatrix.getNulVal();
            for (MarginDescriptor marginDescriptor2 : collection) {
                AControl<T> aControl3 = iNDimensionalMatrix.getVal((Collection<IValue>)marginDescriptor2.getControl());
                if (aControl3.equalsVal(aControl2, 0.0)) continue;
                margin.addMargin(marginDescriptor2, aControl3);
            }
            arrayList.add(margin);
            gSPerformanceUtil.sysoStempPerformance(1, (Object)this);
            double marginDescriptor2 = margin.marginalControl.values().stream().mapToDouble(aControl -> ((Number)aControl.getValue()).doubleValue()).sum();
            DEBUG.OUT((Object)("Created marginals (size = {}): cd = {} | sd = {} | sum_of_c = {} : " + String.valueOf(margin.size() == 0 ? "empty" : Integer.valueOf(margin.size())) + " , " + String.valueOf(margin.getControlDimension()) + "," + String.valueOf(margin.getSeedDimension()) + "," + marginDescriptor2));
        }
        return arrayList;
    }

    private Map<Attribute<? extends IValue>, Attribute<? extends IValue>> getSeedToControl(INDimensionalMatrix<Attribute<? extends IValue>, IValue, T> iNDimensionalMatrix, AFullNDimensionalMatrix<T> aFullNDimensionalMatrix) {
        HashMap<Attribute<? extends IValue>, Attribute<? extends IValue>> hashMap = new HashMap<Attribute<? extends IValue>, Attribute<? extends IValue>>();
        for (Attribute<IValue> attribute3 : aFullNDimensionalMatrix.getDimensions()) {
            Optional<Attribute> optional;
            List<Attribute> list = iNDimensionalMatrix.getDimensions().stream().filter(attribute2 -> attribute2.isLinked(attribute3)).toList();
            Attribute attribute4 = null;
            if (list.size() == 1) {
                attribute4 = list.get(0);
            } else if (list.size() > 1 && (optional = list.stream().filter(attribute -> attribute.getReferentAttribute().equals(attribute)).findFirst()).isPresent()) {
                attribute4 = optional.get();
            }
            if (attribute4 == null) continue;
            hashMap.put(attribute3, attribute4);
        }
        return hashMap;
    }

    private Collection<MarginDescriptor> getMarginalDescriptors(Attribute<? extends IValue> attribute2, Set<Attribute<? extends IValue>> set, INDimensionalMatrix<Attribute<? extends IValue>, IValue, T> iNDimensionalMatrix, AFullNDimensionalMatrix<T> aFullNDimensionalMatrix) {
        AbstractCollection abstractCollection;
        if (!iNDimensionalMatrix.getDimensions().containsAll(Stream.concat(Stream.of(attribute2), set.stream()).collect(Collectors.toSet()))) {
            throw new IllegalArgumentException("Targeted attributes must be compliant with n-dimensional matrix passed as parameter");
        }
        ArrayList<MarginDescriptor> arrayList = new ArrayList<MarginDescriptor>();
        Set set2 = set.stream().filter(attribute -> attribute.getReferentAttribute().equals(attribute) || !attribute.getReferentAttribute().equals(attribute) && !set.contains(attribute.getReferentAttribute())).collect(Collectors.toSet());
        ArrayList arrayList2 = new ArrayList();
        Attribute attribute3 = (Attribute)set2.iterator().next();
        for (IValue object : attribute3.getValueSpace().getValues()) {
            arrayList2.add(Stream.of(object).collect(Collectors.toSet()));
        }
        set2.remove(attribute3);
        for (Attribute attribute4 : set2) {
            abstractCollection = new ArrayList();
            for (Set set3 : arrayList2) {
                abstractCollection.addAll(attribute4.getValueSpace().getValues().stream().map(iValue -> Stream.concat(set3.stream(), Stream.of(iValue)).collect(Collectors.toSet())).toList());
            }
            arrayList2 = abstractCollection;
        }
        for (Set set4 : arrayList2) {
            abstractCollection = new HashSet();
            for (IValue iValue2 : set4) {
                if (aFullNDimensionalMatrix.getAspects().contains(iValue2)) {
                    abstractCollection.add(iValue2);
                    continue;
                }
                if (aFullNDimensionalMatrix.getDimensions().stream().anyMatch(attribute -> ((Attribute)iNDimensionalMatrix.getDimension(iValue2)).getReferentAttribute().equals(attribute))) {
                    abstractCollection.addAll(iNDimensionalMatrix.getDimension(iValue2).findMappedAttributeValues(iValue2));
                    continue;
                }
                if (!aFullNDimensionalMatrix.getDimensions().stream().anyMatch(attribute -> attribute.getReferentAttribute().equals(iNDimensionalMatrix.getDimension(iValue2)))) continue;
                abstractCollection.addAll(aFullNDimensionalMatrix.getDimensions().stream().filter(attribute -> attribute.getReferentAttribute().equals(iNDimensionalMatrix.getDimension(iValue2))).findFirst().get().findMappedAttributeValues(iValue2));
            }
            arrayList.add(new MarginDescriptor().setControl(set4).setSeed((Set<IValue>)((Object)abstractCollection)));
        }
        return arrayList;
    }

    private static /* synthetic */ boolean lambda$3(Map map, Attribute attribute) {
        return !map.containsKey(attribute);
    }
}

