/*
 * Decompiled with CFR 0.152.
 */
package gospl.distribution;

import core.configuration.GenstarConfigurationFile;
import core.configuration.GenstarJsonUtil;
import core.configuration.dictionary.IGenstarDictionary;
import core.metamodel.IPopulation;
import core.metamodel.attribute.Attribute;
import core.metamodel.entity.ADemoEntity;
import core.metamodel.entity.IEntity;
import core.metamodel.io.GSSurveyType;
import core.metamodel.io.GSSurveyWrapper;
import core.metamodel.io.IGSSurvey;
import core.metamodel.value.IValue;
import core.util.GSPerformanceUtil;
import core.util.data.GSDataParser;
import core.util.data.GSEnumDataType;
import core.util.exception.GenstarException;
import core.util.random.GenstarRandomUtils;
import gospl.GosplEntity;
import gospl.GosplMultitypePopulation;
import gospl.GosplPopulation;
import gospl.distribution.GosplConditionalDistribution;
import gospl.distribution.GosplContingencyTable;
import gospl.distribution.GosplJointDistribution;
import gospl.distribution.exception.IllegalControlTotalException;
import gospl.distribution.exception.IllegalDistributionCreation;
import gospl.distribution.matrix.AFullNDimensionalMatrix;
import gospl.distribution.matrix.INDimensionalMatrix;
import gospl.distribution.matrix.control.AControl;
import gospl.distribution.matrix.control.ControlFrequency;
import gospl.distribution.matrix.coordinate.ACoordinate;
import gospl.distribution.matrix.coordinate.GosplCoordinate;
import gospl.io.GosplSurveyFactory;
import gospl.io.exception.InvalidSurveyFormatException;
import gospl.io.util.ReadMultiLayerEntityUtils;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.lang.invoke.LambdaMetafactory;
import java.nio.file.Path;
import java.text.DecimalFormat;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.poi.openxml4j.exceptions.InvalidFormatException;

public class GosplInputDataManager {
    protected static final double EPSILON = Math.pow(10.0, -3.0);
    protected static final double MAX_SAMPLE_SIZE = (int)Math.pow(10.0, 6.0);
    private final GenstarConfigurationFile configuration;
    private Set<AFullNDimensionalMatrix<? extends Number>> inputData;
    private Set<GosplMultitypePopulation<ADemoEntity>> multiSamples;
    private Set<GosplPopulation> samples;

    public GosplInputDataManager(Path path) throws IllegalArgumentException, IOException {
        this.configuration = new GenstarJsonUtil().unmarchalConfigurationFileFromGenstarJson(path);
    }

    public GosplInputDataManager(GenstarConfigurationFile genstarConfigurationFile) {
        this.configuration = genstarConfigurationFile;
    }

    public GenstarConfigurationFile getConfiguration() {
        return this.configuration;
    }

    public void buildDataTables() throws IOException, InvalidSurveyFormatException, InvalidFormatException {
        GosplSurveyFactory gosplSurveyFactory = new GosplSurveyFactory();
        this.inputData = new HashSet<AFullNDimensionalMatrix<? extends Number>>();
        for (GSSurveyWrapper gSSurveyWrapper : this.configuration.getSurveyWrappers()) {
            if (GSSurveyType.Sample.equals((Object)gSSurveyWrapper.getSurveyType())) continue;
            this.inputData.addAll(GosplInputDataManager.getDataTables(gosplSurveyFactory.getSurvey(gSSurveyWrapper, this.configuration.getBaseDirectory()), this.configuration.getDictionary()));
        }
    }

    public void buildSamples() throws IOException, InvalidSurveyFormatException, InvalidFormatException {
        GosplSurveyFactory gosplSurveyFactory = new GosplSurveyFactory();
        this.samples = new HashSet<GosplPopulation>();
        for (GSSurveyWrapper gSSurveyWrapper : this.configuration.getSurveyWrappers()) {
            if (!GSSurveyType.Sample.equals((Object)gSSurveyWrapper.getSurveyType())) continue;
            this.samples.add(GosplInputDataManager.getSample(gosplSurveyFactory.getSurvey(gSSurveyWrapper, this.configuration.getBaseDirectory()), this.configuration.getDictionary(), null, Collections.emptyMap()));
        }
    }

    public void buildMultiLayerSamples() throws InvalidFormatException, IOException, InvalidSurveyFormatException {
        this.buildMultiLayerSamples(Collections.emptyMap(), null);
    }

    public void buildMultiLayerSamples(int n) throws InvalidFormatException, IOException, InvalidSurveyFormatException {
        this.buildMultiLayerSamples(Collections.emptyMap(), n);
    }

    public void buildMultiLayerSamples(Map<String, List<String>> map, Integer n) throws InvalidFormatException, IOException, InvalidSurveyFormatException {
        GosplSurveyFactory gosplSurveyFactory = new GosplSurveyFactory();
        this.multiSamples = new HashSet<GosplMultitypePopulation<ADemoEntity>>();
        for (GSSurveyWrapper gSSurveyWrapper2 : this.configuration.getSurveyWrappers().stream().filter(gSSurveyWrapper -> GSSurveyType.Sample.equals((Object)gSSurveyWrapper.getSurveyType())).toList()) {
            this.multiSamples.add(GosplInputDataManager.getMutliLayerSample(gosplSurveyFactory.getSurvey(gSSurveyWrapper2, this.configuration.getBaseDirectory()), this.configuration.getDictionaries(), n, map));
        }
    }

    public Set<INDimensionalMatrix<Attribute<? extends IValue>, IValue, ? extends Number>> getRawDataTables() {
        return Collections.unmodifiableSet(this.inputData);
    }

    public Set<AFullNDimensionalMatrix<Integer>> getContingencyTables() {
        return this.inputData.stream().filter(aFullNDimensionalMatrix -> GSSurveyType.ContingencyTable.equals((Object)aFullNDimensionalMatrix.getMetaDataType())).map(aFullNDimensionalMatrix -> aFullNDimensionalMatrix).collect(Collectors.toSet());
    }

    public Set<IPopulation<ADemoEntity, Attribute<? extends IValue>>> getRawSamples() {
        return Collections.unmodifiableSet(this.samples);
    }

    public Collection<GosplMultitypePopulation<ADemoEntity>> getMultiSamples() {
        return Collections.unmodifiableCollection(this.multiSamples);
    }

    public INDimensionalMatrix<Attribute<? extends IValue>, IValue, Double> collapseDataTablesIntoDistribution() throws IllegalDistributionCreation, IllegalControlTotalException {
        if (this.inputData.isEmpty()) {
            throw new IllegalArgumentException("To collapse matrices you must build at least one first: see the buildDataTables method");
        }
        if (this.inputData.size() == 1) {
            return GosplInputDataManager.getFrequency(this.inputData.iterator().next(), this.inputData);
        }
        HashSet<AFullNDimensionalMatrix<Double>> hashSet = new HashSet<AFullNDimensionalMatrix<Double>>();
        GSPerformanceUtil gSPerformanceUtil = new GSPerformanceUtil("Proceed to distribution collapse");
        gSPerformanceUtil.sysoStempPerformance(0, (Object)this);
        for (AFullNDimensionalMatrix aFullNDimensionalMatrix2 : this.inputData.stream().filter(aFullNDimensionalMatrix -> aFullNDimensionalMatrix.getDimensions().stream().anyMatch(attribute -> this.configuration.getDictionary().getRecords().contains(attribute))).collect(Collectors.toSet())) {
            hashSet.add(GosplInputDataManager.getTransposedRecord(this.getConfiguration().getDictionary(), aFullNDimensionalMatrix2));
        }
        gSPerformanceUtil.sysoStempPerformance(1, (Object)this);
        gSPerformanceUtil.sysoStempMessage("Collapse record attribute: done");
        for (AFullNDimensionalMatrix aFullNDimensionalMatrix2 : this.inputData.stream().filter(aFullNDimensionalMatrix -> aFullNDimensionalMatrix.getDimensions().stream().allMatch(attribute -> !GosplInputDataManager.isRecordAttribute(this.getConfiguration().getDictionary(), attribute))).collect(Collectors.toSet())) {
            hashSet.add(GosplInputDataManager.getFrequency(aFullNDimensionalMatrix2, this.inputData));
        }
        gSPerformanceUtil.sysoStempPerformance(2, (Object)this);
        gSPerformanceUtil.sysoStempMessage("Transpose to frequency: done");
        return new GosplConditionalDistribution((Set<AFullNDimensionalMatrix<Double>>)hashSet);
    }

    public static Set<AFullNDimensionalMatrix<? extends Number>> getDataTables(IGSSurvey iGSSurvey, IGenstarDictionary<Attribute<? extends IValue>> iGenstarDictionary) {
        Set<IValue> set2;
        GSPerformanceUtil gSPerformanceUtil = new GSPerformanceUtil("Retrieve data table from files", GSPerformanceUtil.Level.TRACE);
        HashSet<AFullNDimensionalMatrix<? extends Number>> hashSet = new HashSet<AFullNDimensionalMatrix<? extends Number>>();
        GSDataParser gSDataParser = new GSDataParser();
        Map<Integer, Set<IValue>> map = iGSSurvey.getRowHeaders(iGenstarDictionary);
        gSPerformanceUtil.sysoStempMessage("detected in " + iGSSurvey.getName() + " " + map.size() + " row headers : " + String.valueOf(map));
        Map<Integer, Set<IValue>> map2 = iGSSurvey.getColumnHeaders(iGenstarDictionary);
        gSPerformanceUtil.sysoStempMessage("detected in " + iGSSurvey.getName() + " " + map2.size() + " column headers : " + String.valueOf(map2));
        HashSet hashSet2 = new HashSet();
        for (Set<IValue> set2 : map2.values()) {
            hashSet2.add(set2.stream().map(iValue -> iValue.getValueSpace().getAttribute().getAttributeName()).collect(Collectors.toSet()));
        }
        hashSet2.removeAll(hashSet2.stream().filter(set3 -> hashSet2.stream().anyMatch(set2 -> set3.stream().allMatch(set2::contains) && set2.size() > set3.size())).collect(Collectors.toSet()));
        set2 = new HashSet<IValue>();
        for (Set<IValue> set4 : map.values()) {
            set2.add((IValue)((Object)set4.stream().map(iValue -> iValue.getValueSpace().getAttribute().getAttributeName()).collect(Collectors.toSet())));
        }
        set2.removeAll(set2.stream().filter(set3 -> set2.stream().anyMatch(set2 -> set3.stream().allMatch(set2::contains) && set2.size() > set3.size())).collect(Collectors.toSet()));
        for (Set set5 : set2) {
            for (Set set6 : hashSet2) {
                Set<Attribute<? extends IValue>> set7 = Stream.concat(set5.stream().filter(iGenstarDictionary::containsAttribute).map(iGenstarDictionary::getAttribute), set6.stream().filter(iGenstarDictionary::containsAttribute).map(iGenstarDictionary::getAttribute)).collect(Collectors.toSet());
                AFullNDimensionalMatrix aFullNDimensionalMatrix = GSSurveyType.ContingencyTable.equals((Object)iGSSurvey.getDataFileType()) ? new GosplContingencyTable(set7) : new GosplJointDistribution(set7, iGSSurvey.getDataFileType());
                aFullNDimensionalMatrix.setLabel(iGSSurvey.getName());
                aFullNDimensionalMatrix.addGenesis("from file " + iGSSurvey.getName());
                for (Integer n : map.entrySet().stream().filter(entry -> set5.stream().allMatch(string -> ((Set)entry.getValue()).stream().anyMatch(iValue -> iValue.getValueSpace().getAttribute().getAttributeName().equals(string)))).map(Map.Entry::getKey).collect(Collectors.toSet())) {
                    for (Integer n2 : map2.entrySet().stream().filter(entry -> set4.stream().allMatch(string -> ((Set)entry.getValue()).stream().anyMatch(iValue -> iValue.getValueSpace().getAttribute().getAttributeName().equals(string)))).map(Map.Entry::getKey).collect(Collectors.toSet())) {
                        String string = iGSSurvey.read(n, n2);
                        GSEnumDataType gSEnumDataType = gSDataParser.getValueType(string);
                        Map<Attribute<? extends IValue>, IValue> map3 = Stream.concat(map.get(n).stream(), map2.get(n2).stream()).filter(iValue -> iGenstarDictionary.containsValue(iValue.getStringValue())).collect(Collectors.toMap(iValue -> (Attribute)iGenstarDictionary.getAttribute(iValue.getValueSpace().getAttribute().getAttributeName()), Function.identity()));
                        GosplCoordinate gosplCoordinate = new GosplCoordinate(map3);
                        if (!gSEnumDataType.isNumericValue() || aFullNDimensionalMatrix.addValue(gosplCoordinate, aFullNDimensionalMatrix.parseVal(gSDataParser, string))) continue;
                        aFullNDimensionalMatrix.getVal(gosplCoordinate).add(aFullNDimensionalMatrix.parseVal(gSDataParser, string));
                    }
                }
                hashSet.add(aFullNDimensionalMatrix);
            }
        }
        return hashSet;
    }

    public static GosplPopulation getSample(IGSSurvey iGSSurvey, IGenstarDictionary<Attribute<? extends IValue>> iGenstarDictionary) throws IOException, InvalidSurveyFormatException {
        return GosplInputDataManager.getSample(iGSSurvey, iGenstarDictionary, null, Collections.emptyMap());
    }

    /*
     * Unable to fully structure code
     */
    public static GosplPopulation getSample(IGSSurvey var0, IGenstarDictionary<Attribute<? extends IValue>> var1_1, Integer var2_2, Map<String, String> var3_3) throws IOException, InvalidSurveyFormatException {
        block15: {
            var4_4 = new GSPerformanceUtil("Retrieve a sample from a data file", GSPerformanceUtil.Level.DEBUG);
            var5_5 = new GosplPopulation();
            var6_6 = var0.getColumnSample(var1_1);
            if (var6_6.isEmpty()) {
                throw new GenstarException("no column header was decoded in survey " + String.valueOf(var0) + "; are you sure you provided a relevant dictionnary of data?");
            }
            var7_7 = 0;
            var8_8 = null;
            try {
                var8_8 = var0.getBufferReader(true);
                var9_9 = null;
                var10_12 = GosplInputDataManager.MAX_SAMPLE_SIZE / (double)var0.getLastRowIndex();
                while (var5_5.size() <= var2_2) {
                    try {
                        do {
                            var9_9 = var8_8.readNext();
                        } while (GenstarRandomUtils.flip(var10_12));
                    }
                    catch (IOException var12_15) {
                        var12_15.printStackTrace();
                    }
                    if (var9_9 == null) break;
                    var12_14 = GosplInputDataManager.readRecord(Arrays.asList(var9_9), var6_6, var3_3, var4_4);
                    if (var12_14 != null) {
                        var5_5.add(var12_14);
                        continue;
                    }
                    ++var7_7;
                }
                try {
                    var8_8.close();
                }
                catch (IOException var12_16) {
                    var12_16.printStackTrace();
                }
                break block15;
            }
            catch (FileNotFoundException | UnsupportedEncodingException var9_10) {
                var9_10.getStackTrace();
                break block15;
            }
            catch (UnsupportedOperationException v0) {
                var9_11 = var0.getFirstRowIndex();
                ** while (var9_11 <= var0.getLastRowIndex())
            }
lbl-1000:
            // 1 sources

            {
                if (var5_5.size() >= var2_2) break;
                var10_13 = GosplInputDataManager.readRecord(var0.readLine(var9_11), var6_6, var3_3, var4_4);
                if (var10_13 != null) {
                    var5_5.add(var10_13);
                } else {
                    ++var7_7;
                }
                ++var9_11;
                continue;
            }
        }
        if (var7_7 > 0) {
            var4_4.sysoStempMessage("Input sample has bypass " + new DecimalFormat("#.##").format((double)var7_7 / (double)var5_5.size() * 100.0) + "% (" + var7_7 + ") of entities due to unmatching attribute's value");
        }
        return var5_5;
    }

    private static GosplEntity readRecord(List<String> list, Map<Integer, Attribute<? extends IValue>> map, Map<String, String> map2, GSPerformanceUtil gSPerformanceUtil) {
        HashMap<Attribute<? extends IValue>, IValue> hashMap = new HashMap<Attribute<? extends IValue>, IValue>();
        for (Integer n : map.keySet()) {
            String string;
            String string2 = list.get(n);
            Attribute<? extends IValue> attribute = map.get(n);
            IValue iValue = null;
            iValue = "?".equals(string2) ? attribute.getValueSpace().getEmptyValue() : attribute.getValueSpace().addValue(string2);
            if (iValue != null && (string = map2.get(attribute.getAttributeName())) != null && !iValue.getStringValue().equals(string)) {
                return null;
            }
            if (iValue != null) {
                hashMap.put(attribute, iValue);
                continue;
            }
            if (attribute.getEmptyValue().getStringValue() != null && attribute.getEmptyValue().getStringValue().equals(list.get(n))) {
                hashMap.put(attribute, attribute.getValueSpace().getEmptyValue());
                continue;
            }
            gSPerformanceUtil.sysoStempMessage("Data modality " + list.get(n) + " does not match any value for attribute " + attribute.getAttributeName());
            return null;
        }
        return new GosplEntity(hashMap);
    }

    /*
     * Could not resolve type clashes
     * Unable to fully structure code
     */
    public static GosplMultitypePopulation<ADemoEntity> getMutliLayerSample(IGSSurvey var0, Set<IGenstarDictionary<Attribute<? extends IValue>>> var1_1, Integer var2_2, Map<String, List<String>> var3_3) {
        block18: {
            var4_4 = new GSPerformanceUtil("Retrieve a multi layered sample from a data file", GSPerformanceUtil.Level.DEBUG);
            var5_5 = new GosplMultitypePopulation<ADemoEntity>(var1_1.stream().map((Function<IGenstarDictionary, String>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, getIdentifierAttributeName(), (Lcore/configuration/dictionary/IGenstarDictionary;)Ljava/lang/String;)()).toList());
            var6_6 = new HashMap<Integer, String>();
            var7_7 = new HashMap<Integer, String>();
            var8_8 = new HashMap<Attribute<? extends IValue>, Integer>();
            var9_9 = new HashMap<Integer, Set<Object>>();
            var10_10 = new HashMap<Integer, Attribute<? extends IValue>>();
            var11_11 = new HashMap<String, Integer>();
            for (IGenstarDictionary<Attribute<? extends IValue>> var12_14 : var1_1) {
                var6_6.put(var12_14.getLevel(), var12_14.getIdentifierAttributeName());
                var7_7.put(var12_14.getLevel(), var12_14.getWeightAttributeName());
                var12_14.getAttributes().stream().forEach((Consumer<Attribute>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, lambda$30(java.util.Map core.configuration.dictionary.IGenstarDictionary core.metamodel.attribute.Attribute ), (Lcore/metamodel/attribute/Attribute;)V)(var8_8, var12_14));
                var10_10.putAll(var0.getColumnSample(var12_14));
                var11_11.putAll(var0.getColumnIdAndWeight(var12_14));
                var9_9.put(var12_14.getLevel(), new HashSet<E>());
            }
            var12_15 = 0;
            var13_13 = 0;
            var14_16 = var2_2 == null ? (int)GosplInputDataManager.MAX_SAMPLE_SIZE : var2_2;
            var15_17 = null;
            try {
                var15_17 = var0.getBufferReader(true);
                var16_18 = null;
                var17_22 = var0.getLastRowIndex();
                var18_25 = var17_22 < var14_16 ? 0.0 : (double)var14_16 / (double)var0.getLastRowIndex();
                while (var13_13 <= var14_16) {
                    try {
                        do {
                            var16_18 = var15_17.readNext();
                        } while (GenstarRandomUtils.flip(var18_25));
                    }
                    catch (IOException var20_29) {
                        var20_29.printStackTrace();
                    }
                    if (var16_18 == null) break;
                    var20_28 = GosplInputDataManager.readComplexRecord(Arrays.asList(var16_18), var1_1, var10_10, var8_8, var11_11, var6_6, var7_7, var3_3);
                    if (var20_28.isEmpty()) {
                        ++var12_15;
                        continue;
                    }
                    for (Object var21_31 : var20_28.keySet()) {
                        ((Set)var9_9.get(var21_31)).addAll((Collection)var20_28.get(var21_31));
                    }
                    if ((double)(var13_13 += ((Set)var20_28.get(Collections.min(var6_6.keySet()))).size()) % ((double)var14_16 / 10.0) != 0.0) continue;
                    var4_4.sysoStempMessage(100.0 * (double)var13_13 / (double)var14_16 + "% of total sample has been build");
                }
                try {
                    var15_17.close();
                }
                catch (IOException var20_30) {
                    var20_30.printStackTrace();
                }
                break block18;
            }
            catch (FileNotFoundException | UnsupportedEncodingException var16_19) {
                var16_19.getStackTrace();
                break block18;
            }
            catch (UnsupportedOperationException v0) {
                var16_20 = var0.getFirstRowIndex();
                ** while (var16_20 <= var0.getLastRowIndex())
            }
lbl-1000:
            // 1 sources

            {
                if (var13_13 >= var14_16) break;
                var17_23 = var0.readLine(var16_20);
                var18_26 = GosplInputDataManager.readComplexRecord(var17_23, var1_1, var10_10, var8_8, var11_11, var6_6, var7_7, var3_3);
                if (var18_26.isEmpty()) {
                    ++var12_15;
                } else {
                    var9_9.putAll(var18_26);
                    var13_13 += var18_26.get(Collections.min(var6_6.keySet())).size();
                }
                ++var16_20;
                continue;
            }
        }
        var16_21 = var1_1.stream().map((Function<IGenstarDictionary, Integer>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, getLevel(), (Lcore/configuration/dictionary/IGenstarDictionary;)Ljava/lang/Integer;)()).sorted().toList();
        var17_24 = Collections.min(var16_21);
        var18_27 = ((Set)var9_9.get(var17_24)).stream().collect(Collectors.toMap(Function.identity(), (Function<ReadMultiLayerEntityUtils, GosplEntity>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, toGosplEntity(), (Lgospl/io/util/ReadMultiLayerEntityUtils;)Lgospl/GosplEntity;)()));
        var5_5.addAll((String)var6_6.get(var17_24), var18_27.values());
        var16_21.remove(var17_24);
        for (Integer var19_33 : var16_21) {
            var21_31 = ((Set)var9_9.get(var19_33)).stream().collect(Collectors.toMap(Function.identity(), (Function<ReadMultiLayerEntityUtils, GosplEntity>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, toGosplEntity(), (Lgospl/io/util/ReadMultiLayerEntityUtils;)Lgospl/GosplEntity;)()));
            var22_32 = var18_27.entrySet().stream().collect(Collectors.groupingBy((Function<Map.Entry, String>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$34(java.lang.Integer java.util.Map$Entry ), (Ljava/util/Map$Entry;)Ljava/lang/String;)((Integer)var19_33), Collectors.mapping((Function<Map.Entry, GosplEntity>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, getValue(), (Ljava/util/Map$Entry;)Lgospl/GosplEntity;)(), Collectors.toSet())));
            for (ReadMultiLayerEntityUtils var23_34 : var21_31.keySet()) {
                var25_36 = (Set)var22_32.get(var23_34.getId());
                ((GosplEntity)var21_31.get(var23_34)).addChildren(var25_36);
                var25_36.stream().forEach((Consumer<IEntity>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, lambda$36(java.util.Map gospl.io.util.ReadMultiLayerEntityUtils core.metamodel.entity.IEntity ), (Lcore/metamodel/entity/IEntity;)V)((Map)var21_31, (ReadMultiLayerEntityUtils)var23_34));
            }
            var18_27 = var21_31;
            var5_5.addAll((String)var6_6.get(var19_33), var21_31.values());
        }
        if (var12_15 > 0) {
            var4_4.sysoStempMessage("Input sample has bypass " + new DecimalFormat("#.##").format((double)var12_15 / (double)var5_5.size() * 100.0) + "% (" + var12_15 + ") of entities due to unmatching attribute's value");
        }
        return var5_5;
    }

    private static Map<Integer, Set<ReadMultiLayerEntityUtils>> readComplexRecord(List<String> list, Set<IGenstarDictionary<Attribute<? extends IValue>>> set, Map<Integer, Attribute<? extends IValue>> map, Map<Attribute<? extends IValue>, Integer> map2, Map<String, Integer> map3, Map<Integer, String> map4, Map<Integer, String> map5, Map<String, List<String>> map6) {
        Object object;
        Map<Integer, String> map7 = map4.keySet().stream().sorted().collect(Collectors.toMap(Function.identity(), n -> (String)list.get((Integer)map3.get(map4.get(n)))));
        HashMap<Integer, Set<ReadMultiLayerEntityUtils>> hashMap = new HashMap<Integer, Set<ReadMultiLayerEntityUtils>>();
        HashMap<Integer, Object> hashMap2 = new HashMap<Integer, Object>();
        for (IGenstarDictionary<Attribute<? extends IValue>> object2 : set) {
            object = new ReadMultiLayerEntityUtils(object2.getLevel(), list.get(map3.get(map4.get(object2.getLevel()))), list.get(map3.get(map5.get(object2.getLevel()))), new HashMap<Attribute<? extends IValue>, IValue>());
            ((ReadMultiLayerEntityUtils)object).setIDs(map7);
            hashMap2.put(object2.getLevel(), object);
            hashMap.put(object2.getLevel(), new HashSet());
        }
        for (Integer n2 : map.keySet()) {
            Collection collection;
            object = list.get(n2);
            Attribute<? extends IValue> attribute = map.get(n2);
            IValue iValue = null;
            iValue = object == "?" ? attribute.getValueSpace().getEmptyValue() : attribute.getValueSpace().addValue((String)object);
            if (iValue != null && (collection = (Collection)map6.get(attribute.getAttributeName())) != null && !collection.contains(iValue.getStringValue())) {
                return hashMap;
            }
            if (iValue == null) {
                if (attribute.getEmptyValue().getStringValue() == null || !attribute.getEmptyValue().getStringValue().equals(list.get(n2))) {
                    return null;
                }
                iValue = attribute.getValueSpace().getEmptyValue();
            }
            ((ReadMultiLayerEntityUtils)hashMap2.get(map2.get(attribute))).getEntity().put(attribute, iValue);
        }
        for (Integer n3 : hashMap2.keySet()) {
            ((Set)hashMap.get(n3)).add((ReadMultiLayerEntityUtils)hashMap2.get(n3));
        }
        return hashMap;
    }

    protected static AFullNDimensionalMatrix<Double> getFrequency(AFullNDimensionalMatrix<? extends Number> aFullNDimensionalMatrix4, Set<AFullNDimensionalMatrix<? extends Number>> set) throws IllegalControlTotalException {
        GosplJointDistribution gosplJointDistribution = null;
        if (GSSurveyType.LocalFrequencyTable.equals((Object)aFullNDimensionalMatrix4.getMetaDataType())) {
            Map<Attribute, List> map = aFullNDimensionalMatrix4.getDimensions().stream().collect(Collectors.toMap(attribute -> attribute, attribute -> attribute.getValueSpace().getValues().stream().map(aFullNDimensionalMatrix4::getVal).collect(Collectors.toList())));
            Attribute attribute2 = map.entrySet().stream().filter(entry -> ((List)entry.getValue()).stream().allMatch(aControl -> aControl.equalsCastedVal((AControl)((List)entry.getValue()).get(0), EPSILON))).map(Map.Entry::getKey).findFirst().orElse(null);
            AControl aControl = (AControl)map.get(attribute2).iterator().next();
            Optional<AFullNDimensionalMatrix> optional = set.stream().filter(aFullNDimensionalMatrix -> !GSSurveyType.LocalFrequencyTable.equals((Object)aFullNDimensionalMatrix.getMetaDataType()) && aFullNDimensionalMatrix.getDimensions().contains(attribute2)).sorted((aFullNDimensionalMatrix2, aFullNDimensionalMatrix3) -> (int)aFullNDimensionalMatrix3.getDimensions().stream().filter(attribute -> aFullNDimensionalMatrix4.getDimensions().contains(attribute)).count() - (int)aFullNDimensionalMatrix2.getDimensions().stream().filter(attribute -> aFullNDimensionalMatrix4.getDimensions().contains(attribute)).count()).findFirst();
            if (!optional.isPresent()) {
                throw new IllegalControlTotalException("The matrix (" + aFullNDimensionalMatrix4.getLabel() + ") must be aligned to global frequency table but lacks of a referent matrix", aFullNDimensionalMatrix4);
            }
            gosplJointDistribution = new GosplJointDistribution(aFullNDimensionalMatrix4.getDimensions(), GSSurveyType.GlobalFrequencyTable);
            AFullNDimensionalMatrix aFullNDimensionalMatrix5 = optional.get();
            double d = ((Number)aFullNDimensionalMatrix5.getVal(attribute2.getValueSpace().getValues().stream().collect(Collectors.toSet())).getValue()).doubleValue();
            Map<IValue, Double> map2 = attribute2.getValueSpace().getValues().stream().collect(Collectors.toMap(iValue -> iValue, iValue -> ((Number)aFullNDimensionalMatrix5.getVal((IValue)iValue).getValue()).doubleValue() / d));
            for (ACoordinate<Attribute<? extends IValue>, IValue> aCoordinate : aFullNDimensionalMatrix4.getMatrix().keySet()) {
                gosplJointDistribution.addValue(aCoordinate, new ControlFrequency(aFullNDimensionalMatrix4.getVal((ACoordinate<Attribute<IValue>, IValue>)aCoordinate).getValue().doubleValue() / ((Number)aControl.getValue()).doubleValue() * map2.get(aCoordinate.getMap().get(attribute2))));
            }
        } else {
            gosplJointDistribution = new GosplJointDistribution(aFullNDimensionalMatrix4.getDimensions(), GSSurveyType.GlobalFrequencyTable);
            gosplJointDistribution.setLabel((String)(aFullNDimensionalMatrix4.getLabel() == null ? "?/joint" : aFullNDimensionalMatrix4.getLabel() + "/joint"));
            if (GSSurveyType.GlobalFrequencyTable.equals((Object)aFullNDimensionalMatrix4.getMetaDataType())) {
                for (ACoordinate<Attribute<? extends IValue>, IValue> aCoordinate : aFullNDimensionalMatrix4.getMatrix().keySet()) {
                    gosplJointDistribution.addValue(aCoordinate, new ControlFrequency(aFullNDimensionalMatrix4.getVal((ACoordinate<Attribute<IValue>, IValue>)aCoordinate).getValue().doubleValue()));
                }
            } else {
                AControl<? extends Number> aControl = aFullNDimensionalMatrix4.getVal();
                for (Attribute<IValue> attribute3 : aFullNDimensionalMatrix4.getDimensions()) {
                    AControl<? extends Number> aControl2 = aFullNDimensionalMatrix4.getVal(attribute3.getValueSpace().getValues().stream().collect(Collectors.toSet()));
                    if (!(Math.abs(aControl2.getValue().doubleValue() - aControl.getValue().doubleValue()) / aControl2.getValue().doubleValue() > EPSILON)) continue;
                    throw new IllegalControlTotalException(aControl, aControl2);
                }
                for (ACoordinate aCoordinate : aFullNDimensionalMatrix4.getMatrix().keySet()) {
                    gosplJointDistribution.addValue(aCoordinate, new ControlFrequency(aFullNDimensionalMatrix4.getVal(aCoordinate).getValue().doubleValue() / aControl.getValue().doubleValue()));
                }
            }
        }
        gosplJointDistribution.inheritGenesis(aFullNDimensionalMatrix4);
        gosplJointDistribution.addGenesis("converted to frequency GosplDistributionBuilder@@getFrequency");
        return gosplJointDistribution;
    }

    public static AFullNDimensionalMatrix<Double> getTransposedRecord(IGenstarDictionary<Attribute<? extends IValue>> iGenstarDictionary, AFullNDimensionalMatrix<? extends Number> aFullNDimensionalMatrix) {
        Set<Attribute<? extends IValue>> set = aFullNDimensionalMatrix.getDimensions().stream().filter(attribute -> !GosplInputDataManager.isRecordAttribute(iGenstarDictionary, attribute)).collect(Collectors.toSet());
        GSPerformanceUtil gSPerformanceUtil = new GSPerformanceUtil("Transpose process of matrix " + Arrays.toString(aFullNDimensionalMatrix.getDimensions().toArray()), GSPerformanceUtil.Level.TRACE);
        gSPerformanceUtil.sysoStempPerformance(0, (Object)GosplInputDataManager.class);
        gSPerformanceUtil.setObjectif(aFullNDimensionalMatrix.getMatrix().size());
        GosplJointDistribution gosplJointDistribution = new GosplJointDistribution(set, GSSurveyType.GlobalFrequencyTable);
        gosplJointDistribution.inheritGenesis(aFullNDimensionalMatrix);
        gosplJointDistribution.addGenesis("transposted by GosplDistributionBuilder@getTransposedRecord");
        AControl<? extends Number> aControl = aFullNDimensionalMatrix.getVal();
        boolean bl = true;
        for (ACoordinate<Attribute<? extends IValue>, IValue> aCoordinate : aFullNDimensionalMatrix.getMatrix().keySet()) {
            if ((double)bl % (gSPerformanceUtil.getObjectif() / 10.0) == 0.0) {
                gSPerformanceUtil.sysoStempPerformance(0.1, GosplInputDataManager.class);
            }
            HashMap<Attribute<? extends IValue>, IValue> hashMap = new HashMap<Attribute<? extends IValue>, IValue>(aCoordinate.getMap());
            set.stream().forEach(attribute -> {
                Object v = hashMap.remove(attribute);
            });
            gosplJointDistribution.addValue(new GosplCoordinate((Map<Attribute<? extends IValue>, IValue>)hashMap), new ControlFrequency(aFullNDimensionalMatrix.getVal((ACoordinate<Attribute<IValue>, IValue>)aCoordinate).getValue().doubleValue() / aControl.getValue().doubleValue()));
        }
        return gosplJointDistribution;
    }

    public static boolean isRecordAttribute(IGenstarDictionary<Attribute<? extends IValue>> iGenstarDictionary, Attribute<? extends IValue> attribute) {
        return iGenstarDictionary.getRecords().contains(attribute);
    }

    private static /* synthetic */ void lambda$30(Map map, IGenstarDictionary iGenstarDictionary, Attribute attribute) {
        Integer n = map.put(attribute, iGenstarDictionary.getLevel());
    }

    private static /* synthetic */ String lambda$34(Integer n, Map.Entry entry) {
        return ((ReadMultiLayerEntityUtils)entry.getKey()).getIDs().get(n);
    }

    private static /* synthetic */ void lambda$36(Map map, ReadMultiLayerEntityUtils readMultiLayerEntityUtils, IEntity iEntity) {
        iEntity.setParent((IEntity)map.get(readMultiLayerEntityUtils));
    }
}

