/*
 * Decompiled with CFR 0.152.
 */
package gospl.distribution;

import com.google.common.collect.Sets;
import core.metamodel.IPopulation;
import core.metamodel.attribute.Attribute;
import core.metamodel.attribute.IAttribute;
import core.metamodel.entity.ADemoEntity;
import core.metamodel.entity.IEntity;
import core.metamodel.io.GSSurveyType;
import core.metamodel.value.IValue;
import core.util.GSPerformanceUtil;
import core.util.GSUtilAttribute;
import gospl.distribution.GosplConditionalDistribution;
import gospl.distribution.GosplContingencyTable;
import gospl.distribution.GosplJointDistribution;
import gospl.distribution.exception.IllegalDistributionCreation;
import gospl.distribution.exception.IllegalNDimensionalMatrixAccess;
import gospl.distribution.matrix.AFullNDimensionalMatrix;
import gospl.distribution.matrix.ASegmentedNDimensionalMatrix;
import gospl.distribution.matrix.INDimensionalMatrix;
import gospl.distribution.matrix.ISegmentedNDimensionalMatrix;
import gospl.distribution.matrix.control.AControl;
import gospl.distribution.matrix.control.ControlContingency;
import gospl.distribution.matrix.control.ControlFrequency;
import gospl.distribution.matrix.coordinate.ACoordinate;
import gospl.distribution.matrix.coordinate.GosplCoordinate;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class GosplNDimensionalMatrixFactory {
    public static double EPSILON = Math.pow(10.0, -3.0);

    public static final GosplNDimensionalMatrixFactory getFactory() {
        return new GosplNDimensionalMatrixFactory();
    }

    public AFullNDimensionalMatrix<Double> createEmptyDistribution(Set<Attribute<? extends IValue>> set, GSSurveyType gSSurveyType) {
        GosplJointDistribution gosplJointDistribution = new GosplJointDistribution(set, gSSurveyType);
        gosplJointDistribution.addGenesis("created from scratch GosplNDimensionalMatrixFactory@createEmptyDistribution");
        return gosplJointDistribution;
    }

    public AFullNDimensionalMatrix<Double> createEmptyDistribution(Set<Attribute<? extends IValue>> set) {
        return this.createEmptyDistribution(set, GSSurveyType.GlobalFrequencyTable);
    }

    public AFullNDimensionalMatrix<Double> createEmptyDistribution(Attribute<? extends IValue> ... attributeArray) {
        return this.createEmptyDistribution(new HashSet<Attribute<? extends IValue>>(Arrays.asList(attributeArray)), GSSurveyType.GlobalFrequencyTable);
    }

    public ISegmentedNDimensionalMatrix<Double> createEmptyDistribution(Collection<Set<Attribute<? extends IValue>>> collection) throws IllegalDistributionCreation {
        return new GosplConditionalDistribution(collection.stream().map(this::createEmptyDistribution).collect(Collectors.toSet()));
    }

    public AFullNDimensionalMatrix<Integer> createEmtpyContingencies(Set<Attribute<? extends IValue>> set, boolean bl) {
        GosplContingencyTable gosplContingencyTable = new GosplContingencyTable(set);
        if (bl) {
            for (List list : Sets.cartesianProduct(set.stream().map(attribute -> attribute.getValueSpace().getValues()).toList())) {
                gosplContingencyTable.addValue(new GosplCoordinate(list.stream().collect(Collectors.toMap(iValue -> set.stream().filter(attribute -> attribute.getValueSpace().contains((IValue)iValue)).findFirst().get(), Function.identity()))), new ControlContingency(0));
            }
        }
        return gosplContingencyTable;
    }

    public AFullNDimensionalMatrix<Double> createDistribution(Set<Attribute<? extends IValue>> set, Map<Set<IValue>, Double> map) {
        if (map.isEmpty()) {
            throw new IllegalArgumentException("Sample distribution cannot be empty");
        }
        AFullNDimensionalMatrix<Double> aFullNDimensionalMatrix = this.createEmptyDistribution(set);
        map.entrySet().stream().forEach(entry -> {
            boolean bl = aFullNDimensionalMatrix.addValue(new GosplCoordinate(set.stream().collect(Collectors.toMap(Function.identity(), attribute -> ((Set)entry.getKey()).stream().filter(iValue -> attribute.getValueSpace().contains((IValue)iValue)).findFirst().get()))), (Double)((Object)new ControlFrequency((Double)entry.getValue())));
        });
        return aFullNDimensionalMatrix;
    }

    public AFullNDimensionalMatrix<Double> createDistribution(AFullNDimensionalMatrix<Integer> aFullNDimensionalMatrix) {
        GosplJointDistribution gosplJointDistribution = new GosplJointDistribution(aFullNDimensionalMatrix.getDimensions(), GSSurveyType.GlobalFrequencyTable);
        gosplJointDistribution.addGenesis("created from distribution GosplNDimensionalMatrixFactory@createDistribution");
        int n = (int)Math.round(aFullNDimensionalMatrix.getVal().getValue().doubleValue());
        aFullNDimensionalMatrix.getMatrix().keySet().stream().forEach(aCoordinate -> {
            boolean bl = gosplJointDistribution.setValue(aCoordinate, new ControlFrequency(((Integer)aFullNDimensionalMatrix.getVal((ACoordinate<Attribute<IValue>, IValue>)aCoordinate).getValue()).doubleValue() / (double)n));
        });
        return gosplJointDistribution;
    }

    public AFullNDimensionalMatrix<Double> createDistribution(INDimensionalMatrix<Attribute<? extends IValue>, IValue, ? extends Number> iNDimensionalMatrix) {
        if (GSSurveyType.LocalFrequencyTable.equals((Object)iNDimensionalMatrix.getMetaDataType())) {
            throw new IllegalArgumentException("Cannot generate a full distribution from a " + String.valueOf((Object)GSSurveyType.LocalFrequencyTable));
        }
        GosplJointDistribution gosplJointDistribution = new GosplJointDistribution(iNDimensionalMatrix.getDimensions(), GSSurveyType.GlobalFrequencyTable);
        gosplJointDistribution.addGenesis("created from distribution GosplNDimensionalMatrixFactory@createDistribution");
        int n = (int)Math.round(iNDimensionalMatrix.getVal().getValue().doubleValue());
        iNDimensionalMatrix.getMatrix().keySet().stream().forEach(aCoordinate -> {
            boolean bl = gosplJointDistribution.setValue(aCoordinate, new ControlFrequency(((Number)iNDimensionalMatrix.getVal((IValue)aCoordinate).getValue()).doubleValue() / (double)n));
        });
        return gosplJointDistribution;
    }

    public AFullNDimensionalMatrix<Double> createDistribution(IPopulation<ADemoEntity, Attribute<? extends IValue>> iPopulation) {
        GosplJointDistribution gosplJointDistribution = new GosplJointDistribution(iPopulation.getPopulationAttributes(), GSSurveyType.GlobalFrequencyTable);
        gosplJointDistribution.addGenesis("created from population GosplNDimensionalMatrixFactory@createDistribution");
        double d = 1.0 / (double)iPopulation.size();
        for (ADemoEntity aDemoEntity : iPopulation) {
            GosplCoordinate gosplCoordinate = new GosplCoordinate(aDemoEntity.getAttributeMap());
            if (gosplJointDistribution.addValue(gosplCoordinate, new ControlFrequency(d))) continue;
            gosplJointDistribution.getVal(gosplCoordinate).add(d);
        }
        return gosplJointDistribution;
    }

    public AFullNDimensionalMatrix<Double> createDistribution(Set<Attribute<? extends IValue>> set, IPopulation<ADemoEntity, Attribute<? extends IValue>> iPopulation) {
        GosplJointDistribution gosplJointDistribution = new GosplJointDistribution(set, GSSurveyType.GlobalFrequencyTable);
        gosplJointDistribution.addGenesis("created from population GosplNDimensionalMatrixFactory@createDistribution");
        double d = 1.0 / (double)iPopulation.size();
        for (ADemoEntity aDemoEntity : iPopulation) {
            GosplCoordinate gosplCoordinate = new GosplCoordinate(aDemoEntity.getAttributeMap().entrySet().stream().filter(entry -> set.contains(entry.getKey())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue)));
            if (gosplJointDistribution.addValue(gosplCoordinate, new ControlFrequency(d))) continue;
            gosplJointDistribution.getVal(gosplCoordinate).add(d);
        }
        return gosplJointDistribution;
    }

    public AFullNDimensionalMatrix<Double> createDistribution(Map<ACoordinate<Attribute<? extends IValue>, IValue>, AControl<Double>> map) {
        return new GosplJointDistribution(map);
    }

    public AFullNDimensionalMatrix<Double> createDistribution(INDimensionalMatrix<Attribute<? extends IValue>, IValue, Double> iNDimensionalMatrix, GSPerformanceUtil gSPerformanceUtil) {
        if (!iNDimensionalMatrix.isSegmented()) {
            return this.createDistribution(iNDimensionalMatrix.getMatrix());
        }
        Set<Attribute<? extends IValue>> set = iNDimensionalMatrix.getDimensions().stream().filter(attribute -> attribute.getReferentAttribute().equals(attribute)).collect(Collectors.toSet());
        AFullNDimensionalMatrix<Double> aFullNDimensionalMatrix = new GosplNDimensionalMatrixFactory().createEmptyDistribution(set);
        gSPerformanceUtil.sysoStempMessage("Creation of matrix with attributes: " + Arrays.toString(set.toArray()));
        Collection<Map<Attribute<? extends IValue>, IValue>> collection = GSUtilAttribute.getValuesCombination(set);
        gSPerformanceUtil.sysoStempPerformance(1, (Object)this);
        gSPerformanceUtil.sysoStempMessage("Start writting down collpased distribution of size " + collection.size());
        for (Map<Attribute<? extends IValue>, IValue> map : collection) {
            AControl aControl = aFullNDimensionalMatrix.getNulVal();
            GosplCoordinate gosplCoordinate = new GosplCoordinate(map);
            AControl<Double> aControl2 = iNDimensionalMatrix.getVal((IValue)((Object)gosplCoordinate));
            if (!((Double)aControl.getValue()).equals(aControl2.getValue())) {
                aFullNDimensionalMatrix.addValue(gosplCoordinate, (Double)((Object)aControl2));
                continue;
            }
            gSPerformanceUtil.sysoStempMessage("Goes into a referent empty correlate: " + Arrays.toString(map.values().toArray()));
            GosplCoordinate gosplCoordinate2 = new GosplCoordinate(gosplCoordinate.getDimensions().stream().collect(Collectors.toMap(Function.identity(), attribute -> iNDimensionalMatrix.getEmptyReferentCorrelate(gosplCoordinate).stream().anyMatch(iValue -> iValue.getValueSpace().getAttribute().equals(attribute)) ? attribute.getValueSpace().getEmptyValue() : (IValue)gosplCoordinate.getMap().get(attribute))));
            if (gosplCoordinate2.equals(gosplCoordinate)) {
                aFullNDimensionalMatrix.addValue(gosplCoordinate, (Double)((Object)aControl2));
                continue;
            }
            aFullNDimensionalMatrix.addValue(gosplCoordinate2, (Double)((Object)iNDimensionalMatrix.getVal(gosplCoordinate2.values().stream().filter(iValue -> !((Attribute)iNDimensionalMatrix.getDimension((IValue)iValue)).getEmptyValue().equals(iValue)).collect(Collectors.toSet()))));
        }
        gSPerformanceUtil.sysoStempMessage("Distribution has been created succefuly");
        return aFullNDimensionalMatrix;
    }

    public AFullNDimensionalMatrix<Double> cloneDistribution(AFullNDimensionalMatrix<Double> aFullNDimensionalMatrix) {
        GosplJointDistribution gosplJointDistribution = new GosplJointDistribution(aFullNDimensionalMatrix.getDimensions(), GSSurveyType.GlobalFrequencyTable);
        aFullNDimensionalMatrix.getMatrix().keySet().forEach(aCoordinate -> {
            boolean bl = gosplJointDistribution.setValue(aCoordinate, new ControlFrequency((Double)aFullNDimensionalMatrix.getVal((ACoordinate<Attribute<IValue>, IValue>)aCoordinate).getValue()));
        });
        return gosplJointDistribution;
    }

    public ISegmentedNDimensionalMatrix<Double> createDistributionFromPopulations(Set<IPopulation<ADemoEntity, Attribute<? extends IValue>>> set) throws IllegalDistributionCreation {
        return new GosplConditionalDistribution(set.stream().map(this::createDistribution).collect(Collectors.toSet()));
    }

    public ASegmentedNDimensionalMatrix<Double> createDistributionFromDistributions(Set<AFullNDimensionalMatrix<Double>> set) throws IllegalDistributionCreation {
        return new GosplConditionalDistribution(set);
    }

    public ASegmentedNDimensionalMatrix<Double> createDistributionFromDistributions(AFullNDimensionalMatrix<Double> ... aFullNDimensionalMatrixArray) throws IllegalDistributionCreation {
        return this.createDistributionFromDistributions(new HashSet<AFullNDimensionalMatrix<Double>>(Arrays.asList(aFullNDimensionalMatrixArray)));
    }

    public AFullNDimensionalMatrix<Integer> createContingency(IPopulation<ADemoEntity, Attribute<? extends IValue>> iPopulation) {
        GosplContingencyTable gosplContingencyTable = new GosplContingencyTable(iPopulation.getPopulationAttributes());
        gosplContingencyTable.addGenesis("Created from a population GosplNDimensionalMatrixFactory@createContigency");
        for (ADemoEntity aDemoEntity : iPopulation) {
            GosplCoordinate gosplCoordinate = new GosplCoordinate(aDemoEntity.getAttributeMap());
            if (gosplContingencyTable.addValue(gosplCoordinate, new ControlContingency(1))) continue;
            gosplContingencyTable.getVal(gosplCoordinate).add(1);
        }
        return gosplContingencyTable;
    }

    public AFullNDimensionalMatrix<Integer> createContingency(Collection<? extends IEntity<? extends IAttribute<? extends IValue>>> collection) {
        Set<Attribute<? extends IValue>> set = collection.stream().flatMap(iEntity -> iEntity.getAttributes().stream()).map(iAttribute -> (Attribute)iAttribute).collect(Collectors.toSet());
        GosplContingencyTable gosplContingencyTable = new GosplContingencyTable(set);
        gosplContingencyTable.addGenesis("Created from a population GosplNDimensionalMatrixFactory@createContigency");
        for (IEntity<? extends IAttribute<? extends IValue>> iEntity2 : collection) {
            GosplCoordinate gosplCoordinate = new GosplCoordinate((Map<Attribute<? extends IValue>, IValue>)iEntity2.getAttributeMap());
            if (gosplContingencyTable.addValue(gosplCoordinate, new ControlContingency(1))) continue;
            gosplContingencyTable.getVal(gosplCoordinate).add(1);
        }
        return gosplContingencyTable;
    }

    public AFullNDimensionalMatrix<Integer> createContingency(Set<Attribute<? extends IValue>> set, IPopulation<ADemoEntity, Attribute<? extends IValue>> iPopulation) {
        Set<Attribute<? extends IValue>> set2 = set.stream().filter(attribute -> iPopulation.getPopulationAttributes().stream().anyMatch(attribute2 -> attribute2.isLinked((Attribute<? extends IValue>)attribute))).collect(Collectors.toSet());
        if (set2.isEmpty()) {
            throw new IllegalArgumentException("The given population must have at least one matching attribute with the set given in argument: \n" + set.stream().map(Attribute::getAttributeName).collect(Collectors.joining(";  ")) + "\n" + iPopulation.getPopulationAttributes().stream().map(Attribute::getAttributeName).collect(Collectors.joining(";  ")));
        }
        GosplContingencyTable gosplContingencyTable = new GosplContingencyTable(set2);
        gosplContingencyTable.addGenesis("created from a population GosplNDimensionalMatrixFactory@createContigency");
        GSPerformanceUtil gSPerformanceUtil = new GSPerformanceUtil("Create a contingency matrix from a population on " + set2.stream().map(Attribute::getAttributeName).collect(Collectors.joining("; ")) + " attribute set", GSPerformanceUtil.Level.TRACE);
        gSPerformanceUtil.sysoStempMessage("Test createContingency with given attributes: " + set2.stream().map(Attribute::getAttributeName).collect(Collectors.joining("; ")));
        Map map = set2.stream().collect(Collectors.toMap(Function.identity(), attribute -> iPopulation.getPopulationAttributes().stream().filter(attribute2 -> attribute2.isLinked((Attribute<? extends IValue>)attribute)).findFirst().get()));
        gSPerformanceUtil.sysoStempMessage("Attribute mapping from required to population : " + map.entrySet().stream().map(entry -> ((Attribute)entry.getKey()).getAttributeName() + "::" + ((Attribute)entry.getValue()).getAttributeName()).collect(Collectors.joining("; ")));
        for (ADemoEntity aDemoEntity : iPopulation) {
            Collection<ACoordinate<Attribute<IValue>, IValue>> collection = gosplContingencyTable.getOrCreateCoordinates(set2.stream().flatMap(attribute -> attribute.findMappedAttributeValues(aDemoEntity.getValueForAttribute((Attribute)map.get(attribute))).stream()).collect(Collectors.toSet()));
            for (ACoordinate<Attribute<? extends IValue>, IValue> aCoordinate : collection) {
                if (gosplContingencyTable.addValue(aCoordinate, new ControlContingency(1))) continue;
                gosplContingencyTable.getVal(aCoordinate).add(1);
            }
        }
        gSPerformanceUtil.sysoStempMessage("Output matrix dimensions are: " + gosplContingencyTable.getDimensions().stream().map(Attribute::getAttributeName).collect(Collectors.joining("; ")));
        return gosplContingencyTable;
    }

    public AFullNDimensionalMatrix<Integer> createContingency(INDimensionalMatrix<Attribute<? extends IValue>, IValue, Integer> iNDimensionalMatrix) {
        GosplContingencyTable gosplContingencyTable = new GosplContingencyTable(iNDimensionalMatrix.getDimensions());
        iNDimensionalMatrix.getMatrix().keySet().forEach(aCoordinate -> {
            boolean bl = gosplContingencyTable.addValue(aCoordinate, new ControlContingency((Integer)iNDimensionalMatrix.getVal((IValue)aCoordinate).getValue()));
        });
        return gosplContingencyTable;
    }

    public AFullNDimensionalMatrix<Integer> cloneContingency(AFullNDimensionalMatrix<Integer> aFullNDimensionalMatrix) {
        Map<ACoordinate<Attribute<IValue>, IValue>, AControl<Integer>> map = aFullNDimensionalMatrix.getMatrix();
        return new GosplContingencyTable(map.keySet().stream().collect(Collectors.toMap(Function.identity(), aCoordinate -> new ControlContingency((Integer)((AControl)map.get(aCoordinate)).getValue()))));
    }

    public AFullNDimensionalMatrix<Integer> cloneContingency(Set<Attribute<? extends IValue>> set, AFullNDimensionalMatrix<Integer> aFullNDimensionalMatrix) {
        if (!aFullNDimensionalMatrix.getDimensions().containsAll(set)) {
            throw new IllegalArgumentException("Cannot reduce a contingency to unknown attributes: " + set.stream().filter(attribute -> !aFullNDimensionalMatrix.getDimensions().contains(attribute)).map(Attribute::getAttributeName).collect(Collectors.joining("; ")));
        }
        AFullNDimensionalMatrix<Integer> aFullNDimensionalMatrix2 = this.createEmtpyContingencies(set, true);
        Map<ACoordinate<Attribute<IValue>, IValue>, AControl<Integer>> map = aFullNDimensionalMatrix2.getMatrix();
        map.keySet().forEach(aCoordinate -> {
            boolean bl = aFullNDimensionalMatrix2.setValue(aCoordinate, (Integer)((Object)aFullNDimensionalMatrix.getVal(aCoordinate.values())));
        });
        return aFullNDimensionalMatrix2;
    }

    public AFullNDimensionalMatrix<Integer> fillInContingency(AFullNDimensionalMatrix<Integer> aFullNDimensionalMatrix, IPopulation<ADemoEntity, Attribute<? extends IValue>> iPopulation) {
        Set set = aFullNDimensionalMatrix.getDimensions().stream().filter(attribute -> iPopulation.getPopulationAttributes().stream().anyMatch(attribute2 -> !attribute2.equals(attribute) && attribute2.isLinked((Attribute<? extends IValue>)attribute))).collect(Collectors.toSet());
        for (ADemoEntity aDemoEntity : iPopulation) {
            Collection collection = aDemoEntity.getValues().stream().filter(iValue -> aFullNDimensionalMatrix.getAspects().contains(iValue)).collect(Collectors.toSet());
            Collection collection2 = set.stream().flatMap(attribute -> attribute.findMappedAttributeValues(aDemoEntity.getValueForAttribute(aDemoEntity.getAttributes().stream().filter(attribute2 -> attribute2.isLinked((Attribute<? extends IValue>)attribute)).findFirst().get())).stream()).collect(Collectors.toSet());
            if (collection2.stream().anyMatch(iValue -> !aFullNDimensionalMatrix.getAspects().contains(iValue))) {
                throw new IllegalNDimensionalMatrixAccess("Try to access to a coordinates related to one of these values: " + Arrays.asList(collection2).toString() + " but matrix values are: " + Arrays.asList(aFullNDimensionalMatrix.getAspects()).toString());
            }
            aFullNDimensionalMatrix.getVal(Stream.concat(collection.stream(), collection2.stream()).collect(Collectors.toSet()), true).add(1);
        }
        return aFullNDimensionalMatrix;
    }

    public AFullNDimensionalMatrix<Integer> createSample(Set<Attribute<? extends IValue>> set, IPopulation<ADemoEntity, Attribute<? extends IValue>> iPopulation) {
        GosplContingencyTable gosplContingencyTable = new GosplContingencyTable(set);
        gosplContingencyTable.addGenesis("created from a population GosplNDimensionalMatrixFactory@createContigency");
        for (ADemoEntity aDemoEntity : iPopulation) {
            GosplCoordinate gosplCoordinate = new GosplCoordinate(aDemoEntity.getAttributeMap());
            if (gosplContingencyTable.addValue(gosplCoordinate, new ControlContingency(1))) continue;
            gosplContingencyTable.getVal(gosplCoordinate).add(1);
        }
        return gosplContingencyTable;
    }
}

